/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import shadow.palantir.driver.com.google.common.base.Suppliers;
import shadow.palantir.driver.com.google.common.util.concurrent.ThreadFactoryBuilder;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueExecutors;
import shadow.palantir.driver.com.palantir.tritium.metrics.MetricRegistries;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.SharedTaggedMetricRegistries;
import shadow.palantir.driver.org.apache.hc.core5.pool.ConnPoolControl;

final class ScheduledIdleConnectionEvictor {
    private static final SafeLogger log = SafeLoggerFactory.get(ScheduledIdleConnectionEvictor.class);
    private static final String EXECUTOR_NAME = "DialogueIdleConnectionEvictor";
    private static final Supplier<ScheduledExecutorService> sharedScheduler = Suppliers.memoize(() -> MetricRegistries.instrument(SharedTaggedMetricRegistries.getSingleton(), DialogueExecutors.newSharedSingleThreadScheduler(MetricRegistries.instrument(SharedTaggedMetricRegistries.getSingleton(), new ThreadFactoryBuilder().setNameFormat("DialogueIdleConnectionEvictor-%d").setDaemon(true).build(), EXECUTOR_NAME)), EXECUTOR_NAME));

    static ScheduledFuture<?> schedule(ConnPoolControl<?> connectionManager, Duration delayBetweenChecks) {
        return ScheduledIdleConnectionEvictor.schedule(connectionManager, delayBetweenChecks, sharedScheduler.get());
    }

    private static ScheduledFuture<?> schedule(ConnPoolControl<?> connectionManager, Duration delayBetweenChecks, ScheduledExecutorService scheduler) {
        return scheduler.scheduleWithFixedDelay(() -> {
            try {
                connectionManager.closeExpired();
            }
            catch (Error | RuntimeException e) {
                log.warn("Exception caught while evicting idle connections", e);
            }
        }, delayBetweenChecks.toMillis(), delayBetweenChecks.toMillis(), TimeUnit.MILLISECONDS);
    }

    private ScheduledIdleConnectionEvictor() {
    }
}

