/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import shadow.palantir.driver.com.google.common.base.CharMatcher;
import shadow.palantir.driver.com.google.common.base.Splitter;
import shadow.palantir.driver.com.google.common.base.Strings;

final class ServerTimingParser {
    private static final SafeLogger log = SafeLoggerFactory.get(ServerTimingParser.class);
    private static final Splitter METRIC_SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();
    private static final CharMatcher NUMERIC_MATCHER = CharMatcher.inRange('0', '9').or(CharMatcher.anyOf("-."));
    private static final String DURATION = ";dur=";
    private static final long NANOSECONDS_PER_MILLISECOND = 1000000L;
    static final long UNKNOWN = -1L;

    static long getServerDurationNanos(String serverTimingValue, String operation) {
        if (Strings.isNullOrEmpty(serverTimingValue) || !serverTimingValue.contains(operation)) {
            return -1L;
        }
        try {
            for (String segment : METRIC_SPLITTER.split(serverTimingValue)) {
                if (segment.length() <= operation.length() + DURATION.length() || !segment.startsWith(operation) || segment.charAt(operation.length()) != ';') continue;
                int durationStart = segment.indexOf(DURATION);
                if (durationStart < 0) {
                    return -1L;
                }
                int durationValueStart = durationStart + DURATION.length();
                int durationValueEnd = ServerTimingParser.findNumericSequenceEnd(segment, durationValueStart);
                String durationValue = segment.substring(durationValueStart, durationValueEnd);
                double durationMilliseconds = Double.parseDouble(durationValue);
                return (long)(1000000.0 * durationMilliseconds);
            }
        }
        catch (RuntimeException e) {
            log.warn("Failed to parse Server-Timing value '{}'", SafeArg.of("serverTiming", serverTimingValue), (Throwable)e);
        }
        return -1L;
    }

    private static int findNumericSequenceEnd(String string, int beginIndex) {
        int currentIndex;
        for (currentIndex = beginIndex; currentIndex < string.length() && NUMERIC_MATCHER.matches(string.charAt(currentIndex)); ++currentIndex) {
        }
        return currentIndex;
    }

    private ServerTimingParser() {
    }
}

