/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.paging;

import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import shadow.palantir.driver.com.palantir.foundry.paging.internal.FlatMapSpliterator;
import shadow.palantir.driver.com.palantir.foundry.paging.internal.PageSpliterator;

public final class Paging {
    private Paging() {
    }

    public static <PageT, T, TokenT> Stream<T> stream(Function<PageT, Iterable<T>> valuesExtractor, Function<PageT, Optional<TokenT>> tokenExtractor, Function<Optional<TokenT>, PageT> pageSupplier) {
        return Paging.stream(valuesExtractor, tokenExtractor, pageSupplier, Optional.empty());
    }

    public static <PageT, T, TokenT> Stream<T> stream(Function<PageT, Iterable<T>> valuesExtractor, Function<PageT, Optional<TokenT>> tokenExtractor, Function<Optional<TokenT>, PageT> pageSupplier, Optional<TokenT> initialToken) {
        return Paging.spliteratorToStream(Paging.valueSpliterator(valuesExtractor, tokenExtractor, pageSupplier, initialToken));
    }

    public static <PageT, T, TokenT> Iterable<T> iterable(Function<PageT, Iterable<T>> valuesExtractor, Function<PageT, Optional<TokenT>> tokenExtractor, Function<Optional<TokenT>, PageT> pageSupplier) {
        return Paging.iterable(valuesExtractor, tokenExtractor, pageSupplier, Optional.empty());
    }

    public static <PageT, T, TokenT> Iterable<T> iterable(Function<PageT, Iterable<T>> valuesExtractor, Function<PageT, Optional<TokenT>> tokenExtractor, Function<Optional<TokenT>, PageT> pageSupplier, Optional<TokenT> initialToken) {
        return Paging.spliteratorToIterable(Paging.valueSpliterator(valuesExtractor, tokenExtractor, pageSupplier, initialToken));
    }

    private static <PageT, T, TokenT> Spliterator<T> valueSpliterator(Function<PageT, Iterable<T>> valuesExtractor, Function<PageT, Optional<TokenT>> tokenExtractor, Function<Optional<TokenT>, PageT> pageSupplier, Optional<TokenT> initialToken) {
        return new FlatMapSpliterator(Paging.streamOfPages(tokenExtractor, pageSupplier, initialToken).map(valuesExtractor).iterator());
    }

    private static <PageT, TokenT> Stream<PageT> streamOfPages(Function<PageT, Optional<TokenT>> tokenExtractor, Function<Optional<TokenT>, PageT> pageSupplier, Optional<TokenT> initialToken) {
        Spliterator<PageT> spliterator = PageSpliterator.spliterator(tokenExtractor, pageSupplier, initialToken);
        return Paging.spliteratorToStream(spliterator);
    }

    private static <T> Stream<T> spliteratorToStream(Spliterator<T> spliterator) {
        return StreamSupport.stream(spliterator, false);
    }

    private static <T> Iterable<T> spliteratorToIterable(Spliterator<T> spliterator) {
        return () -> Spliterators.iterator(spliterator);
    }
}

