/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.paging.internal;

import java.util.Optional;
import java.util.function.Function;
import shadow.palantir.driver.com.palantir.foundry.paging.internal.BetterIterator;

public final class PageIterator<PageT, TokenT>
implements BetterIterator<PageT> {
    private final Function<Optional<TokenT>, PageT> pageSupplier;
    private final Function<PageT, Optional<TokenT>> tokenExtractor;
    private Optional<TokenT> nextToken;
    private boolean finished = false;

    public PageIterator(Function<Optional<TokenT>, PageT> pageSupplier, Function<PageT, Optional<TokenT>> tokenExtractor) {
        this(pageSupplier, tokenExtractor, Optional.empty());
    }

    public PageIterator(Function<Optional<TokenT>, PageT> pageSupplier, Function<PageT, Optional<TokenT>> tokenExtractor, Optional<TokenT> initialToken) {
        this.pageSupplier = pageSupplier;
        this.tokenExtractor = tokenExtractor;
        this.nextToken = initialToken;
    }

    @Override
    public Optional<PageT> next() {
        if (this.finished) {
            return Optional.empty();
        }
        PageT page = this.pageSupplier.apply(this.nextToken);
        this.nextToken = this.tokenExtractor.apply(page);
        this.finished = !this.nextToken.isPresent();
        return Optional.of(page);
    }
}

