/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.schemas.api.types;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldType;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=Builder.class)
public final class FoundryFieldSchema {
    private final FoundryFieldType type;
    private final Optional<String> name;
    private final Optional<Boolean> nullable;
    private final Optional<String> userDefinedTypeClass;
    private final Map<String, Object> customMetadata;
    private final Optional<FoundryFieldSchema> arraySubtype;
    private final OptionalInt precision;
    private final OptionalInt scale;
    private final Optional<FoundryFieldSchema> mapKeyType;
    private final Optional<FoundryFieldSchema> mapValueType;
    private final Optional<List<FoundryFieldSchema>> subSchemas;
    private int memoizedHashCode;

    private FoundryFieldSchema(FoundryFieldType type, Optional<String> name, Optional<Boolean> nullable, Optional<String> userDefinedTypeClass, Map<String, Object> customMetadata, Optional<FoundryFieldSchema> arraySubtype, OptionalInt precision, OptionalInt scale, Optional<FoundryFieldSchema> mapKeyType, Optional<FoundryFieldSchema> mapValueType, Optional<List<FoundryFieldSchema>> subSchemas) {
        FoundryFieldSchema.validateFields(type, name, nullable, userDefinedTypeClass, customMetadata, arraySubtype, precision, scale, mapKeyType, mapValueType, subSchemas);
        this.type = type;
        this.name = name;
        this.nullable = nullable;
        this.userDefinedTypeClass = userDefinedTypeClass;
        this.customMetadata = Collections.unmodifiableMap(customMetadata);
        this.arraySubtype = arraySubtype;
        this.precision = precision;
        this.scale = scale;
        this.mapKeyType = mapKeyType;
        this.mapValueType = mapValueType;
        this.subSchemas = subSchemas;
    }

    @JsonProperty(value="type")
    public FoundryFieldType getType() {
        return this.type;
    }

    @JsonProperty(value="name")
    @Unsafe
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="nullable")
    @Safe
    public Optional<Boolean> getNullable() {
        return this.nullable;
    }

    @JsonProperty(value="userDefinedTypeClass")
    @Unsafe
    public Optional<String> getUserDefinedTypeClass() {
        return this.userDefinedTypeClass;
    }

    @JsonProperty(value="customMetadata")
    public Map<String, Object> getCustomMetadata() {
        return this.customMetadata;
    }

    @JsonProperty(value="arraySubtype")
    public Optional<FoundryFieldSchema> getArraySubtype() {
        return this.arraySubtype;
    }

    @JsonProperty(value="precision")
    @Safe
    public OptionalInt getPrecision() {
        return this.precision;
    }

    @JsonProperty(value="scale")
    @Safe
    public OptionalInt getScale() {
        return this.scale;
    }

    @JsonProperty(value="mapKeyType")
    public Optional<FoundryFieldSchema> getMapKeyType() {
        return this.mapKeyType;
    }

    @JsonProperty(value="mapValueType")
    public Optional<FoundryFieldSchema> getMapValueType() {
        return this.mapValueType;
    }

    @JsonProperty(value="subSchemas")
    public Optional<List<FoundryFieldSchema>> getSubSchemas() {
        return this.subSchemas;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof FoundryFieldSchema && this.equalTo((FoundryFieldSchema)other);
    }

    private boolean equalTo(FoundryFieldSchema other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.type.equals(other.type) && this.name.equals(other.name) && this.nullable.equals(other.nullable) && this.userDefinedTypeClass.equals(other.userDefinedTypeClass) && this.customMetadata.equals(other.customMetadata) && this.arraySubtype.equals(other.arraySubtype) && this.precision.equals(other.precision) && this.scale.equals(other.scale) && this.mapKeyType.equals(other.mapKeyType) && this.mapValueType.equals(other.mapValueType) && this.subSchemas.equals(other.subSchemas);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.type.hashCode();
            hash = 31 * hash + this.name.hashCode();
            hash = 31 * hash + this.nullable.hashCode();
            hash = 31 * hash + this.userDefinedTypeClass.hashCode();
            hash = 31 * hash + this.customMetadata.hashCode();
            hash = 31 * hash + this.arraySubtype.hashCode();
            hash = 31 * hash + this.precision.hashCode();
            hash = 31 * hash + this.scale.hashCode();
            hash = 31 * hash + this.mapKeyType.hashCode();
            hash = 31 * hash + this.mapValueType.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.subSchemas.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "FoundryFieldSchema{type: " + this.type + ", name: " + this.name + ", nullable: " + this.nullable + ", userDefinedTypeClass: " + this.userDefinedTypeClass + ", customMetadata: " + this.customMetadata + ", arraySubtype: " + this.arraySubtype + ", precision: " + this.precision + ", scale: " + this.scale + ", mapKeyType: " + this.mapKeyType + ", mapValueType: " + this.mapValueType + ", subSchemas: " + this.subSchemas + "}";
    }

    private static void validateFields(FoundryFieldType type, Optional<String> name, Optional<Boolean> nullable, Optional<String> userDefinedTypeClass, Map<String, Object> customMetadata, Optional<FoundryFieldSchema> arraySubtype, OptionalInt precision, OptionalInt scale, Optional<FoundryFieldSchema> mapKeyType, Optional<FoundryFieldSchema> mapValueType, Optional<List<FoundryFieldSchema>> subSchemas) {
        List<String> missingFields = null;
        missingFields = FoundryFieldSchema.addFieldIfMissing(missingFields, type, "type");
        missingFields = FoundryFieldSchema.addFieldIfMissing(missingFields, name, "name");
        missingFields = FoundryFieldSchema.addFieldIfMissing(missingFields, nullable, "nullable");
        missingFields = FoundryFieldSchema.addFieldIfMissing(missingFields, userDefinedTypeClass, "userDefinedTypeClass");
        missingFields = FoundryFieldSchema.addFieldIfMissing(missingFields, customMetadata, "customMetadata");
        missingFields = FoundryFieldSchema.addFieldIfMissing(missingFields, arraySubtype, "arraySubtype");
        missingFields = FoundryFieldSchema.addFieldIfMissing(missingFields, precision, "precision");
        missingFields = FoundryFieldSchema.addFieldIfMissing(missingFields, scale, "scale");
        missingFields = FoundryFieldSchema.addFieldIfMissing(missingFields, mapKeyType, "mapKeyType");
        missingFields = FoundryFieldSchema.addFieldIfMissing(missingFields, mapValueType, "mapValueType");
        if ((missingFields = FoundryFieldSchema.addFieldIfMissing(missingFields, subSchemas, "subSchemas")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(11);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private FoundryFieldType type;
        private Optional<@Unsafe String> name = Optional.empty();
        private Optional<@Safe Boolean> nullable = Optional.empty();
        private Optional<@Unsafe String> userDefinedTypeClass = Optional.empty();
        private Map<String, Object> customMetadata = new LinkedHashMap<String, Object>();
        private Optional<FoundryFieldSchema> arraySubtype = Optional.empty();
        @Safe
        private OptionalInt precision = OptionalInt.empty();
        @Safe
        private OptionalInt scale = OptionalInt.empty();
        private Optional<FoundryFieldSchema> mapKeyType = Optional.empty();
        private Optional<FoundryFieldSchema> mapValueType = Optional.empty();
        private Optional<List<FoundryFieldSchema>> subSchemas = Optional.empty();

        private Builder() {
        }

        public Builder from(FoundryFieldSchema other) {
            this.checkNotBuilt();
            this.type(other.getType());
            this.name(other.getName());
            this.nullable(other.getNullable());
            this.userDefinedTypeClass(other.getUserDefinedTypeClass());
            this.customMetadata(other.getCustomMetadata());
            this.arraySubtype(other.getArraySubtype());
            this.precision(other.getPrecision());
            this.scale(other.getScale());
            this.mapKeyType(other.getMapKeyType());
            this.mapValueType(other.getMapValueType());
            this.subSchemas(other.getSubSchemas());
            return this;
        }

        @JsonSetter(value="type")
        public Builder type(@Nonnull FoundryFieldType type) {
            this.checkNotBuilt();
            this.type = Preconditions.checkNotNull(type, "type cannot be null");
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(@Nonnull Optional<@Unsafe String> name) {
            this.checkNotBuilt();
            this.name = Preconditions.checkNotNull(name, "name cannot be null");
            return this;
        }

        public Builder name(@Nonnull @Unsafe String name) {
            this.checkNotBuilt();
            this.name = Optional.of(Preconditions.checkNotNull(name, "name cannot be null"));
            return this;
        }

        @JsonSetter(value="nullable", nulls=Nulls.SKIP)
        public Builder nullable(@Nonnull Optional<@Safe Boolean> nullable) {
            this.checkNotBuilt();
            this.nullable = Preconditions.checkNotNull(nullable, "nullable cannot be null");
            return this;
        }

        public Builder nullable(@Safe boolean nullable) {
            this.checkNotBuilt();
            this.nullable = Optional.of(nullable);
            return this;
        }

        @JsonSetter(value="userDefinedTypeClass", nulls=Nulls.SKIP)
        public Builder userDefinedTypeClass(@Nonnull Optional<@Unsafe String> userDefinedTypeClass) {
            this.checkNotBuilt();
            this.userDefinedTypeClass = Preconditions.checkNotNull(userDefinedTypeClass, "userDefinedTypeClass cannot be null");
            return this;
        }

        public Builder userDefinedTypeClass(@Nonnull @Unsafe String userDefinedTypeClass) {
            this.checkNotBuilt();
            this.userDefinedTypeClass = Optional.of(Preconditions.checkNotNull(userDefinedTypeClass, "userDefinedTypeClass cannot be null"));
            return this;
        }

        @JsonSetter(value="customMetadata", nulls=Nulls.SKIP)
        public Builder customMetadata(@Nonnull Map<String, Object> customMetadata) {
            this.checkNotBuilt();
            this.customMetadata = new LinkedHashMap<String, Object>(Preconditions.checkNotNull(customMetadata, "customMetadata cannot be null"));
            return this;
        }

        public Builder putAllCustomMetadata(@Nonnull Map<String, Object> customMetadata) {
            this.checkNotBuilt();
            this.customMetadata.putAll(Preconditions.checkNotNull(customMetadata, "customMetadata cannot be null"));
            return this;
        }

        public Builder customMetadata(String key, Object value) {
            this.checkNotBuilt();
            this.customMetadata.put(key, value);
            return this;
        }

        @JsonSetter(value="arraySubtype", nulls=Nulls.SKIP)
        public Builder arraySubtype(@Nonnull Optional<FoundryFieldSchema> arraySubtype) {
            this.checkNotBuilt();
            this.arraySubtype = Preconditions.checkNotNull(arraySubtype, "arraySubtype cannot be null");
            return this;
        }

        public Builder arraySubtype(@Nonnull FoundryFieldSchema arraySubtype) {
            this.checkNotBuilt();
            this.arraySubtype = Optional.of(Preconditions.checkNotNull(arraySubtype, "arraySubtype cannot be null"));
            return this;
        }

        @JsonSetter(value="precision", nulls=Nulls.SKIP)
        public Builder precision(@Nonnull @Safe OptionalInt precision) {
            this.checkNotBuilt();
            this.precision = Preconditions.checkNotNull(precision, "precision cannot be null");
            return this;
        }

        public Builder precision(@Safe int precision) {
            this.checkNotBuilt();
            this.precision = OptionalInt.of(precision);
            return this;
        }

        @JsonSetter(value="scale", nulls=Nulls.SKIP)
        public Builder scale(@Nonnull @Safe OptionalInt scale) {
            this.checkNotBuilt();
            this.scale = Preconditions.checkNotNull(scale, "scale cannot be null");
            return this;
        }

        public Builder scale(@Safe int scale) {
            this.checkNotBuilt();
            this.scale = OptionalInt.of(scale);
            return this;
        }

        @JsonSetter(value="mapKeyType", nulls=Nulls.SKIP)
        public Builder mapKeyType(@Nonnull Optional<FoundryFieldSchema> mapKeyType) {
            this.checkNotBuilt();
            this.mapKeyType = Preconditions.checkNotNull(mapKeyType, "mapKeyType cannot be null");
            return this;
        }

        public Builder mapKeyType(@Nonnull FoundryFieldSchema mapKeyType) {
            this.checkNotBuilt();
            this.mapKeyType = Optional.of(Preconditions.checkNotNull(mapKeyType, "mapKeyType cannot be null"));
            return this;
        }

        @JsonSetter(value="mapValueType", nulls=Nulls.SKIP)
        public Builder mapValueType(@Nonnull Optional<FoundryFieldSchema> mapValueType) {
            this.checkNotBuilt();
            this.mapValueType = Preconditions.checkNotNull(mapValueType, "mapValueType cannot be null");
            return this;
        }

        public Builder mapValueType(@Nonnull FoundryFieldSchema mapValueType) {
            this.checkNotBuilt();
            this.mapValueType = Optional.of(Preconditions.checkNotNull(mapValueType, "mapValueType cannot be null"));
            return this;
        }

        @JsonSetter(value="subSchemas", nulls=Nulls.SKIP)
        public Builder subSchemas(@Nonnull Optional<? extends List<FoundryFieldSchema>> subSchemas) {
            this.checkNotBuilt();
            this.subSchemas = Preconditions.checkNotNull(subSchemas, "subSchemas cannot be null").map(Function.identity());
            return this;
        }

        public Builder subSchemas(@Nonnull List<FoundryFieldSchema> subSchemas) {
            this.checkNotBuilt();
            this.subSchemas = Optional.of(Preconditions.checkNotNull(subSchemas, "subSchemas cannot be null"));
            return this;
        }

        public FoundryFieldSchema build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new FoundryFieldSchema(this.type, this.name, this.nullable, this.userDefinedTypeClass, this.customMetadata, this.arraySubtype, this.precision, this.scale, this.mapKeyType, this.mapValueType, this.subSchemas);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

