/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.schemas.api.types;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.google.errorprone.annotations.Immutable;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
@Immutable
public final class FoundryFieldType {
    public static final FoundryFieldType ARRAY = new FoundryFieldType(Value.ARRAY, "ARRAY");
    public static final FoundryFieldType DECIMAL = new FoundryFieldType(Value.DECIMAL, "DECIMAL");
    public static final FoundryFieldType MAP = new FoundryFieldType(Value.MAP, "MAP");
    public static final FoundryFieldType STRUCT = new FoundryFieldType(Value.STRUCT, "STRUCT");
    public static final FoundryFieldType LONG = new FoundryFieldType(Value.LONG, "LONG");
    public static final FoundryFieldType BINARY = new FoundryFieldType(Value.BINARY, "BINARY");
    public static final FoundryFieldType BOOLEAN = new FoundryFieldType(Value.BOOLEAN, "BOOLEAN");
    public static final FoundryFieldType BYTE = new FoundryFieldType(Value.BYTE, "BYTE");
    public static final FoundryFieldType DATE = new FoundryFieldType(Value.DATE, "DATE");
    public static final FoundryFieldType DOUBLE = new FoundryFieldType(Value.DOUBLE, "DOUBLE");
    public static final FoundryFieldType FLOAT = new FoundryFieldType(Value.FLOAT, "FLOAT");
    public static final FoundryFieldType INTEGER = new FoundryFieldType(Value.INTEGER, "INTEGER");
    public static final FoundryFieldType SHORT = new FoundryFieldType(Value.SHORT, "SHORT");
    public static final FoundryFieldType STRING = new FoundryFieldType(Value.STRING, "STRING");
    public static final FoundryFieldType TIMESTAMP = new FoundryFieldType(Value.TIMESTAMP, "TIMESTAMP");
    private static final List<FoundryFieldType> values = Collections.unmodifiableList(Arrays.asList(ARRAY, DECIMAL, MAP, STRUCT, LONG, BINARY, BOOLEAN, BYTE, DATE, DOUBLE, FLOAT, INTEGER, SHORT, STRING, TIMESTAMP));
    private final Value value;
    private final String string;

    private FoundryFieldType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value get() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || this.value == Value.UNKNOWN && other instanceof FoundryFieldType && this.string.equals(((FoundryFieldType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static FoundryFieldType valueOf(@Nonnull @Safe String value) {
        String upperCasedValue;
        Preconditions.checkNotNull(value, "value cannot be null");
        switch (upperCasedValue = value.toUpperCase(Locale.ROOT)) {
            case "ARRAY": {
                return ARRAY;
            }
            case "DECIMAL": {
                return DECIMAL;
            }
            case "MAP": {
                return MAP;
            }
            case "STRUCT": {
                return STRUCT;
            }
            case "LONG": {
                return LONG;
            }
            case "BINARY": {
                return BINARY;
            }
            case "BOOLEAN": {
                return BOOLEAN;
            }
            case "BYTE": {
                return BYTE;
            }
            case "DATE": {
                return DATE;
            }
            case "DOUBLE": {
                return DOUBLE;
            }
            case "FLOAT": {
                return FLOAT;
            }
            case "INTEGER": {
                return INTEGER;
            }
            case "SHORT": {
                return SHORT;
            }
            case "STRING": {
                return STRING;
            }
            case "TIMESTAMP": {
                return TIMESTAMP;
            }
        }
        return new FoundryFieldType(Value.UNKNOWN, upperCasedValue);
    }

    public <T> T accept(Visitor<T> visitor) {
        switch (this.value) {
            case ARRAY: {
                return visitor.visitArray();
            }
            case DECIMAL: {
                return visitor.visitDecimal();
            }
            case MAP: {
                return visitor.visitMap();
            }
            case STRUCT: {
                return visitor.visitStruct();
            }
            case LONG: {
                return visitor.visitLong();
            }
            case BINARY: {
                return visitor.visitBinary();
            }
            case BOOLEAN: {
                return visitor.visitBoolean();
            }
            case BYTE: {
                return visitor.visitByte();
            }
            case DATE: {
                return visitor.visitDate();
            }
            case DOUBLE: {
                return visitor.visitDouble();
            }
            case FLOAT: {
                return visitor.visitFloat();
            }
            case INTEGER: {
                return visitor.visitInteger();
            }
            case SHORT: {
                return visitor.visitShort();
            }
            case STRING: {
                return visitor.visitString();
            }
            case TIMESTAMP: {
                return visitor.visitTimestamp();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    public static List<FoundryFieldType> values() {
        return values;
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface TimestampStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> visitTimestamp(@Nonnull Supplier<T> var1);
    }

    public static interface StringStageVisitorBuilder<T> {
        public TimestampStageVisitorBuilder<T> visitString(@Nonnull Supplier<T> var1);
    }

    public static interface ShortStageVisitorBuilder<T> {
        public StringStageVisitorBuilder<T> visitShort(@Nonnull Supplier<T> var1);
    }

    public static interface IntegerStageVisitorBuilder<T> {
        public ShortStageVisitorBuilder<T> visitInteger(@Nonnull Supplier<T> var1);
    }

    public static interface FloatStageVisitorBuilder<T> {
        public IntegerStageVisitorBuilder<T> visitFloat(@Nonnull Supplier<T> var1);
    }

    public static interface DoubleStageVisitorBuilder<T> {
        public FloatStageVisitorBuilder<T> visitDouble(@Nonnull Supplier<T> var1);
    }

    public static interface DateStageVisitorBuilder<T> {
        public DoubleStageVisitorBuilder<T> visitDate(@Nonnull Supplier<T> var1);
    }

    public static interface ByteStageVisitorBuilder<T> {
        public DateStageVisitorBuilder<T> visitByte(@Nonnull Supplier<T> var1);
    }

    public static interface BooleanStageVisitorBuilder<T> {
        public ByteStageVisitorBuilder<T> visitBoolean(@Nonnull Supplier<T> var1);
    }

    public static interface BinaryStageVisitorBuilder<T> {
        public BooleanStageVisitorBuilder<T> visitBinary(@Nonnull Supplier<T> var1);
    }

    public static interface LongStageVisitorBuilder<T> {
        public BinaryStageVisitorBuilder<T> visitLong(@Nonnull Supplier<T> var1);
    }

    public static interface StructStageVisitorBuilder<T> {
        public LongStageVisitorBuilder<T> visitStruct(@Nonnull Supplier<T> var1);
    }

    public static interface MapStageVisitorBuilder<T> {
        public StructStageVisitorBuilder<T> visitMap(@Nonnull Supplier<T> var1);
    }

    public static interface DecimalStageVisitorBuilder<T> {
        public MapStageVisitorBuilder<T> visitDecimal(@Nonnull Supplier<T> var1);
    }

    public static interface ArrayStageVisitorBuilder<T> {
        public DecimalStageVisitorBuilder<T> visitArray(@Nonnull Supplier<T> var1);
    }

    private static final class VisitorBuilder<T>
    implements ArrayStageVisitorBuilder<T>,
    DecimalStageVisitorBuilder<T>,
    MapStageVisitorBuilder<T>,
    StructStageVisitorBuilder<T>,
    LongStageVisitorBuilder<T>,
    BinaryStageVisitorBuilder<T>,
    BooleanStageVisitorBuilder<T>,
    ByteStageVisitorBuilder<T>,
    DateStageVisitorBuilder<T>,
    DoubleStageVisitorBuilder<T>,
    FloatStageVisitorBuilder<T>,
    IntegerStageVisitorBuilder<T>,
    ShortStageVisitorBuilder<T>,
    StringStageVisitorBuilder<T>,
    TimestampStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Supplier<T> arrayVisitor;
        private Supplier<T> decimalVisitor;
        private Supplier<T> mapVisitor;
        private Supplier<T> structVisitor;
        private Supplier<T> longVisitor;
        private Supplier<T> binaryVisitor;
        private Supplier<T> booleanVisitor;
        private Supplier<T> byteVisitor;
        private Supplier<T> dateVisitor;
        private Supplier<T> doubleVisitor;
        private Supplier<T> floatVisitor;
        private Supplier<T> integerVisitor;
        private Supplier<T> shortVisitor;
        private Supplier<T> stringVisitor;
        private Supplier<T> timestampVisitor;
        private Function<@Safe String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public DecimalStageVisitorBuilder<T> visitArray(@Nonnull Supplier<T> arrayVisitor) {
            Preconditions.checkNotNull(arrayVisitor, "arrayVisitor cannot be null");
            this.arrayVisitor = arrayVisitor;
            return this;
        }

        @Override
        public MapStageVisitorBuilder<T> visitDecimal(@Nonnull Supplier<T> decimalVisitor) {
            Preconditions.checkNotNull(decimalVisitor, "decimalVisitor cannot be null");
            this.decimalVisitor = decimalVisitor;
            return this;
        }

        @Override
        public StructStageVisitorBuilder<T> visitMap(@Nonnull Supplier<T> mapVisitor) {
            Preconditions.checkNotNull(mapVisitor, "mapVisitor cannot be null");
            this.mapVisitor = mapVisitor;
            return this;
        }

        @Override
        public LongStageVisitorBuilder<T> visitStruct(@Nonnull Supplier<T> structVisitor) {
            Preconditions.checkNotNull(structVisitor, "structVisitor cannot be null");
            this.structVisitor = structVisitor;
            return this;
        }

        @Override
        public BinaryStageVisitorBuilder<T> visitLong(@Nonnull Supplier<T> longVisitor) {
            Preconditions.checkNotNull(longVisitor, "longVisitor cannot be null");
            this.longVisitor = longVisitor;
            return this;
        }

        @Override
        public BooleanStageVisitorBuilder<T> visitBinary(@Nonnull Supplier<T> binaryVisitor) {
            Preconditions.checkNotNull(binaryVisitor, "binaryVisitor cannot be null");
            this.binaryVisitor = binaryVisitor;
            return this;
        }

        @Override
        public ByteStageVisitorBuilder<T> visitBoolean(@Nonnull Supplier<T> booleanVisitor) {
            Preconditions.checkNotNull(booleanVisitor, "booleanVisitor cannot be null");
            this.booleanVisitor = booleanVisitor;
            return this;
        }

        @Override
        public DateStageVisitorBuilder<T> visitByte(@Nonnull Supplier<T> byteVisitor) {
            Preconditions.checkNotNull(byteVisitor, "byteVisitor cannot be null");
            this.byteVisitor = byteVisitor;
            return this;
        }

        @Override
        public DoubleStageVisitorBuilder<T> visitDate(@Nonnull Supplier<T> dateVisitor) {
            Preconditions.checkNotNull(dateVisitor, "dateVisitor cannot be null");
            this.dateVisitor = dateVisitor;
            return this;
        }

        @Override
        public FloatStageVisitorBuilder<T> visitDouble(@Nonnull Supplier<T> doubleVisitor) {
            Preconditions.checkNotNull(doubleVisitor, "doubleVisitor cannot be null");
            this.doubleVisitor = doubleVisitor;
            return this;
        }

        @Override
        public IntegerStageVisitorBuilder<T> visitFloat(@Nonnull Supplier<T> floatVisitor) {
            Preconditions.checkNotNull(floatVisitor, "floatVisitor cannot be null");
            this.floatVisitor = floatVisitor;
            return this;
        }

        @Override
        public ShortStageVisitorBuilder<T> visitInteger(@Nonnull Supplier<T> integerVisitor) {
            Preconditions.checkNotNull(integerVisitor, "integerVisitor cannot be null");
            this.integerVisitor = integerVisitor;
            return this;
        }

        @Override
        public StringStageVisitorBuilder<T> visitShort(@Nonnull Supplier<T> shortVisitor) {
            Preconditions.checkNotNull(shortVisitor, "shortVisitor cannot be null");
            this.shortVisitor = shortVisitor;
            return this;
        }

        @Override
        public TimestampStageVisitorBuilder<T> visitString(@Nonnull Supplier<T> stringVisitor) {
            Preconditions.checkNotNull(stringVisitor, "stringVisitor cannot be null");
            this.stringVisitor = stringVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> visitTimestamp(@Nonnull Supplier<T> timestampVisitor) {
            Preconditions.checkNotNull(timestampVisitor, "timestampVisitor cannot be null");
            this.timestampVisitor = timestampVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownType -> unknownVisitor.apply((String)unknownType);
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'FoundryFieldType' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Supplier<T> arrayVisitor = this.arrayVisitor;
            final Supplier<T> decimalVisitor = this.decimalVisitor;
            final Supplier<T> mapVisitor = this.mapVisitor;
            final Supplier<T> structVisitor = this.structVisitor;
            final Supplier<T> longVisitor = this.longVisitor;
            final Supplier<T> binaryVisitor = this.binaryVisitor;
            final Supplier<T> booleanVisitor = this.booleanVisitor;
            final Supplier<T> byteVisitor = this.byteVisitor;
            final Supplier<T> dateVisitor = this.dateVisitor;
            final Supplier<T> doubleVisitor = this.doubleVisitor;
            final Supplier<T> floatVisitor = this.floatVisitor;
            final Supplier<T> integerVisitor = this.integerVisitor;
            final Supplier<T> shortVisitor = this.shortVisitor;
            final Supplier<T> stringVisitor = this.stringVisitor;
            final Supplier<T> timestampVisitor = this.timestampVisitor;
            final Function<@Safe String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitArray() {
                    return arrayVisitor.get();
                }

                @Override
                public T visitDecimal() {
                    return decimalVisitor.get();
                }

                @Override
                public T visitMap() {
                    return mapVisitor.get();
                }

                @Override
                public T visitStruct() {
                    return structVisitor.get();
                }

                @Override
                public T visitLong() {
                    return longVisitor.get();
                }

                @Override
                public T visitBinary() {
                    return binaryVisitor.get();
                }

                @Override
                public T visitBoolean() {
                    return booleanVisitor.get();
                }

                @Override
                public T visitByte() {
                    return byteVisitor.get();
                }

                @Override
                public T visitDate() {
                    return dateVisitor.get();
                }

                @Override
                public T visitDouble() {
                    return doubleVisitor.get();
                }

                @Override
                public T visitFloat() {
                    return floatVisitor.get();
                }

                @Override
                public T visitInteger() {
                    return integerVisitor.get();
                }

                @Override
                public T visitShort() {
                    return shortVisitor.get();
                }

                @Override
                public T visitString() {
                    return stringVisitor.get();
                }

                @Override
                public T visitTimestamp() {
                    return timestampVisitor.get();
                }

                @Override
                public T visitUnknown(String unknownType) {
                    return unknownVisitor.apply(unknownType);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitArray();

        public T visitDecimal();

        public T visitMap();

        public T visitStruct();

        public T visitLong();

        public T visitBinary();

        public T visitBoolean();

        public T visitByte();

        public T visitDate();

        public T visitDouble();

        public T visitFloat();

        public T visitInteger();

        public T visitShort();

        public T visitString();

        public T visitTimestamp();

        public T visitUnknown(String var1);

        public static <T> ArrayStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }

    public static enum Value {
        ARRAY,
        DECIMAL,
        MAP,
        STRUCT,
        LONG,
        BINARY,
        BOOLEAN,
        BYTE,
        DATE,
        DOUBLE,
        FLOAT,
        INTEGER,
        SHORT,
        STRING,
        TIMESTAMP,
        UNKNOWN;

    }
}

