/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.stats.service.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class ApproximateGaussianValue {
    private final String mean;
    private final double stddev;
    private int memoizedHashCode;

    private ApproximateGaussianValue(String mean, double stddev) {
        ApproximateGaussianValue.validateFields(mean);
        this.mean = mean;
        this.stddev = stddev;
    }

    @JsonProperty(value="mean")
    public String getMean() {
        return this.mean;
    }

    @JsonProperty(value="stddev")
    public double getStddev() {
        return this.stddev;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ApproximateGaussianValue && this.equalTo((ApproximateGaussianValue)other);
    }

    private boolean equalTo(ApproximateGaussianValue other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.mean.equals(other.mean) && Double.doubleToLongBits(this.stddev) == Double.doubleToLongBits(other.stddev);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.mean.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + Double.hashCode(this.stddev));
        }
        return result;
    }

    public String toString() {
        return "ApproximateGaussianValue{mean: " + this.mean + ", stddev: " + this.stddev + "}";
    }

    public static ApproximateGaussianValue of(String mean, double stddev) {
        return ApproximateGaussianValue.builder().mean(mean).stddev(stddev).build();
    }

    private static void validateFields(String mean) {
        List<String> missingFields = null;
        if ((missingFields = ApproximateGaussianValue.addFieldIfMissing(missingFields, mean, "mean")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private String mean;
        private double stddev;
        private boolean _stddevInitialized = false;

        private Builder() {
        }

        public Builder from(ApproximateGaussianValue other) {
            this.checkNotBuilt();
            this.mean(other.getMean());
            this.stddev(other.getStddev());
            return this;
        }

        @JsonSetter(value="mean")
        public Builder mean(@Nonnull String mean) {
            this.checkNotBuilt();
            this.mean = Preconditions.checkNotNull(mean, "mean cannot be null");
            return this;
        }

        @JsonSetter(value="stddev")
        public Builder stddev(double stddev) {
            this.checkNotBuilt();
            this.stddev = stddev;
            this._stddevInitialized = true;
            return this;
        }

        private void validatePrimitiveFieldsHaveBeenInitialized() {
            List<String> missingFields = null;
            if ((missingFields = Builder.addFieldIfMissing(missingFields, this._stddevInitialized, "stddev")) != null) {
                throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
            }
        }

        private static List<String> addFieldIfMissing(List<String> prev, boolean initialized, String fieldName) {
            List<String> missingFields = prev;
            if (!initialized) {
                if (missingFields == null) {
                    missingFields = new ArrayList<String>(1);
                }
                missingFields.add(fieldName);
            }
            return missingFields;
        }

        public ApproximateGaussianValue build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            this.validatePrimitiveFieldsHaveBeenInitialized();
            return new ApproximateGaussianValue(this.mean, this.stddev);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

