/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.stats.service.api;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnyGetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnySetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSubTypes;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.BooleanColumnStats;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.DateColumnStats;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.EmptyColumnStats;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.NumericColumnStats;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.StringColumnStats;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class ColumnStats {
    private final Base value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private ColumnStats(Base value) {
        this.value = value;
    }

    @JsonValue
    private Base getValue() {
        return this.value;
    }

    public static ColumnStats emptyColumnStats(EmptyColumnStats value) {
        return new ColumnStats(new EmptyColumnStatsWrapper(value));
    }

    public static ColumnStats booleanColumnStats(BooleanColumnStats value) {
        return new ColumnStats(new BooleanColumnStatsWrapper(value));
    }

    public static ColumnStats stringColumnStats(StringColumnStats value) {
        return new ColumnStats(new StringColumnStatsWrapper(value));
    }

    public static ColumnStats numericColumnStats(NumericColumnStats value) {
        return new ColumnStats(new NumericColumnStatsWrapper(value));
    }

    public static ColumnStats dateColumnStats(DateColumnStats value) {
        return new ColumnStats(new DateColumnStatsWrapper(value));
    }

    public static ColumnStats unknown(@Safe String type, Object value) {
        switch (Preconditions.checkNotNull(type, "Type is required")) {
            case "emptyColumnStats": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: emptyColumnStats", new Arg[0]);
            }
            case "booleanColumnStats": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: booleanColumnStats", new Arg[0]);
            }
            case "stringColumnStats": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: stringColumnStats", new Arg[0]);
            }
            case "numericColumnStats": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: numericColumnStats", new Arg[0]);
            }
            case "dateColumnStats": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: dateColumnStats", new Arg[0]);
            }
        }
        return new ColumnStats(new UnknownWrapper(type, Collections.singletonMap(type, value)));
    }

    public <T> T accept(Visitor<T> visitor) {
        return this.value.accept(visitor);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ColumnStats && this.equalTo((ColumnStats)other);
    }

    private boolean equalTo(ColumnStats other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "ColumnStats{value: " + this.value + "}";
    }

    private static final class UnknownWrapper
    implements Base {
        private final String type;
        private final Map<String, Object> value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private UnknownWrapper(@JsonProperty(value="type") String type) {
            this(type, new HashMap<String, Object>());
        }

        private UnknownWrapper(@Nonnull String type, @Nonnull Map<String, Object> value) {
            Preconditions.checkNotNull(type, "type cannot be null");
            Preconditions.checkNotNull(value, "value cannot be null");
            this.type = type;
            this.value = value;
        }

        @JsonProperty
        private String getType() {
            return this.type;
        }

        @JsonAnyGetter
        private Map<String, Object> getValue() {
            return this.value;
        }

        @JsonAnySetter
        private void put(String key, Object val) {
            this.value.put(key, val);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitUnknown(this.type);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof UnknownWrapper && this.equalTo((UnknownWrapper)other);
        }

        private boolean equalTo(UnknownWrapper other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + this.type.hashCode();
            hash = 31 * hash + this.value.hashCode();
            return hash;
        }

        public String toString() {
            return "UnknownWrapper{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="dateColumnStats")
    private static final class DateColumnStatsWrapper
    implements Base {
        private final DateColumnStats value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private DateColumnStatsWrapper(@JsonSetter(value="dateColumnStats") @Nonnull DateColumnStats value) {
            Preconditions.checkNotNull(value, "dateColumnStats cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "dateColumnStats";
        }

        @JsonProperty(value="dateColumnStats")
        private DateColumnStats getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitDateColumnStats(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof DateColumnStatsWrapper && this.equalTo((DateColumnStatsWrapper)other);
        }

        private boolean equalTo(DateColumnStatsWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "DateColumnStatsWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="numericColumnStats")
    private static final class NumericColumnStatsWrapper
    implements Base {
        private final NumericColumnStats value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private NumericColumnStatsWrapper(@JsonSetter(value="numericColumnStats") @Nonnull NumericColumnStats value) {
            Preconditions.checkNotNull(value, "numericColumnStats cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "numericColumnStats";
        }

        @JsonProperty(value="numericColumnStats")
        private NumericColumnStats getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitNumericColumnStats(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof NumericColumnStatsWrapper && this.equalTo((NumericColumnStatsWrapper)other);
        }

        private boolean equalTo(NumericColumnStatsWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "NumericColumnStatsWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="stringColumnStats")
    private static final class StringColumnStatsWrapper
    implements Base {
        private final StringColumnStats value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private StringColumnStatsWrapper(@JsonSetter(value="stringColumnStats") @Nonnull StringColumnStats value) {
            Preconditions.checkNotNull(value, "stringColumnStats cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "stringColumnStats";
        }

        @JsonProperty(value="stringColumnStats")
        private StringColumnStats getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitStringColumnStats(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof StringColumnStatsWrapper && this.equalTo((StringColumnStatsWrapper)other);
        }

        private boolean equalTo(StringColumnStatsWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "StringColumnStatsWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="booleanColumnStats")
    private static final class BooleanColumnStatsWrapper
    implements Base {
        private final BooleanColumnStats value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private BooleanColumnStatsWrapper(@JsonSetter(value="booleanColumnStats") @Nonnull BooleanColumnStats value) {
            Preconditions.checkNotNull(value, "booleanColumnStats cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "booleanColumnStats";
        }

        @JsonProperty(value="booleanColumnStats")
        private BooleanColumnStats getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitBooleanColumnStats(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof BooleanColumnStatsWrapper && this.equalTo((BooleanColumnStatsWrapper)other);
        }

        private boolean equalTo(BooleanColumnStatsWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "BooleanColumnStatsWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="emptyColumnStats")
    private static final class EmptyColumnStatsWrapper
    implements Base {
        private final EmptyColumnStats value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private EmptyColumnStatsWrapper(@JsonSetter(value="emptyColumnStats") @Nonnull EmptyColumnStats value) {
            Preconditions.checkNotNull(value, "emptyColumnStats cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "emptyColumnStats";
        }

        @JsonProperty(value="emptyColumnStats")
        private EmptyColumnStats getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitEmptyColumnStats(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof EmptyColumnStatsWrapper && this.equalTo((EmptyColumnStatsWrapper)other);
        }

        private boolean equalTo(EmptyColumnStatsWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "EmptyColumnStatsWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=UnknownWrapper.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=EmptyColumnStatsWrapper.class), @JsonSubTypes.Type(value=BooleanColumnStatsWrapper.class), @JsonSubTypes.Type(value=StringColumnStatsWrapper.class), @JsonSubTypes.Type(value=NumericColumnStatsWrapper.class), @JsonSubTypes.Type(value=DateColumnStatsWrapper.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Base {
        public <T> T accept(Visitor<T> var1);
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface StringColumnStatsStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> stringColumnStats(@Nonnull Function<StringColumnStats, T> var1);
    }

    public static interface NumericColumnStatsStageVisitorBuilder<T> {
        public StringColumnStatsStageVisitorBuilder<T> numericColumnStats(@Nonnull Function<NumericColumnStats, T> var1);
    }

    public static interface EmptyColumnStatsStageVisitorBuilder<T> {
        public NumericColumnStatsStageVisitorBuilder<T> emptyColumnStats(@Nonnull Function<EmptyColumnStats, T> var1);
    }

    public static interface DateColumnStatsStageVisitorBuilder<T> {
        public EmptyColumnStatsStageVisitorBuilder<T> dateColumnStats(@Nonnull Function<DateColumnStats, T> var1);
    }

    public static interface BooleanColumnStatsStageVisitorBuilder<T> {
        public DateColumnStatsStageVisitorBuilder<T> booleanColumnStats(@Nonnull Function<BooleanColumnStats, T> var1);
    }

    private static final class VisitorBuilder<T>
    implements BooleanColumnStatsStageVisitorBuilder<T>,
    DateColumnStatsStageVisitorBuilder<T>,
    EmptyColumnStatsStageVisitorBuilder<T>,
    NumericColumnStatsStageVisitorBuilder<T>,
    StringColumnStatsStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Function<BooleanColumnStats, T> booleanColumnStatsVisitor;
        private Function<DateColumnStats, T> dateColumnStatsVisitor;
        private Function<EmptyColumnStats, T> emptyColumnStatsVisitor;
        private Function<NumericColumnStats, T> numericColumnStatsVisitor;
        private Function<StringColumnStats, T> stringColumnStatsVisitor;
        private Function<String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public DateColumnStatsStageVisitorBuilder<T> booleanColumnStats(@Nonnull Function<BooleanColumnStats, T> booleanColumnStatsVisitor) {
            Preconditions.checkNotNull(booleanColumnStatsVisitor, "booleanColumnStatsVisitor cannot be null");
            this.booleanColumnStatsVisitor = booleanColumnStatsVisitor;
            return this;
        }

        @Override
        public EmptyColumnStatsStageVisitorBuilder<T> dateColumnStats(@Nonnull Function<DateColumnStats, T> dateColumnStatsVisitor) {
            Preconditions.checkNotNull(dateColumnStatsVisitor, "dateColumnStatsVisitor cannot be null");
            this.dateColumnStatsVisitor = dateColumnStatsVisitor;
            return this;
        }

        @Override
        public NumericColumnStatsStageVisitorBuilder<T> emptyColumnStats(@Nonnull Function<EmptyColumnStats, T> emptyColumnStatsVisitor) {
            Preconditions.checkNotNull(emptyColumnStatsVisitor, "emptyColumnStatsVisitor cannot be null");
            this.emptyColumnStatsVisitor = emptyColumnStatsVisitor;
            return this;
        }

        @Override
        public StringColumnStatsStageVisitorBuilder<T> numericColumnStats(@Nonnull Function<NumericColumnStats, T> numericColumnStatsVisitor) {
            Preconditions.checkNotNull(numericColumnStatsVisitor, "numericColumnStatsVisitor cannot be null");
            this.numericColumnStatsVisitor = numericColumnStatsVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> stringColumnStats(@Nonnull Function<StringColumnStats, T> stringColumnStatsVisitor) {
            Preconditions.checkNotNull(stringColumnStatsVisitor, "stringColumnStatsVisitor cannot be null");
            this.stringColumnStatsVisitor = stringColumnStatsVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'ColumnStats' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Function<BooleanColumnStats, T> booleanColumnStatsVisitor = this.booleanColumnStatsVisitor;
            final Function<DateColumnStats, T> dateColumnStatsVisitor = this.dateColumnStatsVisitor;
            final Function<EmptyColumnStats, T> emptyColumnStatsVisitor = this.emptyColumnStatsVisitor;
            final Function<NumericColumnStats, T> numericColumnStatsVisitor = this.numericColumnStatsVisitor;
            final Function<StringColumnStats, T> stringColumnStatsVisitor = this.stringColumnStatsVisitor;
            final Function<String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitBooleanColumnStats(BooleanColumnStats value) {
                    return booleanColumnStatsVisitor.apply(value);
                }

                @Override
                public T visitDateColumnStats(DateColumnStats value) {
                    return dateColumnStatsVisitor.apply(value);
                }

                @Override
                public T visitEmptyColumnStats(EmptyColumnStats value) {
                    return emptyColumnStatsVisitor.apply(value);
                }

                @Override
                public T visitNumericColumnStats(NumericColumnStats value) {
                    return numericColumnStatsVisitor.apply(value);
                }

                @Override
                public T visitStringColumnStats(StringColumnStats value) {
                    return stringColumnStatsVisitor.apply(value);
                }

                @Override
                public T visitUnknown(String value) {
                    return unknownVisitor.apply(value);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitEmptyColumnStats(EmptyColumnStats var1);

        public T visitBooleanColumnStats(BooleanColumnStats var1);

        public T visitStringColumnStats(StringColumnStats var1);

        public T visitNumericColumnStats(NumericColumnStats var1);

        public T visitDateColumnStats(DateColumnStats var1);

        public T visitUnknown(@Safe String var1);

        public static <T> BooleanColumnStatsStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }
}

