/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.stats.service.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.google.errorprone.annotations.Immutable;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
@Immutable
public final class ColumnType {
    public static final ColumnType BOOLEAN = new ColumnType(Value.BOOLEAN, "BOOLEAN");
    public static final ColumnType STRING = new ColumnType(Value.STRING, "STRING");
    public static final ColumnType DOUBLE = new ColumnType(Value.DOUBLE, "DOUBLE");
    public static final ColumnType LONG = new ColumnType(Value.LONG, "LONG");
    public static final ColumnType NUMBER = new ColumnType(Value.NUMBER, "NUMBER");
    public static final ColumnType DATE = new ColumnType(Value.DATE, "DATE");
    public static final ColumnType EMPTY = new ColumnType(Value.EMPTY, "EMPTY");
    private static final List<ColumnType> values = Collections.unmodifiableList(Arrays.asList(BOOLEAN, STRING, DOUBLE, LONG, NUMBER, DATE, EMPTY));
    private final Value value;
    private final String string;

    private ColumnType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value get() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || this.value == Value.UNKNOWN && other instanceof ColumnType && this.string.equals(((ColumnType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static ColumnType valueOf(@Nonnull @Safe String value) {
        String upperCasedValue;
        Preconditions.checkNotNull(value, "value cannot be null");
        switch (upperCasedValue = value.toUpperCase(Locale.ROOT)) {
            case "BOOLEAN": {
                return BOOLEAN;
            }
            case "STRING": {
                return STRING;
            }
            case "DOUBLE": {
                return DOUBLE;
            }
            case "LONG": {
                return LONG;
            }
            case "NUMBER": {
                return NUMBER;
            }
            case "DATE": {
                return DATE;
            }
            case "EMPTY": {
                return EMPTY;
            }
        }
        return new ColumnType(Value.UNKNOWN, upperCasedValue);
    }

    public <T> T accept(Visitor<T> visitor) {
        switch (this.value) {
            case BOOLEAN: {
                return visitor.visitBoolean();
            }
            case STRING: {
                return visitor.visitString();
            }
            case DOUBLE: {
                return visitor.visitDouble();
            }
            case LONG: {
                return visitor.visitLong();
            }
            case NUMBER: {
                return visitor.visitNumber();
            }
            case DATE: {
                return visitor.visitDate();
            }
            case EMPTY: {
                return visitor.visitEmpty();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    public static List<ColumnType> values() {
        return values;
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface EmptyStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> visitEmpty(@Nonnull Supplier<T> var1);
    }

    public static interface DateStageVisitorBuilder<T> {
        public EmptyStageVisitorBuilder<T> visitDate(@Nonnull Supplier<T> var1);
    }

    public static interface NumberStageVisitorBuilder<T> {
        public DateStageVisitorBuilder<T> visitNumber(@Nonnull Supplier<T> var1);
    }

    public static interface LongStageVisitorBuilder<T> {
        public NumberStageVisitorBuilder<T> visitLong(@Nonnull Supplier<T> var1);
    }

    public static interface DoubleStageVisitorBuilder<T> {
        public LongStageVisitorBuilder<T> visitDouble(@Nonnull Supplier<T> var1);
    }

    public static interface StringStageVisitorBuilder<T> {
        public DoubleStageVisitorBuilder<T> visitString(@Nonnull Supplier<T> var1);
    }

    public static interface BooleanStageVisitorBuilder<T> {
        public StringStageVisitorBuilder<T> visitBoolean(@Nonnull Supplier<T> var1);
    }

    private static final class VisitorBuilder<T>
    implements BooleanStageVisitorBuilder<T>,
    StringStageVisitorBuilder<T>,
    DoubleStageVisitorBuilder<T>,
    LongStageVisitorBuilder<T>,
    NumberStageVisitorBuilder<T>,
    DateStageVisitorBuilder<T>,
    EmptyStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Supplier<T> booleanVisitor;
        private Supplier<T> stringVisitor;
        private Supplier<T> doubleVisitor;
        private Supplier<T> longVisitor;
        private Supplier<T> numberVisitor;
        private Supplier<T> dateVisitor;
        private Supplier<T> emptyVisitor;
        private Function<@Safe String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public StringStageVisitorBuilder<T> visitBoolean(@Nonnull Supplier<T> booleanVisitor) {
            Preconditions.checkNotNull(booleanVisitor, "booleanVisitor cannot be null");
            this.booleanVisitor = booleanVisitor;
            return this;
        }

        @Override
        public DoubleStageVisitorBuilder<T> visitString(@Nonnull Supplier<T> stringVisitor) {
            Preconditions.checkNotNull(stringVisitor, "stringVisitor cannot be null");
            this.stringVisitor = stringVisitor;
            return this;
        }

        @Override
        public LongStageVisitorBuilder<T> visitDouble(@Nonnull Supplier<T> doubleVisitor) {
            Preconditions.checkNotNull(doubleVisitor, "doubleVisitor cannot be null");
            this.doubleVisitor = doubleVisitor;
            return this;
        }

        @Override
        public NumberStageVisitorBuilder<T> visitLong(@Nonnull Supplier<T> longVisitor) {
            Preconditions.checkNotNull(longVisitor, "longVisitor cannot be null");
            this.longVisitor = longVisitor;
            return this;
        }

        @Override
        public DateStageVisitorBuilder<T> visitNumber(@Nonnull Supplier<T> numberVisitor) {
            Preconditions.checkNotNull(numberVisitor, "numberVisitor cannot be null");
            this.numberVisitor = numberVisitor;
            return this;
        }

        @Override
        public EmptyStageVisitorBuilder<T> visitDate(@Nonnull Supplier<T> dateVisitor) {
            Preconditions.checkNotNull(dateVisitor, "dateVisitor cannot be null");
            this.dateVisitor = dateVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> visitEmpty(@Nonnull Supplier<T> emptyVisitor) {
            Preconditions.checkNotNull(emptyVisitor, "emptyVisitor cannot be null");
            this.emptyVisitor = emptyVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownType -> unknownVisitor.apply((String)unknownType);
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'ColumnType' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Supplier<T> booleanVisitor = this.booleanVisitor;
            final Supplier<T> stringVisitor = this.stringVisitor;
            final Supplier<T> doubleVisitor = this.doubleVisitor;
            final Supplier<T> longVisitor = this.longVisitor;
            final Supplier<T> numberVisitor = this.numberVisitor;
            final Supplier<T> dateVisitor = this.dateVisitor;
            final Supplier<T> emptyVisitor = this.emptyVisitor;
            final Function<@Safe String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitBoolean() {
                    return booleanVisitor.get();
                }

                @Override
                public T visitString() {
                    return stringVisitor.get();
                }

                @Override
                public T visitDouble() {
                    return doubleVisitor.get();
                }

                @Override
                public T visitLong() {
                    return longVisitor.get();
                }

                @Override
                public T visitNumber() {
                    return numberVisitor.get();
                }

                @Override
                public T visitDate() {
                    return dateVisitor.get();
                }

                @Override
                public T visitEmpty() {
                    return emptyVisitor.get();
                }

                @Override
                public T visitUnknown(String unknownType) {
                    return unknownVisitor.apply(unknownType);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitBoolean();

        public T visitString();

        public T visitDouble();

        public T visitLong();

        public T visitNumber();

        public T visitDate();

        public T visitEmpty();

        public T visitUnknown(String var1);

        public static <T> BooleanStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }

    public static enum Value {
        BOOLEAN,
        STRING,
        DOUBLE,
        LONG,
        NUMBER,
        DATE,
        EMPTY,
        UNKNOWN;

    }
}

