/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.stats.service.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ColumnStats;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.Value;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class DatasetStats {
    private final Value rowCount;
    private final Optional<Value> sizeInBytes;
    private final Map<String, ColumnStats> columns;
    private int memoizedHashCode;

    private DatasetStats(Value rowCount, Optional<Value> sizeInBytes, Map<String, ColumnStats> columns) {
        DatasetStats.validateFields(rowCount, sizeInBytes, columns);
        this.rowCount = rowCount;
        this.sizeInBytes = sizeInBytes;
        this.columns = Collections.unmodifiableMap(columns);
    }

    @JsonProperty(value="rowCount")
    public Value getRowCount() {
        return this.rowCount;
    }

    @JsonProperty(value="sizeInBytes")
    public Optional<Value> getSizeInBytes() {
        return this.sizeInBytes;
    }

    @JsonProperty(value="columns")
    public Map<String, ColumnStats> getColumns() {
        return this.columns;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof DatasetStats && this.equalTo((DatasetStats)other);
    }

    private boolean equalTo(DatasetStats other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.rowCount.equals(other.rowCount) && this.sizeInBytes.equals(other.sizeInBytes) && this.columns.equals(other.columns);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.rowCount.hashCode();
            hash = 31 * hash + this.sizeInBytes.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.columns.hashCode());
        }
        return result;
    }

    public String toString() {
        return "DatasetStats{rowCount: " + this.rowCount + ", sizeInBytes: " + this.sizeInBytes + ", columns: " + this.columns + "}";
    }

    public static DatasetStats of(Value rowCount, Value sizeInBytes, Map<String, ColumnStats> columns) {
        return DatasetStats.builder().rowCount(rowCount).sizeInBytes(Optional.of(sizeInBytes)).columns(columns).build();
    }

    private static void validateFields(Value rowCount, Optional<Value> sizeInBytes, Map<String, ColumnStats> columns) {
        List<String> missingFields = null;
        missingFields = DatasetStats.addFieldIfMissing(missingFields, rowCount, "rowCount");
        missingFields = DatasetStats.addFieldIfMissing(missingFields, sizeInBytes, "sizeInBytes");
        if ((missingFields = DatasetStats.addFieldIfMissing(missingFields, columns, "columns")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private Value rowCount;
        private Optional<Value> sizeInBytes = Optional.empty();
        private Map<String, ColumnStats> columns = new LinkedHashMap<String, ColumnStats>();

        private Builder() {
        }

        public Builder from(DatasetStats other) {
            this.checkNotBuilt();
            this.rowCount(other.getRowCount());
            this.sizeInBytes(other.getSizeInBytes());
            this.columns(other.getColumns());
            return this;
        }

        @JsonSetter(value="rowCount")
        public Builder rowCount(@Nonnull Value rowCount) {
            this.checkNotBuilt();
            this.rowCount = Preconditions.checkNotNull(rowCount, "rowCount cannot be null");
            return this;
        }

        @JsonSetter(value="sizeInBytes", nulls=Nulls.SKIP)
        public Builder sizeInBytes(@Nonnull Optional<Value> sizeInBytes) {
            this.checkNotBuilt();
            this.sizeInBytes = Preconditions.checkNotNull(sizeInBytes, "sizeInBytes cannot be null");
            return this;
        }

        public Builder sizeInBytes(@Nonnull Value sizeInBytes) {
            this.checkNotBuilt();
            this.sizeInBytes = Optional.of(Preconditions.checkNotNull(sizeInBytes, "sizeInBytes cannot be null"));
            return this;
        }

        @JsonSetter(value="columns", nulls=Nulls.SKIP)
        public Builder columns(@Nonnull Map<String, ColumnStats> columns) {
            this.checkNotBuilt();
            this.columns = new LinkedHashMap<String, ColumnStats>(Preconditions.checkNotNull(columns, "columns cannot be null"));
            return this;
        }

        public Builder putAllColumns(@Nonnull Map<String, ColumnStats> columns) {
            this.checkNotBuilt();
            this.columns.putAll(Preconditions.checkNotNull(columns, "columns cannot be null"));
            return this;
        }

        public Builder columns(String key, ColumnStats value) {
            this.checkNotBuilt();
            this.columns.put(key, value);
            return this;
        }

        public DatasetStats build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new DatasetStats(this.rowCount, this.sizeInBytes, this.columns);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

