/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.stats.service.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ColumnType;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ProbabilityInterval;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.Value;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ValueFrequency;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class DateColumnStats {
    private final ColumnType type;
    private final Value nullCount;
    private final Value uniqueCount;
    private final List<ValueFrequency> frequentItems;
    private final Optional<Value> min;
    private final Optional<Value> max;
    private final List<ProbabilityInterval> distribution;
    private final Set<String> sampleUniqueItems;
    private final Optional<Value> totalLength;
    private final Optional<Value> maxLength;
    private int memoizedHashCode;

    private DateColumnStats(ColumnType type, Value nullCount, Value uniqueCount, List<ValueFrequency> frequentItems, Optional<Value> min, Optional<Value> max, List<ProbabilityInterval> distribution, Set<String> sampleUniqueItems, Optional<Value> totalLength, Optional<Value> maxLength) {
        DateColumnStats.validateFields(type, nullCount, uniqueCount, frequentItems, min, max, distribution, sampleUniqueItems, totalLength, maxLength);
        this.type = type;
        this.nullCount = nullCount;
        this.uniqueCount = uniqueCount;
        this.frequentItems = Collections.unmodifiableList(frequentItems);
        this.min = min;
        this.max = max;
        this.distribution = Collections.unmodifiableList(distribution);
        this.sampleUniqueItems = Collections.unmodifiableSet(sampleUniqueItems);
        this.totalLength = totalLength;
        this.maxLength = maxLength;
    }

    @JsonProperty(value="type")
    public ColumnType getType() {
        return this.type;
    }

    @JsonProperty(value="nullCount")
    public Value getNullCount() {
        return this.nullCount;
    }

    @JsonProperty(value="uniqueCount")
    public Value getUniqueCount() {
        return this.uniqueCount;
    }

    @JsonProperty(value="frequentItems")
    public List<ValueFrequency> getFrequentItems() {
        return this.frequentItems;
    }

    @JsonProperty(value="min")
    public Optional<Value> getMin() {
        return this.min;
    }

    @JsonProperty(value="max")
    public Optional<Value> getMax() {
        return this.max;
    }

    @JsonProperty(value="distribution")
    public List<ProbabilityInterval> getDistribution() {
        return this.distribution;
    }

    @JsonProperty(value="sampleUniqueItems")
    public Set<String> getSampleUniqueItems() {
        return this.sampleUniqueItems;
    }

    @JsonProperty(value="totalLength")
    public Optional<Value> getTotalLength() {
        return this.totalLength;
    }

    @JsonProperty(value="maxLength")
    public Optional<Value> getMaxLength() {
        return this.maxLength;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof DateColumnStats && this.equalTo((DateColumnStats)other);
    }

    private boolean equalTo(DateColumnStats other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.type.equals(other.type) && this.nullCount.equals(other.nullCount) && this.uniqueCount.equals(other.uniqueCount) && this.frequentItems.equals(other.frequentItems) && this.min.equals(other.min) && this.max.equals(other.max) && this.distribution.equals(other.distribution) && this.sampleUniqueItems.equals(other.sampleUniqueItems) && this.totalLength.equals(other.totalLength) && this.maxLength.equals(other.maxLength);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.type.hashCode();
            hash = 31 * hash + this.nullCount.hashCode();
            hash = 31 * hash + this.uniqueCount.hashCode();
            hash = 31 * hash + this.frequentItems.hashCode();
            hash = 31 * hash + this.min.hashCode();
            hash = 31 * hash + this.max.hashCode();
            hash = 31 * hash + this.distribution.hashCode();
            hash = 31 * hash + this.sampleUniqueItems.hashCode();
            hash = 31 * hash + this.totalLength.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.maxLength.hashCode());
        }
        return result;
    }

    public String toString() {
        return "DateColumnStats{type: " + this.type + ", nullCount: " + this.nullCount + ", uniqueCount: " + this.uniqueCount + ", frequentItems: " + this.frequentItems + ", min: " + this.min + ", max: " + this.max + ", distribution: " + this.distribution + ", sampleUniqueItems: " + this.sampleUniqueItems + ", totalLength: " + this.totalLength + ", maxLength: " + this.maxLength + "}";
    }

    private static void validateFields(ColumnType type, Value nullCount, Value uniqueCount, List<ValueFrequency> frequentItems, Optional<Value> min, Optional<Value> max, List<ProbabilityInterval> distribution, Set<String> sampleUniqueItems, Optional<Value> totalLength, Optional<Value> maxLength) {
        List<String> missingFields = null;
        missingFields = DateColumnStats.addFieldIfMissing(missingFields, type, "type");
        missingFields = DateColumnStats.addFieldIfMissing(missingFields, nullCount, "nullCount");
        missingFields = DateColumnStats.addFieldIfMissing(missingFields, uniqueCount, "uniqueCount");
        missingFields = DateColumnStats.addFieldIfMissing(missingFields, frequentItems, "frequentItems");
        missingFields = DateColumnStats.addFieldIfMissing(missingFields, min, "min");
        missingFields = DateColumnStats.addFieldIfMissing(missingFields, max, "max");
        missingFields = DateColumnStats.addFieldIfMissing(missingFields, distribution, "distribution");
        missingFields = DateColumnStats.addFieldIfMissing(missingFields, sampleUniqueItems, "sampleUniqueItems");
        missingFields = DateColumnStats.addFieldIfMissing(missingFields, totalLength, "totalLength");
        if ((missingFields = DateColumnStats.addFieldIfMissing(missingFields, maxLength, "maxLength")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(10);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private ColumnType type;
        private Value nullCount;
        private Value uniqueCount;
        private List<ValueFrequency> frequentItems = new ArrayList<ValueFrequency>();
        private Optional<Value> min = Optional.empty();
        private Optional<Value> max = Optional.empty();
        private List<ProbabilityInterval> distribution = new ArrayList<ProbabilityInterval>();
        private Set<String> sampleUniqueItems = new LinkedHashSet<String>();
        private Optional<Value> totalLength = Optional.empty();
        private Optional<Value> maxLength = Optional.empty();

        private Builder() {
        }

        public Builder from(DateColumnStats other) {
            this.checkNotBuilt();
            this.type(other.getType());
            this.nullCount(other.getNullCount());
            this.uniqueCount(other.getUniqueCount());
            this.frequentItems(other.getFrequentItems());
            this.min(other.getMin());
            this.max(other.getMax());
            this.distribution(other.getDistribution());
            this.sampleUniqueItems(other.getSampleUniqueItems());
            this.totalLength(other.getTotalLength());
            this.maxLength(other.getMaxLength());
            return this;
        }

        @JsonSetter(value="type")
        public Builder type(@Nonnull ColumnType type) {
            this.checkNotBuilt();
            this.type = Preconditions.checkNotNull(type, "type cannot be null");
            return this;
        }

        @JsonSetter(value="nullCount")
        public Builder nullCount(@Nonnull Value nullCount) {
            this.checkNotBuilt();
            this.nullCount = Preconditions.checkNotNull(nullCount, "nullCount cannot be null");
            return this;
        }

        @JsonSetter(value="uniqueCount")
        public Builder uniqueCount(@Nonnull Value uniqueCount) {
            this.checkNotBuilt();
            this.uniqueCount = Preconditions.checkNotNull(uniqueCount, "uniqueCount cannot be null");
            return this;
        }

        @JsonSetter(value="frequentItems", nulls=Nulls.SKIP)
        public Builder frequentItems(@Nonnull Iterable<ValueFrequency> frequentItems) {
            this.checkNotBuilt();
            this.frequentItems = ConjureCollections.newArrayList(Preconditions.checkNotNull(frequentItems, "frequentItems cannot be null"));
            return this;
        }

        public Builder addAllFrequentItems(@Nonnull Iterable<ValueFrequency> frequentItems) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.frequentItems, Preconditions.checkNotNull(frequentItems, "frequentItems cannot be null"));
            return this;
        }

        public Builder frequentItems(ValueFrequency frequentItems) {
            this.checkNotBuilt();
            this.frequentItems.add(frequentItems);
            return this;
        }

        @JsonSetter(value="min", nulls=Nulls.SKIP)
        public Builder min(@Nonnull Optional<Value> min) {
            this.checkNotBuilt();
            this.min = Preconditions.checkNotNull(min, "min cannot be null");
            return this;
        }

        public Builder min(@Nonnull Value min) {
            this.checkNotBuilt();
            this.min = Optional.of(Preconditions.checkNotNull(min, "min cannot be null"));
            return this;
        }

        @JsonSetter(value="max", nulls=Nulls.SKIP)
        public Builder max(@Nonnull Optional<Value> max) {
            this.checkNotBuilt();
            this.max = Preconditions.checkNotNull(max, "max cannot be null");
            return this;
        }

        public Builder max(@Nonnull Value max) {
            this.checkNotBuilt();
            this.max = Optional.of(Preconditions.checkNotNull(max, "max cannot be null"));
            return this;
        }

        @JsonSetter(value="distribution", nulls=Nulls.SKIP)
        public Builder distribution(@Nonnull Iterable<ProbabilityInterval> distribution) {
            this.checkNotBuilt();
            this.distribution = ConjureCollections.newArrayList(Preconditions.checkNotNull(distribution, "distribution cannot be null"));
            return this;
        }

        public Builder addAllDistribution(@Nonnull Iterable<ProbabilityInterval> distribution) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.distribution, Preconditions.checkNotNull(distribution, "distribution cannot be null"));
            return this;
        }

        public Builder distribution(ProbabilityInterval distribution) {
            this.checkNotBuilt();
            this.distribution.add(distribution);
            return this;
        }

        @JsonSetter(value="sampleUniqueItems", nulls=Nulls.SKIP)
        public Builder sampleUniqueItems(@Nonnull Iterable<String> sampleUniqueItems) {
            this.checkNotBuilt();
            this.sampleUniqueItems = ConjureCollections.newLinkedHashSet(Preconditions.checkNotNull(sampleUniqueItems, "sampleUniqueItems cannot be null"));
            return this;
        }

        public Builder addAllSampleUniqueItems(@Nonnull Iterable<String> sampleUniqueItems) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.sampleUniqueItems, Preconditions.checkNotNull(sampleUniqueItems, "sampleUniqueItems cannot be null"));
            return this;
        }

        public Builder sampleUniqueItems(String sampleUniqueItems) {
            this.checkNotBuilt();
            this.sampleUniqueItems.add(sampleUniqueItems);
            return this;
        }

        @JsonSetter(value="totalLength", nulls=Nulls.SKIP)
        public Builder totalLength(@Nonnull Optional<Value> totalLength) {
            this.checkNotBuilt();
            this.totalLength = Preconditions.checkNotNull(totalLength, "totalLength cannot be null");
            return this;
        }

        public Builder totalLength(@Nonnull Value totalLength) {
            this.checkNotBuilt();
            this.totalLength = Optional.of(Preconditions.checkNotNull(totalLength, "totalLength cannot be null"));
            return this;
        }

        @JsonSetter(value="maxLength", nulls=Nulls.SKIP)
        public Builder maxLength(@Nonnull Optional<Value> maxLength) {
            this.checkNotBuilt();
            this.maxLength = Preconditions.checkNotNull(maxLength, "maxLength cannot be null");
            return this;
        }

        public Builder maxLength(@Nonnull Value maxLength) {
            this.checkNotBuilt();
            this.maxLength = Optional.of(Preconditions.checkNotNull(maxLength, "maxLength cannot be null"));
            return this;
        }

        public DateColumnStats build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new DateColumnStats(this.type, this.nullCount, this.uniqueCount, this.frequentItems, this.min, this.max, this.distribution, this.sampleUniqueItems, this.totalLength, this.maxLength);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

