/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.stats.service.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ColumnType;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.Value;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class EmptyColumnStats {
    private final ColumnType type;
    private final Value nullCount;
    private final Optional<Value> totalLength;
    private final Optional<Value> maxLength;
    private int memoizedHashCode;

    private EmptyColumnStats(ColumnType type, Value nullCount, Optional<Value> totalLength, Optional<Value> maxLength) {
        EmptyColumnStats.validateFields(type, nullCount, totalLength, maxLength);
        this.type = type;
        this.nullCount = nullCount;
        this.totalLength = totalLength;
        this.maxLength = maxLength;
    }

    @JsonProperty(value="type")
    public ColumnType getType() {
        return this.type;
    }

    @JsonProperty(value="nullCount")
    public Value getNullCount() {
        return this.nullCount;
    }

    @JsonProperty(value="totalLength")
    public Optional<Value> getTotalLength() {
        return this.totalLength;
    }

    @JsonProperty(value="maxLength")
    public Optional<Value> getMaxLength() {
        return this.maxLength;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof EmptyColumnStats && this.equalTo((EmptyColumnStats)other);
    }

    private boolean equalTo(EmptyColumnStats other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.type.equals(other.type) && this.nullCount.equals(other.nullCount) && this.totalLength.equals(other.totalLength) && this.maxLength.equals(other.maxLength);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.type.hashCode();
            hash = 31 * hash + this.nullCount.hashCode();
            hash = 31 * hash + this.totalLength.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.maxLength.hashCode());
        }
        return result;
    }

    public String toString() {
        return "EmptyColumnStats{type: " + this.type + ", nullCount: " + this.nullCount + ", totalLength: " + this.totalLength + ", maxLength: " + this.maxLength + "}";
    }

    private static void validateFields(ColumnType type, Value nullCount, Optional<Value> totalLength, Optional<Value> maxLength) {
        List<String> missingFields = null;
        missingFields = EmptyColumnStats.addFieldIfMissing(missingFields, type, "type");
        missingFields = EmptyColumnStats.addFieldIfMissing(missingFields, nullCount, "nullCount");
        missingFields = EmptyColumnStats.addFieldIfMissing(missingFields, totalLength, "totalLength");
        if ((missingFields = EmptyColumnStats.addFieldIfMissing(missingFields, maxLength, "maxLength")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(4);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private ColumnType type;
        private Value nullCount;
        private Optional<Value> totalLength = Optional.empty();
        private Optional<Value> maxLength = Optional.empty();

        private Builder() {
        }

        public Builder from(EmptyColumnStats other) {
            this.checkNotBuilt();
            this.type(other.getType());
            this.nullCount(other.getNullCount());
            this.totalLength(other.getTotalLength());
            this.maxLength(other.getMaxLength());
            return this;
        }

        @JsonSetter(value="type")
        public Builder type(@Nonnull ColumnType type) {
            this.checkNotBuilt();
            this.type = Preconditions.checkNotNull(type, "type cannot be null");
            return this;
        }

        @JsonSetter(value="nullCount")
        public Builder nullCount(@Nonnull Value nullCount) {
            this.checkNotBuilt();
            this.nullCount = Preconditions.checkNotNull(nullCount, "nullCount cannot be null");
            return this;
        }

        @JsonSetter(value="totalLength", nulls=Nulls.SKIP)
        public Builder totalLength(@Nonnull Optional<Value> totalLength) {
            this.checkNotBuilt();
            this.totalLength = Preconditions.checkNotNull(totalLength, "totalLength cannot be null");
            return this;
        }

        public Builder totalLength(@Nonnull Value totalLength) {
            this.checkNotBuilt();
            this.totalLength = Optional.of(Preconditions.checkNotNull(totalLength, "totalLength cannot be null"));
            return this;
        }

        @JsonSetter(value="maxLength", nulls=Nulls.SKIP)
        public Builder maxLength(@Nonnull Optional<Value> maxLength) {
            this.checkNotBuilt();
            this.maxLength = Preconditions.checkNotNull(maxLength, "maxLength cannot be null");
            return this;
        }

        public Builder maxLength(@Nonnull Value maxLength) {
            this.checkNotBuilt();
            this.maxLength = Optional.of(Preconditions.checkNotNull(maxLength, "maxLength cannot be null"));
            return this;
        }

        public EmptyColumnStats build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new EmptyColumnStats(this.type, this.nullCount, this.totalLength, this.maxLength);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

