/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.stats.service.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class ExactValue {
    private final String value;

    private ExactValue(String value) {
        ExactValue.validateFields(value);
        this.value = value;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ExactValue && this.equalTo((ExactValue)other);
    }

    private boolean equalTo(ExactValue other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "ExactValue{value: " + this.value + "}";
    }

    public static ExactValue of(String value) {
        return ExactValue.builder().value(value).build();
    }

    private static void validateFields(String value) {
        List<String> missingFields = null;
        if ((missingFields = ExactValue.addFieldIfMissing(missingFields, value, "value")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private String value;

        private Builder() {
        }

        public Builder from(ExactValue other) {
            this.checkNotBuilt();
            this.value(other.getValue());
            return this;
        }

        @JsonSetter(value="value")
        public Builder value(@Nonnull String value) {
            this.checkNotBuilt();
            this.value = Preconditions.checkNotNull(value, "value cannot be null");
            return this;
        }

        public ExactValue build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new ExactValue(this.value);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

