/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.stats.service.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ColumnType;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ProbabilityInterval;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.Value;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ValueFrequency;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class NumericColumnStats {
    private final ColumnType type;
    private final Value nullCount;
    private final Value uniqueCount;
    private final List<ValueFrequency> frequentItems;
    private final Optional<Value> min;
    private final Optional<Value> max;
    private final Optional<Value> median;
    private final Optional<Value> sum;
    private final Optional<Value> mean;
    private final Optional<Value> variance;
    private final List<ProbabilityInterval> distribution;
    private final Set<String> sampleUniqueItems;
    private final Optional<Value> totalLength;
    private final Optional<Value> maxLength;
    private int memoizedHashCode;

    private NumericColumnStats(ColumnType type, Value nullCount, Value uniqueCount, List<ValueFrequency> frequentItems, Optional<Value> min, Optional<Value> max, Optional<Value> median, Optional<Value> sum, Optional<Value> mean, Optional<Value> variance, List<ProbabilityInterval> distribution, Set<String> sampleUniqueItems, Optional<Value> totalLength, Optional<Value> maxLength) {
        NumericColumnStats.validateFields(type, nullCount, uniqueCount, frequentItems, min, max, median, sum, mean, variance, distribution, sampleUniqueItems, totalLength, maxLength);
        this.type = type;
        this.nullCount = nullCount;
        this.uniqueCount = uniqueCount;
        this.frequentItems = Collections.unmodifiableList(frequentItems);
        this.min = min;
        this.max = max;
        this.median = median;
        this.sum = sum;
        this.mean = mean;
        this.variance = variance;
        this.distribution = Collections.unmodifiableList(distribution);
        this.sampleUniqueItems = Collections.unmodifiableSet(sampleUniqueItems);
        this.totalLength = totalLength;
        this.maxLength = maxLength;
    }

    @JsonProperty(value="type")
    public ColumnType getType() {
        return this.type;
    }

    @JsonProperty(value="nullCount")
    public Value getNullCount() {
        return this.nullCount;
    }

    @JsonProperty(value="uniqueCount")
    public Value getUniqueCount() {
        return this.uniqueCount;
    }

    @JsonProperty(value="frequentItems")
    public List<ValueFrequency> getFrequentItems() {
        return this.frequentItems;
    }

    @JsonProperty(value="min")
    public Optional<Value> getMin() {
        return this.min;
    }

    @JsonProperty(value="max")
    public Optional<Value> getMax() {
        return this.max;
    }

    @JsonProperty(value="median")
    public Optional<Value> getMedian() {
        return this.median;
    }

    @JsonProperty(value="sum")
    public Optional<Value> getSum() {
        return this.sum;
    }

    @JsonProperty(value="mean")
    public Optional<Value> getMean() {
        return this.mean;
    }

    @JsonProperty(value="variance")
    public Optional<Value> getVariance() {
        return this.variance;
    }

    @JsonProperty(value="distribution")
    public List<ProbabilityInterval> getDistribution() {
        return this.distribution;
    }

    @JsonProperty(value="sampleUniqueItems")
    public Set<String> getSampleUniqueItems() {
        return this.sampleUniqueItems;
    }

    @JsonProperty(value="totalLength")
    public Optional<Value> getTotalLength() {
        return this.totalLength;
    }

    @JsonProperty(value="maxLength")
    public Optional<Value> getMaxLength() {
        return this.maxLength;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof NumericColumnStats && this.equalTo((NumericColumnStats)other);
    }

    private boolean equalTo(NumericColumnStats other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.type.equals(other.type) && this.nullCount.equals(other.nullCount) && this.uniqueCount.equals(other.uniqueCount) && this.frequentItems.equals(other.frequentItems) && this.min.equals(other.min) && this.max.equals(other.max) && this.median.equals(other.median) && this.sum.equals(other.sum) && this.mean.equals(other.mean) && this.variance.equals(other.variance) && this.distribution.equals(other.distribution) && this.sampleUniqueItems.equals(other.sampleUniqueItems) && this.totalLength.equals(other.totalLength) && this.maxLength.equals(other.maxLength);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.type.hashCode();
            hash = 31 * hash + this.nullCount.hashCode();
            hash = 31 * hash + this.uniqueCount.hashCode();
            hash = 31 * hash + this.frequentItems.hashCode();
            hash = 31 * hash + this.min.hashCode();
            hash = 31 * hash + this.max.hashCode();
            hash = 31 * hash + this.median.hashCode();
            hash = 31 * hash + this.sum.hashCode();
            hash = 31 * hash + this.mean.hashCode();
            hash = 31 * hash + this.variance.hashCode();
            hash = 31 * hash + this.distribution.hashCode();
            hash = 31 * hash + this.sampleUniqueItems.hashCode();
            hash = 31 * hash + this.totalLength.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.maxLength.hashCode());
        }
        return result;
    }

    public String toString() {
        return "NumericColumnStats{type: " + this.type + ", nullCount: " + this.nullCount + ", uniqueCount: " + this.uniqueCount + ", frequentItems: " + this.frequentItems + ", min: " + this.min + ", max: " + this.max + ", median: " + this.median + ", sum: " + this.sum + ", mean: " + this.mean + ", variance: " + this.variance + ", distribution: " + this.distribution + ", sampleUniqueItems: " + this.sampleUniqueItems + ", totalLength: " + this.totalLength + ", maxLength: " + this.maxLength + "}";
    }

    private static void validateFields(ColumnType type, Value nullCount, Value uniqueCount, List<ValueFrequency> frequentItems, Optional<Value> min, Optional<Value> max, Optional<Value> median, Optional<Value> sum, Optional<Value> mean, Optional<Value> variance, List<ProbabilityInterval> distribution, Set<String> sampleUniqueItems, Optional<Value> totalLength, Optional<Value> maxLength) {
        List<String> missingFields = null;
        missingFields = NumericColumnStats.addFieldIfMissing(missingFields, type, "type");
        missingFields = NumericColumnStats.addFieldIfMissing(missingFields, nullCount, "nullCount");
        missingFields = NumericColumnStats.addFieldIfMissing(missingFields, uniqueCount, "uniqueCount");
        missingFields = NumericColumnStats.addFieldIfMissing(missingFields, frequentItems, "frequentItems");
        missingFields = NumericColumnStats.addFieldIfMissing(missingFields, min, "min");
        missingFields = NumericColumnStats.addFieldIfMissing(missingFields, max, "max");
        missingFields = NumericColumnStats.addFieldIfMissing(missingFields, median, "median");
        missingFields = NumericColumnStats.addFieldIfMissing(missingFields, sum, "sum");
        missingFields = NumericColumnStats.addFieldIfMissing(missingFields, mean, "mean");
        missingFields = NumericColumnStats.addFieldIfMissing(missingFields, variance, "variance");
        missingFields = NumericColumnStats.addFieldIfMissing(missingFields, distribution, "distribution");
        missingFields = NumericColumnStats.addFieldIfMissing(missingFields, sampleUniqueItems, "sampleUniqueItems");
        missingFields = NumericColumnStats.addFieldIfMissing(missingFields, totalLength, "totalLength");
        if ((missingFields = NumericColumnStats.addFieldIfMissing(missingFields, maxLength, "maxLength")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(14);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private ColumnType type;
        private Value nullCount;
        private Value uniqueCount;
        private List<ValueFrequency> frequentItems = new ArrayList<ValueFrequency>();
        private Optional<Value> min = Optional.empty();
        private Optional<Value> max = Optional.empty();
        private Optional<Value> median = Optional.empty();
        private Optional<Value> sum = Optional.empty();
        private Optional<Value> mean = Optional.empty();
        private Optional<Value> variance = Optional.empty();
        private List<ProbabilityInterval> distribution = new ArrayList<ProbabilityInterval>();
        private Set<String> sampleUniqueItems = new LinkedHashSet<String>();
        private Optional<Value> totalLength = Optional.empty();
        private Optional<Value> maxLength = Optional.empty();

        private Builder() {
        }

        public Builder from(NumericColumnStats other) {
            this.checkNotBuilt();
            this.type(other.getType());
            this.nullCount(other.getNullCount());
            this.uniqueCount(other.getUniqueCount());
            this.frequentItems(other.getFrequentItems());
            this.min(other.getMin());
            this.max(other.getMax());
            this.median(other.getMedian());
            this.sum(other.getSum());
            this.mean(other.getMean());
            this.variance(other.getVariance());
            this.distribution(other.getDistribution());
            this.sampleUniqueItems(other.getSampleUniqueItems());
            this.totalLength(other.getTotalLength());
            this.maxLength(other.getMaxLength());
            return this;
        }

        @JsonSetter(value="type")
        public Builder type(@Nonnull ColumnType type) {
            this.checkNotBuilt();
            this.type = Preconditions.checkNotNull(type, "type cannot be null");
            return this;
        }

        @JsonSetter(value="nullCount")
        public Builder nullCount(@Nonnull Value nullCount) {
            this.checkNotBuilt();
            this.nullCount = Preconditions.checkNotNull(nullCount, "nullCount cannot be null");
            return this;
        }

        @JsonSetter(value="uniqueCount")
        public Builder uniqueCount(@Nonnull Value uniqueCount) {
            this.checkNotBuilt();
            this.uniqueCount = Preconditions.checkNotNull(uniqueCount, "uniqueCount cannot be null");
            return this;
        }

        @JsonSetter(value="frequentItems", nulls=Nulls.SKIP)
        public Builder frequentItems(@Nonnull Iterable<ValueFrequency> frequentItems) {
            this.checkNotBuilt();
            this.frequentItems = ConjureCollections.newArrayList(Preconditions.checkNotNull(frequentItems, "frequentItems cannot be null"));
            return this;
        }

        public Builder addAllFrequentItems(@Nonnull Iterable<ValueFrequency> frequentItems) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.frequentItems, Preconditions.checkNotNull(frequentItems, "frequentItems cannot be null"));
            return this;
        }

        public Builder frequentItems(ValueFrequency frequentItems) {
            this.checkNotBuilt();
            this.frequentItems.add(frequentItems);
            return this;
        }

        @JsonSetter(value="min", nulls=Nulls.SKIP)
        public Builder min(@Nonnull Optional<Value> min) {
            this.checkNotBuilt();
            this.min = Preconditions.checkNotNull(min, "min cannot be null");
            return this;
        }

        public Builder min(@Nonnull Value min) {
            this.checkNotBuilt();
            this.min = Optional.of(Preconditions.checkNotNull(min, "min cannot be null"));
            return this;
        }

        @JsonSetter(value="max", nulls=Nulls.SKIP)
        public Builder max(@Nonnull Optional<Value> max) {
            this.checkNotBuilt();
            this.max = Preconditions.checkNotNull(max, "max cannot be null");
            return this;
        }

        public Builder max(@Nonnull Value max) {
            this.checkNotBuilt();
            this.max = Optional.of(Preconditions.checkNotNull(max, "max cannot be null"));
            return this;
        }

        @JsonSetter(value="median", nulls=Nulls.SKIP)
        public Builder median(@Nonnull Optional<Value> median) {
            this.checkNotBuilt();
            this.median = Preconditions.checkNotNull(median, "median cannot be null");
            return this;
        }

        public Builder median(@Nonnull Value median) {
            this.checkNotBuilt();
            this.median = Optional.of(Preconditions.checkNotNull(median, "median cannot be null"));
            return this;
        }

        @JsonSetter(value="sum", nulls=Nulls.SKIP)
        public Builder sum(@Nonnull Optional<Value> sum) {
            this.checkNotBuilt();
            this.sum = Preconditions.checkNotNull(sum, "sum cannot be null");
            return this;
        }

        public Builder sum(@Nonnull Value sum) {
            this.checkNotBuilt();
            this.sum = Optional.of(Preconditions.checkNotNull(sum, "sum cannot be null"));
            return this;
        }

        @JsonSetter(value="mean", nulls=Nulls.SKIP)
        public Builder mean(@Nonnull Optional<Value> mean) {
            this.checkNotBuilt();
            this.mean = Preconditions.checkNotNull(mean, "mean cannot be null");
            return this;
        }

        public Builder mean(@Nonnull Value mean) {
            this.checkNotBuilt();
            this.mean = Optional.of(Preconditions.checkNotNull(mean, "mean cannot be null"));
            return this;
        }

        @JsonSetter(value="variance", nulls=Nulls.SKIP)
        public Builder variance(@Nonnull Optional<Value> variance) {
            this.checkNotBuilt();
            this.variance = Preconditions.checkNotNull(variance, "variance cannot be null");
            return this;
        }

        public Builder variance(@Nonnull Value variance) {
            this.checkNotBuilt();
            this.variance = Optional.of(Preconditions.checkNotNull(variance, "variance cannot be null"));
            return this;
        }

        @JsonSetter(value="distribution", nulls=Nulls.SKIP)
        public Builder distribution(@Nonnull Iterable<ProbabilityInterval> distribution) {
            this.checkNotBuilt();
            this.distribution = ConjureCollections.newArrayList(Preconditions.checkNotNull(distribution, "distribution cannot be null"));
            return this;
        }

        public Builder addAllDistribution(@Nonnull Iterable<ProbabilityInterval> distribution) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.distribution, Preconditions.checkNotNull(distribution, "distribution cannot be null"));
            return this;
        }

        public Builder distribution(ProbabilityInterval distribution) {
            this.checkNotBuilt();
            this.distribution.add(distribution);
            return this;
        }

        @JsonSetter(value="sampleUniqueItems", nulls=Nulls.SKIP)
        public Builder sampleUniqueItems(@Nonnull Iterable<String> sampleUniqueItems) {
            this.checkNotBuilt();
            this.sampleUniqueItems = ConjureCollections.newLinkedHashSet(Preconditions.checkNotNull(sampleUniqueItems, "sampleUniqueItems cannot be null"));
            return this;
        }

        public Builder addAllSampleUniqueItems(@Nonnull Iterable<String> sampleUniqueItems) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.sampleUniqueItems, Preconditions.checkNotNull(sampleUniqueItems, "sampleUniqueItems cannot be null"));
            return this;
        }

        public Builder sampleUniqueItems(String sampleUniqueItems) {
            this.checkNotBuilt();
            this.sampleUniqueItems.add(sampleUniqueItems);
            return this;
        }

        @JsonSetter(value="totalLength", nulls=Nulls.SKIP)
        public Builder totalLength(@Nonnull Optional<Value> totalLength) {
            this.checkNotBuilt();
            this.totalLength = Preconditions.checkNotNull(totalLength, "totalLength cannot be null");
            return this;
        }

        public Builder totalLength(@Nonnull Value totalLength) {
            this.checkNotBuilt();
            this.totalLength = Optional.of(Preconditions.checkNotNull(totalLength, "totalLength cannot be null"));
            return this;
        }

        @JsonSetter(value="maxLength", nulls=Nulls.SKIP)
        public Builder maxLength(@Nonnull Optional<Value> maxLength) {
            this.checkNotBuilt();
            this.maxLength = Preconditions.checkNotNull(maxLength, "maxLength cannot be null");
            return this;
        }

        public Builder maxLength(@Nonnull Value maxLength) {
            this.checkNotBuilt();
            this.maxLength = Optional.of(Preconditions.checkNotNull(maxLength, "maxLength cannot be null"));
            return this;
        }

        public NumericColumnStats build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new NumericColumnStats(this.type, this.nullCount, this.uniqueCount, this.frequentItems, this.min, this.max, this.median, this.sum, this.mean, this.variance, this.distribution, this.sampleUniqueItems, this.totalLength, this.maxLength);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

