/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.stats.service.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class ProbabilityInterval {
    private final String leftBound;
    private final String rightBound;
    private final double probability;
    private int memoizedHashCode;

    private ProbabilityInterval(String leftBound, String rightBound, double probability) {
        ProbabilityInterval.validateFields(leftBound, rightBound);
        this.leftBound = leftBound;
        this.rightBound = rightBound;
        this.probability = probability;
    }

    @JsonProperty(value="leftBound")
    public String getLeftBound() {
        return this.leftBound;
    }

    @JsonProperty(value="rightBound")
    public String getRightBound() {
        return this.rightBound;
    }

    @JsonProperty(value="probability")
    public double getProbability() {
        return this.probability;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ProbabilityInterval && this.equalTo((ProbabilityInterval)other);
    }

    private boolean equalTo(ProbabilityInterval other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.leftBound.equals(other.leftBound) && this.rightBound.equals(other.rightBound) && Double.doubleToLongBits(this.probability) == Double.doubleToLongBits(other.probability);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.leftBound.hashCode();
            hash = 31 * hash + this.rightBound.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + Double.hashCode(this.probability));
        }
        return result;
    }

    public String toString() {
        return "ProbabilityInterval{leftBound: " + this.leftBound + ", rightBound: " + this.rightBound + ", probability: " + this.probability + "}";
    }

    public static ProbabilityInterval of(String leftBound, String rightBound, double probability) {
        return ProbabilityInterval.builder().leftBound(leftBound).rightBound(rightBound).probability(probability).build();
    }

    private static void validateFields(String leftBound, String rightBound) {
        List<String> missingFields = null;
        missingFields = ProbabilityInterval.addFieldIfMissing(missingFields, leftBound, "leftBound");
        if ((missingFields = ProbabilityInterval.addFieldIfMissing(missingFields, rightBound, "rightBound")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private String leftBound;
        private String rightBound;
        private double probability;
        private boolean _probabilityInitialized = false;

        private Builder() {
        }

        public Builder from(ProbabilityInterval other) {
            this.checkNotBuilt();
            this.leftBound(other.getLeftBound());
            this.rightBound(other.getRightBound());
            this.probability(other.getProbability());
            return this;
        }

        @JsonSetter(value="leftBound")
        public Builder leftBound(@Nonnull String leftBound) {
            this.checkNotBuilt();
            this.leftBound = Preconditions.checkNotNull(leftBound, "leftBound cannot be null");
            return this;
        }

        @JsonSetter(value="rightBound")
        public Builder rightBound(@Nonnull String rightBound) {
            this.checkNotBuilt();
            this.rightBound = Preconditions.checkNotNull(rightBound, "rightBound cannot be null");
            return this;
        }

        @JsonSetter(value="probability")
        public Builder probability(double probability) {
            this.checkNotBuilt();
            this.probability = probability;
            this._probabilityInitialized = true;
            return this;
        }

        private void validatePrimitiveFieldsHaveBeenInitialized() {
            List<String> missingFields = null;
            if ((missingFields = Builder.addFieldIfMissing(missingFields, this._probabilityInitialized, "probability")) != null) {
                throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
            }
        }

        private static List<String> addFieldIfMissing(List<String> prev, boolean initialized, String fieldName) {
            List<String> missingFields = prev;
            if (!initialized) {
                if (missingFields == null) {
                    missingFields = new ArrayList<String>(1);
                }
                missingFields.add(fieldName);
            }
            return missingFields;
        }

        public ProbabilityInterval build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            this.validatePrimitiveFieldsHaveBeenInitialized();
            return new ProbabilityInterval(this.leftBound, this.rightBound, this.probability);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

