/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.stats.service.api;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnyGetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnySetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSubTypes;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ApproximateGaussianValue;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ApproximateGenericValue;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ExactValue;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class Value {
    private final Base value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private Value(Base value) {
        this.value = value;
    }

    @JsonValue
    private Base getValue() {
        return this.value;
    }

    public static Value exactValue(ExactValue value) {
        return new Value(new ExactValueWrapper(value));
    }

    public static Value approximateGaussianValue(ApproximateGaussianValue value) {
        return new Value(new ApproximateGaussianValueWrapper(value));
    }

    public static Value approximateGenericValue(ApproximateGenericValue value) {
        return new Value(new ApproximateGenericValueWrapper(value));
    }

    public static Value unknown(@Safe String type, Object value) {
        switch (Preconditions.checkNotNull(type, "Type is required")) {
            case "exactValue": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: exactValue", new Arg[0]);
            }
            case "approximateGaussianValue": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: approximateGaussianValue", new Arg[0]);
            }
            case "approximateGenericValue": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: approximateGenericValue", new Arg[0]);
            }
        }
        return new Value(new UnknownWrapper(type, Collections.singletonMap(type, value)));
    }

    public <T> T accept(Visitor<T> visitor) {
        return this.value.accept(visitor);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Value && this.equalTo((Value)other);
    }

    private boolean equalTo(Value other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "Value{value: " + this.value + "}";
    }

    private static final class UnknownWrapper
    implements Base {
        private final String type;
        private final Map<String, Object> value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private UnknownWrapper(@JsonProperty(value="type") String type) {
            this(type, new HashMap<String, Object>());
        }

        private UnknownWrapper(@Nonnull String type, @Nonnull Map<String, Object> value) {
            Preconditions.checkNotNull(type, "type cannot be null");
            Preconditions.checkNotNull(value, "value cannot be null");
            this.type = type;
            this.value = value;
        }

        @JsonProperty
        private String getType() {
            return this.type;
        }

        @JsonAnyGetter
        private Map<String, Object> getValue() {
            return this.value;
        }

        @JsonAnySetter
        private void put(String key, Object val) {
            this.value.put(key, val);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitUnknown(this.type);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof UnknownWrapper && this.equalTo((UnknownWrapper)other);
        }

        private boolean equalTo(UnknownWrapper other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + this.type.hashCode();
            hash = 31 * hash + this.value.hashCode();
            return hash;
        }

        public String toString() {
            return "UnknownWrapper{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="approximateGenericValue")
    private static final class ApproximateGenericValueWrapper
    implements Base {
        private final ApproximateGenericValue value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ApproximateGenericValueWrapper(@JsonSetter(value="approximateGenericValue") @Nonnull ApproximateGenericValue value) {
            Preconditions.checkNotNull(value, "approximateGenericValue cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "approximateGenericValue";
        }

        @JsonProperty(value="approximateGenericValue")
        private ApproximateGenericValue getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitApproximateGenericValue(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof ApproximateGenericValueWrapper && this.equalTo((ApproximateGenericValueWrapper)other);
        }

        private boolean equalTo(ApproximateGenericValueWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "ApproximateGenericValueWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="approximateGaussianValue")
    private static final class ApproximateGaussianValueWrapper
    implements Base {
        private final ApproximateGaussianValue value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ApproximateGaussianValueWrapper(@JsonSetter(value="approximateGaussianValue") @Nonnull ApproximateGaussianValue value) {
            Preconditions.checkNotNull(value, "approximateGaussianValue cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "approximateGaussianValue";
        }

        @JsonProperty(value="approximateGaussianValue")
        private ApproximateGaussianValue getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitApproximateGaussianValue(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof ApproximateGaussianValueWrapper && this.equalTo((ApproximateGaussianValueWrapper)other);
        }

        private boolean equalTo(ApproximateGaussianValueWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "ApproximateGaussianValueWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="exactValue")
    private static final class ExactValueWrapper
    implements Base {
        private final ExactValue value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ExactValueWrapper(@JsonSetter(value="exactValue") @Nonnull ExactValue value) {
            Preconditions.checkNotNull(value, "exactValue cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "exactValue";
        }

        @JsonProperty(value="exactValue")
        private ExactValue getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitExactValue(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof ExactValueWrapper && this.equalTo((ExactValueWrapper)other);
        }

        private boolean equalTo(ExactValueWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "ExactValueWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=UnknownWrapper.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ExactValueWrapper.class), @JsonSubTypes.Type(value=ApproximateGaussianValueWrapper.class), @JsonSubTypes.Type(value=ApproximateGenericValueWrapper.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Base {
        public <T> T accept(Visitor<T> var1);
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface ExactValueStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> exactValue(@Nonnull Function<ExactValue, T> var1);
    }

    public static interface ApproximateGenericValueStageVisitorBuilder<T> {
        public ExactValueStageVisitorBuilder<T> approximateGenericValue(@Nonnull Function<ApproximateGenericValue, T> var1);
    }

    public static interface ApproximateGaussianValueStageVisitorBuilder<T> {
        public ApproximateGenericValueStageVisitorBuilder<T> approximateGaussianValue(@Nonnull Function<ApproximateGaussianValue, T> var1);
    }

    private static final class VisitorBuilder<T>
    implements ApproximateGaussianValueStageVisitorBuilder<T>,
    ApproximateGenericValueStageVisitorBuilder<T>,
    ExactValueStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Function<ApproximateGaussianValue, T> approximateGaussianValueVisitor;
        private Function<ApproximateGenericValue, T> approximateGenericValueVisitor;
        private Function<ExactValue, T> exactValueVisitor;
        private Function<String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public ApproximateGenericValueStageVisitorBuilder<T> approximateGaussianValue(@Nonnull Function<ApproximateGaussianValue, T> approximateGaussianValueVisitor) {
            Preconditions.checkNotNull(approximateGaussianValueVisitor, "approximateGaussianValueVisitor cannot be null");
            this.approximateGaussianValueVisitor = approximateGaussianValueVisitor;
            return this;
        }

        @Override
        public ExactValueStageVisitorBuilder<T> approximateGenericValue(@Nonnull Function<ApproximateGenericValue, T> approximateGenericValueVisitor) {
            Preconditions.checkNotNull(approximateGenericValueVisitor, "approximateGenericValueVisitor cannot be null");
            this.approximateGenericValueVisitor = approximateGenericValueVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> exactValue(@Nonnull Function<ExactValue, T> exactValueVisitor) {
            Preconditions.checkNotNull(exactValueVisitor, "exactValueVisitor cannot be null");
            this.exactValueVisitor = exactValueVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'Value' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Function<ApproximateGaussianValue, T> approximateGaussianValueVisitor = this.approximateGaussianValueVisitor;
            final Function<ApproximateGenericValue, T> approximateGenericValueVisitor = this.approximateGenericValueVisitor;
            final Function<ExactValue, T> exactValueVisitor = this.exactValueVisitor;
            final Function<String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitApproximateGaussianValue(ApproximateGaussianValue value) {
                    return approximateGaussianValueVisitor.apply(value);
                }

                @Override
                public T visitApproximateGenericValue(ApproximateGenericValue value) {
                    return approximateGenericValueVisitor.apply(value);
                }

                @Override
                public T visitExactValue(ExactValue value) {
                    return exactValueVisitor.apply(value);
                }

                @Override
                public T visitUnknown(String value) {
                    return unknownVisitor.apply(value);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitExactValue(ExactValue var1);

        public T visitApproximateGaussianValue(ApproximateGaussianValue var1);

        public T visitApproximateGenericValue(ApproximateGenericValue var1);

        public T visitUnknown(@Safe String var1);

        public static <T> ApproximateGaussianValueStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }
}

