/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundry.stats.service.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.Value;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class ValueFrequency {
    private final String value;
    private final Value frequency;
    private int memoizedHashCode;

    private ValueFrequency(String value, Value frequency) {
        ValueFrequency.validateFields(value, frequency);
        this.value = value;
        this.frequency = frequency;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="frequency")
    public Value getFrequency() {
        return this.frequency;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ValueFrequency && this.equalTo((ValueFrequency)other);
    }

    private boolean equalTo(ValueFrequency other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.value.equals(other.value) && this.frequency.equals(other.frequency);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.value.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.frequency.hashCode());
        }
        return result;
    }

    public String toString() {
        return "ValueFrequency{value: " + this.value + ", frequency: " + this.frequency + "}";
    }

    public static ValueFrequency of(String value, Value frequency) {
        return ValueFrequency.builder().value(value).frequency(frequency).build();
    }

    private static void validateFields(String value, Value frequency) {
        List<String> missingFields = null;
        missingFields = ValueFrequency.addFieldIfMissing(missingFields, value, "value");
        if ((missingFields = ValueFrequency.addFieldIfMissing(missingFields, frequency, "frequency")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private String value;
        private Value frequency;

        private Builder() {
        }

        public Builder from(ValueFrequency other) {
            this.checkNotBuilt();
            this.value(other.getValue());
            this.frequency(other.getFrequency());
            return this;
        }

        @JsonSetter(value="value")
        public Builder value(@Nonnull String value) {
            this.checkNotBuilt();
            this.value = Preconditions.checkNotNull(value, "value cannot be null");
            return this;
        }

        @JsonSetter(value="frequency")
        public Builder frequency(@Nonnull Value frequency) {
            this.checkNotBuilt();
            this.frequency = Preconditions.checkNotNull(frequency, "frequency cannot be null");
            return this;
        }

        public ValueFrequency build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new ValueFrequency(this.value, this.frequency);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

