/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class CatalogInfo {
    private final String catalogName;

    private CatalogInfo(String catalogName) {
        CatalogInfo.validateFields(catalogName);
        this.catalogName = catalogName;
    }

    @JsonProperty(value="catalogName")
    @Unsafe
    public String getCatalogName() {
        return this.catalogName;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof CatalogInfo && this.equalTo((CatalogInfo)other);
    }

    private boolean equalTo(CatalogInfo other) {
        return this.catalogName.equals(other.catalogName);
    }

    public int hashCode() {
        return this.catalogName.hashCode();
    }

    @Unsafe
    public String toString() {
        return "CatalogInfo{catalogName: " + this.catalogName + "}";
    }

    public static CatalogInfo of(@Unsafe String catalogName) {
        return CatalogInfo.builder().catalogName(catalogName).build();
    }

    private static void validateFields(String catalogName) {
        List<String> missingFields = null;
        if ((missingFields = CatalogInfo.addFieldIfMissing(missingFields, catalogName, "catalogName")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static CatalogNameStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        @Unsafe
        private String catalogName;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(CatalogInfo other) {
            this.checkNotBuilt();
            this.catalogName(other.getCatalogName());
            return this;
        }

        @Override
        @JsonSetter(value="catalogName")
        public Builder catalogName(@Nonnull @Unsafe String catalogName) {
            this.checkNotBuilt();
            this.catalogName = Preconditions.checkNotNull(catalogName, "catalogName cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public CatalogInfo build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new CatalogInfo(this.catalogName);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends CatalogNameStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder catalogName(@Nonnull @Unsafe String var1);

        @Override
        public Builder from(CatalogInfo var1);

        @Override
        @CheckReturnValue
        public CatalogInfo build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public CatalogInfo build();
    }

    public static interface CatalogNameStageBuilder {
        public Completed_StageBuilder catalogName(@Nonnull @Unsafe String var1);

        public Builder from(CatalogInfo var1);
    }
}

