/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.google.errorprone.annotations.Immutable;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
@Immutable
public final class CatalogMode {
    public static final CatalogMode ONTOLOGY = new CatalogMode(Value.ONTOLOGY, "ONTOLOGY");
    public static final CatalogMode TABULAR = new CatalogMode(Value.TABULAR, "TABULAR");
    private static final List<CatalogMode> values = Collections.unmodifiableList(Arrays.asList(ONTOLOGY, TABULAR));
    private final Value value;
    private final String string;

    private CatalogMode(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value get() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || this.value == Value.UNKNOWN && other instanceof CatalogMode && this.string.equals(((CatalogMode)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static CatalogMode valueOf(@Nonnull @Safe String value) {
        String upperCasedValue;
        Preconditions.checkNotNull(value, "value cannot be null");
        switch (upperCasedValue = value.toUpperCase(Locale.ROOT)) {
            case "ONTOLOGY": {
                return ONTOLOGY;
            }
            case "TABULAR": {
                return TABULAR;
            }
        }
        return new CatalogMode(Value.UNKNOWN, upperCasedValue);
    }

    public <T> T accept(Visitor<T> visitor) {
        switch (this.value) {
            case ONTOLOGY: {
                return visitor.visitOntology();
            }
            case TABULAR: {
                return visitor.visitTabular();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    public static List<CatalogMode> values() {
        return values;
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface TabularStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> visitTabular(@Nonnull Supplier<T> var1);
    }

    public static interface OntologyStageVisitorBuilder<T> {
        public TabularStageVisitorBuilder<T> visitOntology(@Nonnull Supplier<T> var1);
    }

    private static final class VisitorBuilder<T>
    implements OntologyStageVisitorBuilder<T>,
    TabularStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Supplier<T> ontologyVisitor;
        private Supplier<T> tabularVisitor;
        private Function<@Safe String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public TabularStageVisitorBuilder<T> visitOntology(@Nonnull Supplier<T> ontologyVisitor) {
            Preconditions.checkNotNull(ontologyVisitor, "ontologyVisitor cannot be null");
            this.ontologyVisitor = ontologyVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> visitTabular(@Nonnull Supplier<T> tabularVisitor) {
            Preconditions.checkNotNull(tabularVisitor, "tabularVisitor cannot be null");
            this.tabularVisitor = tabularVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownType -> unknownVisitor.apply((String)unknownType);
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'CatalogMode' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Supplier<T> ontologyVisitor = this.ontologyVisitor;
            final Supplier<T> tabularVisitor = this.tabularVisitor;
            final Function<@Safe String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitOntology() {
                    return ontologyVisitor.get();
                }

                @Override
                public T visitTabular() {
                    return tabularVisitor.get();
                }

                @Override
                public T visitUnknown(String unknownType) {
                    return unknownVisitor.apply(unknownType);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitOntology();

        public T visitTabular();

        public T visitUnknown(String var1);

        public static <T> OntologyStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }

    public static enum Value {
        ONTOLOGY,
        TABULAR,
        UNKNOWN;

    }
}

