/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ServiceInfo;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class ClientServices {
    private final ServiceInfo compass;
    private final ServiceInfo multipass;
    private int memoizedHashCode;

    private ClientServices(ServiceInfo compass, ServiceInfo multipass) {
        ClientServices.validateFields(compass, multipass);
        this.compass = compass;
        this.multipass = multipass;
    }

    @JsonProperty(value="compass")
    public ServiceInfo getCompass() {
        return this.compass;
    }

    @JsonProperty(value="multipass")
    public ServiceInfo getMultipass() {
        return this.multipass;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ClientServices && this.equalTo((ClientServices)other);
    }

    private boolean equalTo(ClientServices other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.compass.equals(other.compass) && this.multipass.equals(other.multipass);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.compass.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.multipass.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "ClientServices{compass: " + String.valueOf(this.compass) + ", multipass: " + String.valueOf(this.multipass) + "}";
    }

    public static ClientServices of(ServiceInfo compass, ServiceInfo multipass) {
        return ClientServices.builder().compass(compass).multipass(multipass).build();
    }

    private static void validateFields(ServiceInfo compass, ServiceInfo multipass) {
        List<String> missingFields = null;
        missingFields = ClientServices.addFieldIfMissing(missingFields, compass, "compass");
        if ((missingFields = ClientServices.addFieldIfMissing(missingFields, multipass, "multipass")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static CompassStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private ServiceInfo compass;
        private ServiceInfo multipass;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(ClientServices other) {
            this.checkNotBuilt();
            this.compass(other.getCompass());
            this.multipass(other.getMultipass());
            return this;
        }

        @Override
        @JsonSetter(value="compass")
        public Builder compass(@Nonnull ServiceInfo compass) {
            this.checkNotBuilt();
            this.compass = Preconditions.checkNotNull(compass, "compass cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="multipass")
        public Builder multipass(@Nonnull ServiceInfo multipass) {
            this.checkNotBuilt();
            this.multipass = Preconditions.checkNotNull(multipass, "multipass cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public ClientServices build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new ClientServices(this.compass, this.multipass);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends CompassStageBuilder,
    MultipassStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder compass(@Nonnull ServiceInfo var1);

        @Override
        public Builder from(ClientServices var1);

        @Override
        public Builder multipass(@Nonnull ServiceInfo var1);

        @Override
        @CheckReturnValue
        public ClientServices build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public ClientServices build();
    }

    public static interface MultipassStageBuilder {
        public Completed_StageBuilder multipass(@Nonnull ServiceInfo var1);
    }

    public static interface CompassStageBuilder {
        public MultipassStageBuilder compass(@Nonnull ServiceInfo var1);

        public Builder from(ClientServices var1);
    }
}

