/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.FailureReason;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class FailedQueryStatus {
    private final Optional<String> errorMessage;
    private final FailureReason failureReason;
    private int memoizedHashCode;

    private FailedQueryStatus(Optional<String> errorMessage, FailureReason failureReason) {
        FailedQueryStatus.validateFields(errorMessage, failureReason);
        this.errorMessage = errorMessage;
        this.failureReason = failureReason;
    }

    @JsonProperty(value="errorMessage")
    @Unsafe
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="failureReason")
    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof FailedQueryStatus && this.equalTo((FailedQueryStatus)other);
    }

    private boolean equalTo(FailedQueryStatus other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.errorMessage.equals(other.errorMessage) && this.failureReason.equals(other.failureReason);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.errorMessage.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.failureReason.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "FailedQueryStatus{errorMessage: " + String.valueOf(this.errorMessage) + ", failureReason: " + String.valueOf(this.failureReason) + "}";
    }

    public static FailedQueryStatus of(@Unsafe String errorMessage, FailureReason failureReason) {
        return FailedQueryStatus.builder().failureReason(failureReason).errorMessage(Optional.of(errorMessage)).build();
    }

    private static void validateFields(Optional<String> errorMessage, FailureReason failureReason) {
        List<String> missingFields = null;
        missingFields = FailedQueryStatus.addFieldIfMissing(missingFields, errorMessage, "errorMessage");
        if ((missingFields = FailedQueryStatus.addFieldIfMissing(missingFields, failureReason, "failureReason")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static FailureReasonStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private Optional<@Unsafe String> errorMessage = Optional.empty();
        private FailureReason failureReason;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(FailedQueryStatus other) {
            this.checkNotBuilt();
            this.errorMessage((Optional)other.getErrorMessage());
            this.failureReason(other.getFailureReason());
            return this;
        }

        @Override
        @JsonSetter(value="errorMessage", nulls=Nulls.SKIP)
        public Builder errorMessage(@Nonnull Optional<@Unsafe String> errorMessage) {
            this.checkNotBuilt();
            this.errorMessage = Preconditions.checkNotNull(errorMessage, "errorMessage cannot be null");
            return this;
        }

        @Override
        public Builder errorMessage(@Nonnull @Unsafe String errorMessage) {
            this.checkNotBuilt();
            this.errorMessage = Optional.of(Preconditions.checkNotNull(errorMessage, "errorMessage cannot be null"));
            return this;
        }

        @Override
        @JsonSetter(value="failureReason")
        public Builder failureReason(@Nonnull FailureReason failureReason) {
            this.checkNotBuilt();
            this.failureReason = Preconditions.checkNotNull(failureReason, "failureReason cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public FailedQueryStatus build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new FailedQueryStatus(this.errorMessage, this.failureReason);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends FailureReasonStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder failureReason(@Nonnull FailureReason var1);

        @Override
        public Builder from(FailedQueryStatus var1);

        @Override
        @CheckReturnValue
        public FailedQueryStatus build();

        @Override
        public Builder errorMessage(@Nonnull Optional<@Unsafe String> var1);

        @Override
        public Builder errorMessage(@Nonnull @Unsafe String var1);
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public FailedQueryStatus build();

        public Completed_StageBuilder errorMessage(@Nonnull Optional<@Unsafe String> var1);

        public Completed_StageBuilder errorMessage(@Nonnull @Unsafe String var1);
    }

    public static interface FailureReasonStageBuilder {
        public Completed_StageBuilder failureReason(@Nonnull FailureReason var1);

        public Builder from(FailedQueryStatus var1);
    }
}

