/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.google.errorprone.annotations.Immutable;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
@Immutable
public final class FailureReason {
    public static final FailureReason FAILED_TO_START = new FailureReason(Value.FAILED_TO_START, "FAILED_TO_START");
    public static final FailureReason FAILED_TO_EXECUTE = new FailureReason(Value.FAILED_TO_EXECUTE, "FAILED_TO_EXECUTE");
    public static final FailureReason JOB_NOT_FOUND = new FailureReason(Value.JOB_NOT_FOUND, "JOB_NOT_FOUND");
    public static final FailureReason TIMED_OUT = new FailureReason(Value.TIMED_OUT, "TIMED_OUT");
    private static final List<FailureReason> values = Collections.unmodifiableList(Arrays.asList(FAILED_TO_START, FAILED_TO_EXECUTE, JOB_NOT_FOUND, TIMED_OUT));
    private final Value value;
    private final String string;

    private FailureReason(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value get() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || this.value == Value.UNKNOWN && other instanceof FailureReason && this.string.equals(((FailureReason)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static FailureReason valueOf(@Nonnull @Safe String value) {
        String upperCasedValue;
        Preconditions.checkNotNull(value, "value cannot be null");
        switch (upperCasedValue = value.toUpperCase(Locale.ROOT)) {
            case "FAILED_TO_START": {
                return FAILED_TO_START;
            }
            case "FAILED_TO_EXECUTE": {
                return FAILED_TO_EXECUTE;
            }
            case "JOB_NOT_FOUND": {
                return JOB_NOT_FOUND;
            }
            case "TIMED_OUT": {
                return TIMED_OUT;
            }
        }
        return new FailureReason(Value.UNKNOWN, upperCasedValue);
    }

    public <T> T accept(Visitor<T> visitor) {
        switch (this.value) {
            case FAILED_TO_START: {
                return visitor.visitFailedToStart();
            }
            case FAILED_TO_EXECUTE: {
                return visitor.visitFailedToExecute();
            }
            case JOB_NOT_FOUND: {
                return visitor.visitJobNotFound();
            }
            case TIMED_OUT: {
                return visitor.visitTimedOut();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    public static List<FailureReason> values() {
        return values;
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface TimedOutStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> visitTimedOut(@Nonnull Supplier<T> var1);
    }

    public static interface JobNotFoundStageVisitorBuilder<T> {
        public TimedOutStageVisitorBuilder<T> visitJobNotFound(@Nonnull Supplier<T> var1);
    }

    public static interface FailedToExecuteStageVisitorBuilder<T> {
        public JobNotFoundStageVisitorBuilder<T> visitFailedToExecute(@Nonnull Supplier<T> var1);
    }

    public static interface FailedToStartStageVisitorBuilder<T> {
        public FailedToExecuteStageVisitorBuilder<T> visitFailedToStart(@Nonnull Supplier<T> var1);
    }

    private static final class VisitorBuilder<T>
    implements FailedToStartStageVisitorBuilder<T>,
    FailedToExecuteStageVisitorBuilder<T>,
    JobNotFoundStageVisitorBuilder<T>,
    TimedOutStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Supplier<T> failedToStartVisitor;
        private Supplier<T> failedToExecuteVisitor;
        private Supplier<T> jobNotFoundVisitor;
        private Supplier<T> timedOutVisitor;
        private Function<@Safe String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public FailedToExecuteStageVisitorBuilder<T> visitFailedToStart(@Nonnull Supplier<T> failedToStartVisitor) {
            Preconditions.checkNotNull(failedToStartVisitor, "failedToStartVisitor cannot be null");
            this.failedToStartVisitor = failedToStartVisitor;
            return this;
        }

        @Override
        public JobNotFoundStageVisitorBuilder<T> visitFailedToExecute(@Nonnull Supplier<T> failedToExecuteVisitor) {
            Preconditions.checkNotNull(failedToExecuteVisitor, "failedToExecuteVisitor cannot be null");
            this.failedToExecuteVisitor = failedToExecuteVisitor;
            return this;
        }

        @Override
        public TimedOutStageVisitorBuilder<T> visitJobNotFound(@Nonnull Supplier<T> jobNotFoundVisitor) {
            Preconditions.checkNotNull(jobNotFoundVisitor, "jobNotFoundVisitor cannot be null");
            this.jobNotFoundVisitor = jobNotFoundVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> visitTimedOut(@Nonnull Supplier<T> timedOutVisitor) {
            Preconditions.checkNotNull(timedOutVisitor, "timedOutVisitor cannot be null");
            this.timedOutVisitor = timedOutVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownType -> unknownVisitor.apply((String)unknownType);
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'FailureReason' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Supplier<T> failedToStartVisitor = this.failedToStartVisitor;
            final Supplier<T> failedToExecuteVisitor = this.failedToExecuteVisitor;
            final Supplier<T> jobNotFoundVisitor = this.jobNotFoundVisitor;
            final Supplier<T> timedOutVisitor = this.timedOutVisitor;
            final Function<@Safe String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitFailedToStart() {
                    return failedToStartVisitor.get();
                }

                @Override
                public T visitFailedToExecute() {
                    return failedToExecuteVisitor.get();
                }

                @Override
                public T visitJobNotFound() {
                    return jobNotFoundVisitor.get();
                }

                @Override
                public T visitTimedOut() {
                    return timedOutVisitor.get();
                }

                @Override
                public T visitUnknown(String unknownType) {
                    return unknownVisitor.apply(unknownType);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitFailedToStart();

        public T visitFailedToExecute();

        public T visitJobNotFound();

        public T visitTimedOut();

        public T visitUnknown(String var1);

        public static <T> FailedToStartStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }

    public static enum Value {
        FAILED_TO_START,
        FAILED_TO_EXECUTE,
        JOB_NOT_FOUND,
        TIMED_OUT,
        UNKNOWN;

    }
}

