/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ForeignKeyRelationDirection;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TableInfoV2;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class ForeignKeyRelation {
    private final TableInfoV2 primaryKeyTable;
    private final TableInfoV2 foreignKeyTable;
    private final String primaryKeyColumnName;
    private final String foreignKeyColumnName;
    private final ForeignKeyRelationDirection direction;
    private int memoizedHashCode;

    private ForeignKeyRelation(TableInfoV2 primaryKeyTable, TableInfoV2 foreignKeyTable, String primaryKeyColumnName, String foreignKeyColumnName, ForeignKeyRelationDirection direction) {
        ForeignKeyRelation.validateFields(primaryKeyTable, foreignKeyTable, primaryKeyColumnName, foreignKeyColumnName, direction);
        this.primaryKeyTable = primaryKeyTable;
        this.foreignKeyTable = foreignKeyTable;
        this.primaryKeyColumnName = primaryKeyColumnName;
        this.foreignKeyColumnName = foreignKeyColumnName;
        this.direction = direction;
    }

    @JsonProperty(value="primaryKeyTable")
    public TableInfoV2 getPrimaryKeyTable() {
        return this.primaryKeyTable;
    }

    @JsonProperty(value="foreignKeyTable")
    public TableInfoV2 getForeignKeyTable() {
        return this.foreignKeyTable;
    }

    @JsonProperty(value="primaryKeyColumnName")
    @Unsafe
    public String getPrimaryKeyColumnName() {
        return this.primaryKeyColumnName;
    }

    @JsonProperty(value="foreignKeyColumnName")
    @Unsafe
    public String getForeignKeyColumnName() {
        return this.foreignKeyColumnName;
    }

    @JsonProperty(value="direction")
    public ForeignKeyRelationDirection getDirection() {
        return this.direction;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ForeignKeyRelation && this.equalTo((ForeignKeyRelation)other);
    }

    private boolean equalTo(ForeignKeyRelation other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.primaryKeyTable.equals(other.primaryKeyTable) && this.foreignKeyTable.equals(other.foreignKeyTable) && this.primaryKeyColumnName.equals(other.primaryKeyColumnName) && this.foreignKeyColumnName.equals(other.foreignKeyColumnName) && this.direction.equals(other.direction);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.primaryKeyTable.hashCode();
            hash = 31 * hash + this.foreignKeyTable.hashCode();
            hash = 31 * hash + this.primaryKeyColumnName.hashCode();
            hash = 31 * hash + this.foreignKeyColumnName.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.direction.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "ForeignKeyRelation{primaryKeyTable: " + String.valueOf(this.primaryKeyTable) + ", foreignKeyTable: " + String.valueOf(this.foreignKeyTable) + ", primaryKeyColumnName: " + this.primaryKeyColumnName + ", foreignKeyColumnName: " + this.foreignKeyColumnName + ", direction: " + String.valueOf(this.direction) + "}";
    }

    private static void validateFields(TableInfoV2 primaryKeyTable, TableInfoV2 foreignKeyTable, String primaryKeyColumnName, String foreignKeyColumnName, ForeignKeyRelationDirection direction) {
        List<String> missingFields = null;
        missingFields = ForeignKeyRelation.addFieldIfMissing(missingFields, primaryKeyTable, "primaryKeyTable");
        missingFields = ForeignKeyRelation.addFieldIfMissing(missingFields, foreignKeyTable, "foreignKeyTable");
        missingFields = ForeignKeyRelation.addFieldIfMissing(missingFields, primaryKeyColumnName, "primaryKeyColumnName");
        missingFields = ForeignKeyRelation.addFieldIfMissing(missingFields, foreignKeyColumnName, "foreignKeyColumnName");
        if ((missingFields = ForeignKeyRelation.addFieldIfMissing(missingFields, direction, "direction")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(5);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static PrimaryKeyTableStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private TableInfoV2 primaryKeyTable;
        private TableInfoV2 foreignKeyTable;
        @Unsafe
        private String primaryKeyColumnName;
        @Unsafe
        private String foreignKeyColumnName;
        private ForeignKeyRelationDirection direction;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(ForeignKeyRelation other) {
            this.checkNotBuilt();
            this.primaryKeyTable(other.getPrimaryKeyTable());
            this.foreignKeyTable(other.getForeignKeyTable());
            this.primaryKeyColumnName(other.getPrimaryKeyColumnName());
            this.foreignKeyColumnName(other.getForeignKeyColumnName());
            this.direction(other.getDirection());
            return this;
        }

        @Override
        @JsonSetter(value="primaryKeyTable")
        public Builder primaryKeyTable(@Nonnull TableInfoV2 primaryKeyTable) {
            this.checkNotBuilt();
            this.primaryKeyTable = Preconditions.checkNotNull(primaryKeyTable, "primaryKeyTable cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="foreignKeyTable")
        public Builder foreignKeyTable(@Nonnull TableInfoV2 foreignKeyTable) {
            this.checkNotBuilt();
            this.foreignKeyTable = Preconditions.checkNotNull(foreignKeyTable, "foreignKeyTable cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="primaryKeyColumnName")
        public Builder primaryKeyColumnName(@Nonnull @Unsafe String primaryKeyColumnName) {
            this.checkNotBuilt();
            this.primaryKeyColumnName = Preconditions.checkNotNull(primaryKeyColumnName, "primaryKeyColumnName cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="foreignKeyColumnName")
        public Builder foreignKeyColumnName(@Nonnull @Unsafe String foreignKeyColumnName) {
            this.checkNotBuilt();
            this.foreignKeyColumnName = Preconditions.checkNotNull(foreignKeyColumnName, "foreignKeyColumnName cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="direction")
        public Builder direction(@Nonnull ForeignKeyRelationDirection direction) {
            this.checkNotBuilt();
            this.direction = Preconditions.checkNotNull(direction, "direction cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public ForeignKeyRelation build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new ForeignKeyRelation(this.primaryKeyTable, this.foreignKeyTable, this.primaryKeyColumnName, this.foreignKeyColumnName, this.direction);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends PrimaryKeyTableStageBuilder,
    ForeignKeyTableStageBuilder,
    PrimaryKeyColumnNameStageBuilder,
    ForeignKeyColumnNameStageBuilder,
    DirectionStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder primaryKeyTable(@Nonnull TableInfoV2 var1);

        @Override
        public Builder from(ForeignKeyRelation var1);

        @Override
        public Builder foreignKeyTable(@Nonnull TableInfoV2 var1);

        @Override
        public Builder primaryKeyColumnName(@Nonnull @Unsafe String var1);

        @Override
        public Builder foreignKeyColumnName(@Nonnull @Unsafe String var1);

        @Override
        public Builder direction(@Nonnull ForeignKeyRelationDirection var1);

        @Override
        @CheckReturnValue
        public ForeignKeyRelation build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public ForeignKeyRelation build();
    }

    public static interface DirectionStageBuilder {
        public Completed_StageBuilder direction(@Nonnull ForeignKeyRelationDirection var1);
    }

    public static interface ForeignKeyColumnNameStageBuilder {
        public DirectionStageBuilder foreignKeyColumnName(@Nonnull @Unsafe String var1);
    }

    public static interface PrimaryKeyColumnNameStageBuilder {
        public ForeignKeyColumnNameStageBuilder primaryKeyColumnName(@Nonnull @Unsafe String var1);
    }

    public static interface ForeignKeyTableStageBuilder {
        public PrimaryKeyColumnNameStageBuilder foreignKeyTable(@Nonnull TableInfoV2 var1);
    }

    public static interface PrimaryKeyTableStageBuilder {
        public ForeignKeyTableStageBuilder primaryKeyTable(@Nonnull TableInfoV2 var1);

        public Builder from(ForeignKeyRelation var1);
    }
}

