/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.google.errorprone.annotations.Immutable;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
@Immutable
public final class ForeignKeyRelationDirection {
    public static final ForeignKeyRelationDirection PRIMARY_TO_FOREIGN = new ForeignKeyRelationDirection(Value.PRIMARY_TO_FOREIGN, "PRIMARY_TO_FOREIGN");
    public static final ForeignKeyRelationDirection FOREIGN_TO_PRIMARY = new ForeignKeyRelationDirection(Value.FOREIGN_TO_PRIMARY, "FOREIGN_TO_PRIMARY");
    private static final List<ForeignKeyRelationDirection> values = Collections.unmodifiableList(Arrays.asList(PRIMARY_TO_FOREIGN, FOREIGN_TO_PRIMARY));
    private final Value value;
    private final String string;

    private ForeignKeyRelationDirection(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value get() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || this.value == Value.UNKNOWN && other instanceof ForeignKeyRelationDirection && this.string.equals(((ForeignKeyRelationDirection)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static ForeignKeyRelationDirection valueOf(@Nonnull @Safe String value) {
        String upperCasedValue;
        Preconditions.checkNotNull(value, "value cannot be null");
        switch (upperCasedValue = value.toUpperCase(Locale.ROOT)) {
            case "PRIMARY_TO_FOREIGN": {
                return PRIMARY_TO_FOREIGN;
            }
            case "FOREIGN_TO_PRIMARY": {
                return FOREIGN_TO_PRIMARY;
            }
        }
        return new ForeignKeyRelationDirection(Value.UNKNOWN, upperCasedValue);
    }

    public <T> T accept(Visitor<T> visitor) {
        switch (this.value) {
            case PRIMARY_TO_FOREIGN: {
                return visitor.visitPrimaryToForeign();
            }
            case FOREIGN_TO_PRIMARY: {
                return visitor.visitForeignToPrimary();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    public static List<ForeignKeyRelationDirection> values() {
        return values;
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface ForeignToPrimaryStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> visitForeignToPrimary(@Nonnull Supplier<T> var1);
    }

    public static interface PrimaryToForeignStageVisitorBuilder<T> {
        public ForeignToPrimaryStageVisitorBuilder<T> visitPrimaryToForeign(@Nonnull Supplier<T> var1);
    }

    private static final class VisitorBuilder<T>
    implements PrimaryToForeignStageVisitorBuilder<T>,
    ForeignToPrimaryStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Supplier<T> primaryToForeignVisitor;
        private Supplier<T> foreignToPrimaryVisitor;
        private Function<@Safe String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public ForeignToPrimaryStageVisitorBuilder<T> visitPrimaryToForeign(@Nonnull Supplier<T> primaryToForeignVisitor) {
            Preconditions.checkNotNull(primaryToForeignVisitor, "primaryToForeignVisitor cannot be null");
            this.primaryToForeignVisitor = primaryToForeignVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> visitForeignToPrimary(@Nonnull Supplier<T> foreignToPrimaryVisitor) {
            Preconditions.checkNotNull(foreignToPrimaryVisitor, "foreignToPrimaryVisitor cannot be null");
            this.foreignToPrimaryVisitor = foreignToPrimaryVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownType -> unknownVisitor.apply((String)unknownType);
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'ForeignKeyRelationDirection' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Supplier<T> primaryToForeignVisitor = this.primaryToForeignVisitor;
            final Supplier<T> foreignToPrimaryVisitor = this.foreignToPrimaryVisitor;
            final Function<@Safe String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitPrimaryToForeign() {
                    return primaryToForeignVisitor.get();
                }

                @Override
                public T visitForeignToPrimary() {
                    return foreignToPrimaryVisitor.get();
                }

                @Override
                public T visitUnknown(String unknownType) {
                    return unknownVisitor.apply(unknownType);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitPrimaryToForeign();

        public T visitForeignToPrimary();

        public T visitUnknown(String var1);

        public static <T> PrimaryToForeignStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }

    public static enum Value {
        PRIMARY_TO_FOREIGN,
        FOREIGN_TO_PRIMARY,
        UNKNOWN;

    }
}

