/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogInfo;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=Builder.class)
public final class GetCatalogsPage {
    private final List<CatalogInfo> catalogs;
    private final Optional<String> nextPageToken;
    private int memoizedHashCode;

    private GetCatalogsPage(List<CatalogInfo> catalogs, Optional<String> nextPageToken) {
        GetCatalogsPage.validateFields(catalogs, nextPageToken);
        this.catalogs = Collections.unmodifiableList(catalogs);
        this.nextPageToken = nextPageToken;
    }

    @JsonProperty(value="catalogs")
    public List<CatalogInfo> getCatalogs() {
        return this.catalogs;
    }

    @JsonProperty(value="nextPageToken")
    @Unsafe
    public Optional<String> getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof GetCatalogsPage && this.equalTo((GetCatalogsPage)other);
    }

    private boolean equalTo(GetCatalogsPage other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.catalogs.equals(other.catalogs) && this.nextPageToken.equals(other.nextPageToken);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.catalogs.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.nextPageToken.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "GetCatalogsPage{catalogs: " + String.valueOf(this.catalogs) + ", nextPageToken: " + String.valueOf(this.nextPageToken) + "}";
    }

    public static GetCatalogsPage of(List<CatalogInfo> catalogs, @Unsafe String nextPageToken) {
        return GetCatalogsPage.builder().catalogs(catalogs).nextPageToken(Optional.of(nextPageToken)).build();
    }

    private static void validateFields(List<CatalogInfo> catalogs, Optional<String> nextPageToken) {
        List<String> missingFields = null;
        missingFields = GetCatalogsPage.addFieldIfMissing(missingFields, catalogs, "catalogs");
        if ((missingFields = GetCatalogsPage.addFieldIfMissing(missingFields, nextPageToken, "nextPageToken")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private List<CatalogInfo> catalogs = ConjureCollections.newList();
        private Optional<@Unsafe String> nextPageToken = Optional.empty();

        private Builder() {
        }

        public Builder from(GetCatalogsPage other) {
            this.checkNotBuilt();
            this.catalogs(other.getCatalogs());
            this.nextPageToken(other.getNextPageToken());
            return this;
        }

        @JsonSetter(value="catalogs", nulls=Nulls.SKIP)
        public Builder catalogs(@Nonnull Iterable<CatalogInfo> catalogs) {
            this.checkNotBuilt();
            this.catalogs = ConjureCollections.newList(Preconditions.checkNotNull(catalogs, "catalogs cannot be null"));
            return this;
        }

        public Builder addAllCatalogs(@Nonnull Iterable<CatalogInfo> catalogs) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.catalogs, Preconditions.checkNotNull(catalogs, "catalogs cannot be null"));
            return this;
        }

        public Builder catalogs(CatalogInfo catalogs) {
            this.checkNotBuilt();
            this.catalogs.add(catalogs);
            return this;
        }

        @JsonSetter(value="nextPageToken", nulls=Nulls.SKIP)
        public Builder nextPageToken(@Nonnull Optional<@Unsafe String> nextPageToken) {
            this.checkNotBuilt();
            this.nextPageToken = Preconditions.checkNotNull(nextPageToken, "nextPageToken cannot be null");
            return this;
        }

        public Builder nextPageToken(@Nonnull @Unsafe String nextPageToken) {
            this.checkNotBuilt();
            this.nextPageToken = Optional.of(Preconditions.checkNotNull(nextPageToken, "nextPageToken cannot be null"));
            return this;
        }

        @CheckReturnValue
        public GetCatalogsPage build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new GetCatalogsPage(this.catalogs, this.nextPageToken);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

