/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogMode;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=Builder.class)
public final class GetCatalogsRequest {
    private final Optional<String> pageToken;
    private final Optional<CatalogMode> mode;
    private int memoizedHashCode;

    private GetCatalogsRequest(Optional<String> pageToken, Optional<CatalogMode> mode) {
        GetCatalogsRequest.validateFields(pageToken, mode);
        this.pageToken = pageToken;
        this.mode = mode;
    }

    @JsonProperty(value="pageToken")
    @Unsafe
    public Optional<String> getPageToken() {
        return this.pageToken;
    }

    @JsonProperty(value="mode")
    public Optional<CatalogMode> getMode() {
        return this.mode;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof GetCatalogsRequest && this.equalTo((GetCatalogsRequest)other);
    }

    private boolean equalTo(GetCatalogsRequest other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.pageToken.equals(other.pageToken) && this.mode.equals(other.mode);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.pageToken.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.mode.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "GetCatalogsRequest{pageToken: " + String.valueOf(this.pageToken) + ", mode: " + String.valueOf(this.mode) + "}";
    }

    public static GetCatalogsRequest of(@Unsafe String pageToken, CatalogMode mode) {
        return GetCatalogsRequest.builder().pageToken(Optional.of(pageToken)).mode(Optional.of(mode)).build();
    }

    private static void validateFields(Optional<String> pageToken, Optional<CatalogMode> mode) {
        List<String> missingFields = null;
        missingFields = GetCatalogsRequest.addFieldIfMissing(missingFields, pageToken, "pageToken");
        if ((missingFields = GetCatalogsRequest.addFieldIfMissing(missingFields, mode, "mode")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private Optional<@Unsafe String> pageToken = Optional.empty();
        private Optional<CatalogMode> mode = Optional.empty();

        private Builder() {
        }

        public Builder from(GetCatalogsRequest other) {
            this.checkNotBuilt();
            this.pageToken(other.getPageToken());
            this.mode(other.getMode());
            return this;
        }

        @JsonSetter(value="pageToken", nulls=Nulls.SKIP)
        public Builder pageToken(@Nonnull Optional<@Unsafe String> pageToken) {
            this.checkNotBuilt();
            this.pageToken = Preconditions.checkNotNull(pageToken, "pageToken cannot be null");
            return this;
        }

        public Builder pageToken(@Nonnull @Unsafe String pageToken) {
            this.checkNotBuilt();
            this.pageToken = Optional.of(Preconditions.checkNotNull(pageToken, "pageToken cannot be null"));
            return this;
        }

        @JsonSetter(value="mode", nulls=Nulls.SKIP)
        public Builder mode(@Nonnull Optional<CatalogMode> mode) {
            this.checkNotBuilt();
            this.mode = Preconditions.checkNotNull(mode, "mode cannot be null");
            return this;
        }

        public Builder mode(@Nonnull CatalogMode mode) {
            this.checkNotBuilt();
            this.mode = Optional.of(Preconditions.checkNotNull(mode, "mode cannot be null"));
            return this;
        }

        @CheckReturnValue
        public GetCatalogsRequest build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new GetCatalogsRequest(this.pageToken, this.mode);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

