/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogMode;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class GetColumnsRequest {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final List<Branch> fallbackBranchIds;
    private final Optional<CatalogMode> mode;
    private int memoizedHashCode;

    private GetColumnsRequest(String catalogName, String schemaName, String tableName, List<Branch> fallbackBranchIds, Optional<CatalogMode> mode) {
        GetColumnsRequest.validateFields(catalogName, schemaName, tableName, fallbackBranchIds, mode);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.fallbackBranchIds = Collections.unmodifiableList(fallbackBranchIds);
        this.mode = mode;
    }

    @JsonProperty(value="catalogName")
    @Unsafe
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="schemaName")
    @Unsafe
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty(value="tableName")
    @Unsafe
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty(value="fallbackBranchIds")
    public List<Branch> getFallbackBranchIds() {
        return this.fallbackBranchIds;
    }

    @JsonProperty(value="mode")
    public Optional<CatalogMode> getMode() {
        return this.mode;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof GetColumnsRequest && this.equalTo((GetColumnsRequest)other);
    }

    private boolean equalTo(GetColumnsRequest other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.catalogName.equals(other.catalogName) && this.schemaName.equals(other.schemaName) && this.tableName.equals(other.tableName) && this.fallbackBranchIds.equals(other.fallbackBranchIds) && this.mode.equals(other.mode);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.catalogName.hashCode();
            hash = 31 * hash + this.schemaName.hashCode();
            hash = 31 * hash + this.tableName.hashCode();
            hash = 31 * hash + this.fallbackBranchIds.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.mode.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "GetColumnsRequest{catalogName: " + this.catalogName + ", schemaName: " + this.schemaName + ", tableName: " + this.tableName + ", fallbackBranchIds: " + String.valueOf(this.fallbackBranchIds) + ", mode: " + String.valueOf(this.mode) + "}";
    }

    private static void validateFields(String catalogName, String schemaName, String tableName, List<Branch> fallbackBranchIds, Optional<CatalogMode> mode) {
        List<String> missingFields = null;
        missingFields = GetColumnsRequest.addFieldIfMissing(missingFields, catalogName, "catalogName");
        missingFields = GetColumnsRequest.addFieldIfMissing(missingFields, schemaName, "schemaName");
        missingFields = GetColumnsRequest.addFieldIfMissing(missingFields, tableName, "tableName");
        missingFields = GetColumnsRequest.addFieldIfMissing(missingFields, fallbackBranchIds, "fallbackBranchIds");
        if ((missingFields = GetColumnsRequest.addFieldIfMissing(missingFields, mode, "mode")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(5);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static CatalogNameStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        @Unsafe
        private String catalogName;
        @Unsafe
        private String schemaName;
        @Unsafe
        private String tableName;
        private List<Branch> fallbackBranchIds = ConjureCollections.newList();
        private Optional<CatalogMode> mode = Optional.empty();

        private DefaultBuilder() {
        }

        @Override
        public Builder from(GetColumnsRequest other) {
            this.checkNotBuilt();
            this.catalogName(other.getCatalogName());
            this.schemaName(other.getSchemaName());
            this.tableName(other.getTableName());
            this.fallbackBranchIds(other.getFallbackBranchIds());
            this.mode((Optional)other.getMode());
            return this;
        }

        @Override
        @JsonSetter(value="catalogName")
        public Builder catalogName(@Nonnull @Unsafe String catalogName) {
            this.checkNotBuilt();
            this.catalogName = Preconditions.checkNotNull(catalogName, "catalogName cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="schemaName")
        public Builder schemaName(@Nonnull @Unsafe String schemaName) {
            this.checkNotBuilt();
            this.schemaName = Preconditions.checkNotNull(schemaName, "schemaName cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="tableName")
        public Builder tableName(@Nonnull @Unsafe String tableName) {
            this.checkNotBuilt();
            this.tableName = Preconditions.checkNotNull(tableName, "tableName cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="fallbackBranchIds", nulls=Nulls.SKIP)
        public Builder fallbackBranchIds(@Nonnull Iterable<Branch> fallbackBranchIds) {
            this.checkNotBuilt();
            this.fallbackBranchIds = ConjureCollections.newList(Preconditions.checkNotNull(fallbackBranchIds, "fallbackBranchIds cannot be null"));
            return this;
        }

        @Override
        public Builder addAllFallbackBranchIds(@Nonnull Iterable<Branch> fallbackBranchIds) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.fallbackBranchIds, Preconditions.checkNotNull(fallbackBranchIds, "fallbackBranchIds cannot be null"));
            return this;
        }

        @Override
        public Builder fallbackBranchIds(Branch fallbackBranchIds) {
            this.checkNotBuilt();
            this.fallbackBranchIds.add(fallbackBranchIds);
            return this;
        }

        @Override
        @JsonSetter(value="mode", nulls=Nulls.SKIP)
        public Builder mode(@Nonnull Optional<CatalogMode> mode) {
            this.checkNotBuilt();
            this.mode = Preconditions.checkNotNull(mode, "mode cannot be null");
            return this;
        }

        @Override
        public Builder mode(@Nonnull CatalogMode mode) {
            this.checkNotBuilt();
            this.mode = Optional.of(Preconditions.checkNotNull(mode, "mode cannot be null"));
            return this;
        }

        @Override
        @CheckReturnValue
        public GetColumnsRequest build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new GetColumnsRequest(this.catalogName, this.schemaName, this.tableName, this.fallbackBranchIds, this.mode);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends CatalogNameStageBuilder,
    SchemaNameStageBuilder,
    TableNameStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder catalogName(@Nonnull @Unsafe String var1);

        @Override
        public Builder from(GetColumnsRequest var1);

        @Override
        public Builder schemaName(@Nonnull @Unsafe String var1);

        @Override
        public Builder tableName(@Nonnull @Unsafe String var1);

        @Override
        @CheckReturnValue
        public GetColumnsRequest build();

        @Override
        public Builder fallbackBranchIds(@Nonnull Iterable<Branch> var1);

        @Override
        public Builder addAllFallbackBranchIds(@Nonnull Iterable<Branch> var1);

        @Override
        public Builder fallbackBranchIds(Branch var1);

        @Override
        public Builder mode(@Nonnull Optional<CatalogMode> var1);

        @Override
        public Builder mode(@Nonnull CatalogMode var1);
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public GetColumnsRequest build();

        public Completed_StageBuilder fallbackBranchIds(@Nonnull Iterable<Branch> var1);

        public Completed_StageBuilder addAllFallbackBranchIds(@Nonnull Iterable<Branch> var1);

        public Completed_StageBuilder fallbackBranchIds(Branch var1);

        public Completed_StageBuilder mode(@Nonnull Optional<CatalogMode> var1);

        public Completed_StageBuilder mode(@Nonnull CatalogMode var1);
    }

    public static interface TableNameStageBuilder {
        public Completed_StageBuilder tableName(@Nonnull @Unsafe String var1);
    }

    public static interface SchemaNameStageBuilder {
        public TableNameStageBuilder schemaName(@Nonnull @Unsafe String var1);
    }

    public static interface CatalogNameStageBuilder {
        public SchemaNameStageBuilder catalogName(@Nonnull @Unsafe String var1);

        public Builder from(GetColumnsRequest var1);
    }
}

