/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class GetColumnsResponse {
    private final List<FoundryFieldSchema> columns;
    private int memoizedHashCode;

    private GetColumnsResponse(List<FoundryFieldSchema> columns) {
        GetColumnsResponse.validateFields(columns);
        this.columns = Collections.unmodifiableList(columns);
    }

    @JsonProperty(value="columns")
    public List<FoundryFieldSchema> getColumns() {
        return this.columns;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof GetColumnsResponse && this.equalTo((GetColumnsResponse)other);
    }

    private boolean equalTo(GetColumnsResponse other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.columns.equals(other.columns);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            this.memoizedHashCode = result = this.columns.hashCode();
        }
        return result;
    }

    public String toString() {
        return "GetColumnsResponse{columns: " + String.valueOf(this.columns) + "}";
    }

    public static GetColumnsResponse of(List<FoundryFieldSchema> columns) {
        return GetColumnsResponse.builder().columns(columns).build();
    }

    private static void validateFields(List<FoundryFieldSchema> columns) {
        List<String> missingFields = null;
        if ((missingFields = GetColumnsResponse.addFieldIfMissing(missingFields, columns, "columns")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private List<FoundryFieldSchema> columns = ConjureCollections.newList();

        private Builder() {
        }

        public Builder from(GetColumnsResponse other) {
            this.checkNotBuilt();
            this.columns(other.getColumns());
            return this;
        }

        @JsonSetter(value="columns", nulls=Nulls.SKIP)
        public Builder columns(@Nonnull Iterable<? extends FoundryFieldSchema> columns) {
            this.checkNotBuilt();
            this.columns = ConjureCollections.newList(Preconditions.checkNotNull(columns, "columns cannot be null"));
            return this;
        }

        public Builder addAllColumns(@Nonnull Iterable<? extends FoundryFieldSchema> columns) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.columns, Preconditions.checkNotNull(columns, "columns cannot be null"));
            return this;
        }

        public Builder columns(FoundryFieldSchema columns) {
            this.checkNotBuilt();
            this.columns.add(columns);
            return this;
        }

        @CheckReturnValue
        public GetColumnsResponse build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new GetColumnsResponse(this.columns);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

