/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ClientServices;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class GetInfoResponse {
    private final ClientServices services;

    private GetInfoResponse(ClientServices services) {
        GetInfoResponse.validateFields(services);
        this.services = services;
    }

    @JsonProperty(value="services")
    public ClientServices getServices() {
        return this.services;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof GetInfoResponse && this.equalTo((GetInfoResponse)other);
    }

    private boolean equalTo(GetInfoResponse other) {
        return this.services.equals(other.services);
    }

    public int hashCode() {
        return this.services.hashCode();
    }

    @Unsafe
    public String toString() {
        return "GetInfoResponse{services: " + String.valueOf(this.services) + "}";
    }

    public static GetInfoResponse of(ClientServices services) {
        return GetInfoResponse.builder().services(services).build();
    }

    private static void validateFields(ClientServices services) {
        List<String> missingFields = null;
        if ((missingFields = GetInfoResponse.addFieldIfMissing(missingFields, services, "services")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static ServicesStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private ClientServices services;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(GetInfoResponse other) {
            this.checkNotBuilt();
            this.services(other.getServices());
            return this;
        }

        @Override
        @JsonSetter(value="services")
        public Builder services(@Nonnull ClientServices services) {
            this.checkNotBuilt();
            this.services = Preconditions.checkNotNull(services, "services cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public GetInfoResponse build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new GetInfoResponse(this.services);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends ServicesStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder services(@Nonnull ClientServices var1);

        @Override
        public Builder from(GetInfoResponse var1);

        @Override
        @CheckReturnValue
        public GetInfoResponse build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public GetInfoResponse build();
    }

    public static interface ServicesStageBuilder {
        public Completed_StageBuilder services(@Nonnull ClientServices var1);

        public Builder from(GetInfoResponse var1);
    }
}

