/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogMode;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class GetPrimaryKeysRequest {
    private final Optional<String> catalogName;
    private final Optional<String> schemaName;
    private final String tableName;
    private final List<Branch> fallbackBranchIds;
    private final Optional<CatalogMode> mode;
    private int memoizedHashCode;

    private GetPrimaryKeysRequest(Optional<String> catalogName, Optional<String> schemaName, String tableName, List<Branch> fallbackBranchIds, Optional<CatalogMode> mode) {
        GetPrimaryKeysRequest.validateFields(catalogName, schemaName, tableName, fallbackBranchIds, mode);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.fallbackBranchIds = Collections.unmodifiableList(fallbackBranchIds);
        this.mode = mode;
    }

    @JsonProperty(value="catalogName")
    @Unsafe
    public Optional<String> getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="schemaName")
    @Unsafe
    public Optional<String> getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty(value="tableName")
    @Unsafe
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty(value="fallbackBranchIds")
    public List<Branch> getFallbackBranchIds() {
        return this.fallbackBranchIds;
    }

    @JsonProperty(value="mode")
    public Optional<CatalogMode> getMode() {
        return this.mode;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof GetPrimaryKeysRequest && this.equalTo((GetPrimaryKeysRequest)other);
    }

    private boolean equalTo(GetPrimaryKeysRequest other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.catalogName.equals(other.catalogName) && this.schemaName.equals(other.schemaName) && this.tableName.equals(other.tableName) && this.fallbackBranchIds.equals(other.fallbackBranchIds) && this.mode.equals(other.mode);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.catalogName.hashCode();
            hash = 31 * hash + this.schemaName.hashCode();
            hash = 31 * hash + this.tableName.hashCode();
            hash = 31 * hash + this.fallbackBranchIds.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.mode.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "GetPrimaryKeysRequest{catalogName: " + String.valueOf(this.catalogName) + ", schemaName: " + String.valueOf(this.schemaName) + ", tableName: " + this.tableName + ", fallbackBranchIds: " + String.valueOf(this.fallbackBranchIds) + ", mode: " + String.valueOf(this.mode) + "}";
    }

    private static void validateFields(Optional<String> catalogName, Optional<String> schemaName, String tableName, List<Branch> fallbackBranchIds, Optional<CatalogMode> mode) {
        List<String> missingFields = null;
        missingFields = GetPrimaryKeysRequest.addFieldIfMissing(missingFields, catalogName, "catalogName");
        missingFields = GetPrimaryKeysRequest.addFieldIfMissing(missingFields, schemaName, "schemaName");
        missingFields = GetPrimaryKeysRequest.addFieldIfMissing(missingFields, tableName, "tableName");
        missingFields = GetPrimaryKeysRequest.addFieldIfMissing(missingFields, fallbackBranchIds, "fallbackBranchIds");
        if ((missingFields = GetPrimaryKeysRequest.addFieldIfMissing(missingFields, mode, "mode")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(5);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static TableNameStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private Optional<@Unsafe String> catalogName = Optional.empty();
        private Optional<@Unsafe String> schemaName = Optional.empty();
        @Unsafe
        private String tableName;
        private List<Branch> fallbackBranchIds = ConjureCollections.newList();
        private Optional<CatalogMode> mode = Optional.empty();

        private DefaultBuilder() {
        }

        @Override
        public Builder from(GetPrimaryKeysRequest other) {
            this.checkNotBuilt();
            this.catalogName((Optional)other.getCatalogName());
            this.schemaName((Optional)other.getSchemaName());
            this.tableName(other.getTableName());
            this.fallbackBranchIds(other.getFallbackBranchIds());
            this.mode((Optional)other.getMode());
            return this;
        }

        @Override
        @JsonSetter(value="catalogName", nulls=Nulls.SKIP)
        public Builder catalogName(@Nonnull Optional<@Unsafe String> catalogName) {
            this.checkNotBuilt();
            this.catalogName = Preconditions.checkNotNull(catalogName, "catalogName cannot be null");
            return this;
        }

        @Override
        public Builder catalogName(@Nonnull @Unsafe String catalogName) {
            this.checkNotBuilt();
            this.catalogName = Optional.of(Preconditions.checkNotNull(catalogName, "catalogName cannot be null"));
            return this;
        }

        @Override
        @JsonSetter(value="schemaName", nulls=Nulls.SKIP)
        public Builder schemaName(@Nonnull Optional<@Unsafe String> schemaName) {
            this.checkNotBuilt();
            this.schemaName = Preconditions.checkNotNull(schemaName, "schemaName cannot be null");
            return this;
        }

        @Override
        public Builder schemaName(@Nonnull @Unsafe String schemaName) {
            this.checkNotBuilt();
            this.schemaName = Optional.of(Preconditions.checkNotNull(schemaName, "schemaName cannot be null"));
            return this;
        }

        @Override
        @JsonSetter(value="tableName")
        public Builder tableName(@Nonnull @Unsafe String tableName) {
            this.checkNotBuilt();
            this.tableName = Preconditions.checkNotNull(tableName, "tableName cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="fallbackBranchIds", nulls=Nulls.SKIP)
        public Builder fallbackBranchIds(@Nonnull Iterable<Branch> fallbackBranchIds) {
            this.checkNotBuilt();
            this.fallbackBranchIds = ConjureCollections.newList(Preconditions.checkNotNull(fallbackBranchIds, "fallbackBranchIds cannot be null"));
            return this;
        }

        @Override
        public Builder addAllFallbackBranchIds(@Nonnull Iterable<Branch> fallbackBranchIds) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.fallbackBranchIds, Preconditions.checkNotNull(fallbackBranchIds, "fallbackBranchIds cannot be null"));
            return this;
        }

        @Override
        public Builder fallbackBranchIds(Branch fallbackBranchIds) {
            this.checkNotBuilt();
            this.fallbackBranchIds.add(fallbackBranchIds);
            return this;
        }

        @Override
        @JsonSetter(value="mode", nulls=Nulls.SKIP)
        public Builder mode(@Nonnull Optional<CatalogMode> mode) {
            this.checkNotBuilt();
            this.mode = Preconditions.checkNotNull(mode, "mode cannot be null");
            return this;
        }

        @Override
        public Builder mode(@Nonnull CatalogMode mode) {
            this.checkNotBuilt();
            this.mode = Optional.of(Preconditions.checkNotNull(mode, "mode cannot be null"));
            return this;
        }

        @Override
        @CheckReturnValue
        public GetPrimaryKeysRequest build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new GetPrimaryKeysRequest(this.catalogName, this.schemaName, this.tableName, this.fallbackBranchIds, this.mode);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends TableNameStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder tableName(@Nonnull @Unsafe String var1);

        @Override
        public Builder from(GetPrimaryKeysRequest var1);

        @Override
        @CheckReturnValue
        public GetPrimaryKeysRequest build();

        @Override
        public Builder catalogName(@Nonnull Optional<@Unsafe String> var1);

        @Override
        public Builder catalogName(@Nonnull @Unsafe String var1);

        @Override
        public Builder schemaName(@Nonnull Optional<@Unsafe String> var1);

        @Override
        public Builder schemaName(@Nonnull @Unsafe String var1);

        @Override
        public Builder fallbackBranchIds(@Nonnull Iterable<Branch> var1);

        @Override
        public Builder addAllFallbackBranchIds(@Nonnull Iterable<Branch> var1);

        @Override
        public Builder fallbackBranchIds(Branch var1);

        @Override
        public Builder mode(@Nonnull Optional<CatalogMode> var1);

        @Override
        public Builder mode(@Nonnull CatalogMode var1);
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public GetPrimaryKeysRequest build();

        public Completed_StageBuilder catalogName(@Nonnull Optional<@Unsafe String> var1);

        public Completed_StageBuilder catalogName(@Nonnull @Unsafe String var1);

        public Completed_StageBuilder schemaName(@Nonnull Optional<@Unsafe String> var1);

        public Completed_StageBuilder schemaName(@Nonnull @Unsafe String var1);

        public Completed_StageBuilder fallbackBranchIds(@Nonnull Iterable<Branch> var1);

        public Completed_StageBuilder addAllFallbackBranchIds(@Nonnull Iterable<Branch> var1);

        public Completed_StageBuilder fallbackBranchIds(Branch var1);

        public Completed_StageBuilder mode(@Nonnull Optional<CatalogMode> var1);

        public Completed_StageBuilder mode(@Nonnull CatalogMode var1);
    }

    public static interface TableNameStageBuilder {
        public Completed_StageBuilder tableName(@Nonnull @Unsafe String var1);

        public Builder from(GetPrimaryKeysRequest var1);
    }
}

