/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SchemaInfo;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=Builder.class)
public final class GetSchemasPage {
    private final List<SchemaInfo> schemas;
    private final Optional<String> nextPageToken;
    private int memoizedHashCode;

    private GetSchemasPage(List<SchemaInfo> schemas, Optional<String> nextPageToken) {
        GetSchemasPage.validateFields(schemas, nextPageToken);
        this.schemas = Collections.unmodifiableList(schemas);
        this.nextPageToken = nextPageToken;
    }

    @JsonProperty(value="schemas")
    public List<SchemaInfo> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="nextPageToken")
    @Unsafe
    public Optional<String> getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof GetSchemasPage && this.equalTo((GetSchemasPage)other);
    }

    private boolean equalTo(GetSchemasPage other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.schemas.equals(other.schemas) && this.nextPageToken.equals(other.nextPageToken);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.schemas.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.nextPageToken.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "GetSchemasPage{schemas: " + String.valueOf(this.schemas) + ", nextPageToken: " + String.valueOf(this.nextPageToken) + "}";
    }

    public static GetSchemasPage of(List<SchemaInfo> schemas, @Unsafe String nextPageToken) {
        return GetSchemasPage.builder().schemas(schemas).nextPageToken(Optional.of(nextPageToken)).build();
    }

    private static void validateFields(List<SchemaInfo> schemas, Optional<String> nextPageToken) {
        List<String> missingFields = null;
        missingFields = GetSchemasPage.addFieldIfMissing(missingFields, schemas, "schemas");
        if ((missingFields = GetSchemasPage.addFieldIfMissing(missingFields, nextPageToken, "nextPageToken")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private List<SchemaInfo> schemas = ConjureCollections.newList();
        private Optional<@Unsafe String> nextPageToken = Optional.empty();

        private Builder() {
        }

        public Builder from(GetSchemasPage other) {
            this.checkNotBuilt();
            this.schemas(other.getSchemas());
            this.nextPageToken(other.getNextPageToken());
            return this;
        }

        @JsonSetter(value="schemas", nulls=Nulls.SKIP)
        public Builder schemas(@Nonnull Iterable<SchemaInfo> schemas) {
            this.checkNotBuilt();
            this.schemas = ConjureCollections.newList(Preconditions.checkNotNull(schemas, "schemas cannot be null"));
            return this;
        }

        public Builder addAllSchemas(@Nonnull Iterable<SchemaInfo> schemas) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.schemas, Preconditions.checkNotNull(schemas, "schemas cannot be null"));
            return this;
        }

        public Builder schemas(SchemaInfo schemas) {
            this.checkNotBuilt();
            this.schemas.add(schemas);
            return this;
        }

        @JsonSetter(value="nextPageToken", nulls=Nulls.SKIP)
        public Builder nextPageToken(@Nonnull Optional<@Unsafe String> nextPageToken) {
            this.checkNotBuilt();
            this.nextPageToken = Preconditions.checkNotNull(nextPageToken, "nextPageToken cannot be null");
            return this;
        }

        public Builder nextPageToken(@Nonnull @Unsafe String nextPageToken) {
            this.checkNotBuilt();
            this.nextPageToken = Optional.of(Preconditions.checkNotNull(nextPageToken, "nextPageToken cannot be null"));
            return this;
        }

        @CheckReturnValue
        public GetSchemasPage build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new GetSchemasPage(this.schemas, this.nextPageToken);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

