/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogMode;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class GetSchemasRequest {
    private final String catalogName;
    private final Optional<String> pageToken;
    private final Optional<CatalogMode> mode;
    private int memoizedHashCode;

    private GetSchemasRequest(String catalogName, Optional<String> pageToken, Optional<CatalogMode> mode) {
        GetSchemasRequest.validateFields(catalogName, pageToken, mode);
        this.catalogName = catalogName;
        this.pageToken = pageToken;
        this.mode = mode;
    }

    @JsonProperty(value="catalogName")
    @Unsafe
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="pageToken")
    @Unsafe
    public Optional<String> getPageToken() {
        return this.pageToken;
    }

    @JsonProperty(value="mode")
    public Optional<CatalogMode> getMode() {
        return this.mode;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof GetSchemasRequest && this.equalTo((GetSchemasRequest)other);
    }

    private boolean equalTo(GetSchemasRequest other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.catalogName.equals(other.catalogName) && this.pageToken.equals(other.pageToken) && this.mode.equals(other.mode);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.catalogName.hashCode();
            hash = 31 * hash + this.pageToken.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.mode.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "GetSchemasRequest{catalogName: " + this.catalogName + ", pageToken: " + String.valueOf(this.pageToken) + ", mode: " + String.valueOf(this.mode) + "}";
    }

    public static GetSchemasRequest of(@Unsafe String catalogName, @Unsafe String pageToken, CatalogMode mode) {
        return GetSchemasRequest.builder().catalogName(catalogName).pageToken(Optional.of(pageToken)).mode(Optional.of(mode)).build();
    }

    private static void validateFields(String catalogName, Optional<String> pageToken, Optional<CatalogMode> mode) {
        List<String> missingFields = null;
        missingFields = GetSchemasRequest.addFieldIfMissing(missingFields, catalogName, "catalogName");
        missingFields = GetSchemasRequest.addFieldIfMissing(missingFields, pageToken, "pageToken");
        if ((missingFields = GetSchemasRequest.addFieldIfMissing(missingFields, mode, "mode")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static CatalogNameStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        @Unsafe
        private String catalogName;
        private Optional<@Unsafe String> pageToken = Optional.empty();
        private Optional<CatalogMode> mode = Optional.empty();

        private DefaultBuilder() {
        }

        @Override
        public Builder from(GetSchemasRequest other) {
            this.checkNotBuilt();
            this.catalogName(other.getCatalogName());
            this.pageToken((Optional)other.getPageToken());
            this.mode((Optional)other.getMode());
            return this;
        }

        @Override
        @JsonSetter(value="catalogName")
        public Builder catalogName(@Nonnull @Unsafe String catalogName) {
            this.checkNotBuilt();
            this.catalogName = Preconditions.checkNotNull(catalogName, "catalogName cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="pageToken", nulls=Nulls.SKIP)
        public Builder pageToken(@Nonnull Optional<@Unsafe String> pageToken) {
            this.checkNotBuilt();
            this.pageToken = Preconditions.checkNotNull(pageToken, "pageToken cannot be null");
            return this;
        }

        @Override
        public Builder pageToken(@Nonnull @Unsafe String pageToken) {
            this.checkNotBuilt();
            this.pageToken = Optional.of(Preconditions.checkNotNull(pageToken, "pageToken cannot be null"));
            return this;
        }

        @Override
        @JsonSetter(value="mode", nulls=Nulls.SKIP)
        public Builder mode(@Nonnull Optional<CatalogMode> mode) {
            this.checkNotBuilt();
            this.mode = Preconditions.checkNotNull(mode, "mode cannot be null");
            return this;
        }

        @Override
        public Builder mode(@Nonnull CatalogMode mode) {
            this.checkNotBuilt();
            this.mode = Optional.of(Preconditions.checkNotNull(mode, "mode cannot be null"));
            return this;
        }

        @Override
        @CheckReturnValue
        public GetSchemasRequest build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new GetSchemasRequest(this.catalogName, this.pageToken, this.mode);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends CatalogNameStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder catalogName(@Nonnull @Unsafe String var1);

        @Override
        public Builder from(GetSchemasRequest var1);

        @Override
        @CheckReturnValue
        public GetSchemasRequest build();

        @Override
        public Builder pageToken(@Nonnull Optional<@Unsafe String> var1);

        @Override
        public Builder pageToken(@Nonnull @Unsafe String var1);

        @Override
        public Builder mode(@Nonnull Optional<CatalogMode> var1);

        @Override
        public Builder mode(@Nonnull CatalogMode var1);
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public GetSchemasRequest build();

        public Completed_StageBuilder pageToken(@Nonnull Optional<@Unsafe String> var1);

        public Completed_StageBuilder pageToken(@Nonnull @Unsafe String var1);

        public Completed_StageBuilder mode(@Nonnull Optional<CatalogMode> var1);

        public Completed_StageBuilder mode(@Nonnull CatalogMode var1);
    }

    public static interface CatalogNameStageBuilder {
        public Completed_StageBuilder catalogName(@Nonnull @Unsafe String var1);

        public Builder from(GetSchemasRequest var1);
    }
}

