/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TableInfo;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=Builder.class)
public final class GetTablesPage {
    private final List<TableInfo> tables;
    private final Optional<String> nextPageToken;
    private int memoizedHashCode;

    private GetTablesPage(List<TableInfo> tables, Optional<String> nextPageToken) {
        GetTablesPage.validateFields(tables, nextPageToken);
        this.tables = Collections.unmodifiableList(tables);
        this.nextPageToken = nextPageToken;
    }

    @JsonProperty(value="tables")
    public List<TableInfo> getTables() {
        return this.tables;
    }

    @JsonProperty(value="nextPageToken")
    @Unsafe
    public Optional<String> getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof GetTablesPage && this.equalTo((GetTablesPage)other);
    }

    private boolean equalTo(GetTablesPage other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.tables.equals(other.tables) && this.nextPageToken.equals(other.nextPageToken);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.tables.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.nextPageToken.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "GetTablesPage{tables: " + String.valueOf(this.tables) + ", nextPageToken: " + String.valueOf(this.nextPageToken) + "}";
    }

    public static GetTablesPage of(List<TableInfo> tables, @Unsafe String nextPageToken) {
        return GetTablesPage.builder().tables(tables).nextPageToken(Optional.of(nextPageToken)).build();
    }

    private static void validateFields(List<TableInfo> tables, Optional<String> nextPageToken) {
        List<String> missingFields = null;
        missingFields = GetTablesPage.addFieldIfMissing(missingFields, tables, "tables");
        if ((missingFields = GetTablesPage.addFieldIfMissing(missingFields, nextPageToken, "nextPageToken")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private List<TableInfo> tables = ConjureCollections.newList();
        private Optional<@Unsafe String> nextPageToken = Optional.empty();

        private Builder() {
        }

        public Builder from(GetTablesPage other) {
            this.checkNotBuilt();
            this.tables(other.getTables());
            this.nextPageToken(other.getNextPageToken());
            return this;
        }

        @JsonSetter(value="tables", nulls=Nulls.SKIP)
        public Builder tables(@Nonnull Iterable<TableInfo> tables) {
            this.checkNotBuilt();
            this.tables = ConjureCollections.newList(Preconditions.checkNotNull(tables, "tables cannot be null"));
            return this;
        }

        public Builder addAllTables(@Nonnull Iterable<TableInfo> tables) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.tables, Preconditions.checkNotNull(tables, "tables cannot be null"));
            return this;
        }

        public Builder tables(TableInfo tables) {
            this.checkNotBuilt();
            this.tables.add(tables);
            return this;
        }

        @JsonSetter(value="nextPageToken", nulls=Nulls.SKIP)
        public Builder nextPageToken(@Nonnull Optional<@Unsafe String> nextPageToken) {
            this.checkNotBuilt();
            this.nextPageToken = Preconditions.checkNotNull(nextPageToken, "nextPageToken cannot be null");
            return this;
        }

        public Builder nextPageToken(@Nonnull @Unsafe String nextPageToken) {
            this.checkNotBuilt();
            this.nextPageToken = Optional.of(Preconditions.checkNotNull(nextPageToken, "nextPageToken cannot be null"));
            return this;
        }

        @CheckReturnValue
        public GetTablesPage build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new GetTablesPage(this.tables, this.nextPageToken);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

