/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CatalogMode;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=Builder.class)
public final class GetTablesRequest {
    private final Optional<String> catalogName;
    private final Optional<String> schemaName;
    private final Optional<String> tableName;
    private final Optional<String> pageToken;
    private final Optional<CatalogMode> mode;
    private int memoizedHashCode;

    private GetTablesRequest(Optional<String> catalogName, Optional<String> schemaName, Optional<String> tableName, Optional<String> pageToken, Optional<CatalogMode> mode) {
        GetTablesRequest.validateFields(catalogName, schemaName, tableName, pageToken, mode);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.pageToken = pageToken;
        this.mode = mode;
    }

    @JsonProperty(value="catalogName")
    @Unsafe
    public Optional<String> getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="schemaName")
    @Unsafe
    public Optional<String> getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty(value="tableName")
    @Unsafe
    public Optional<String> getTableName() {
        return this.tableName;
    }

    @JsonProperty(value="pageToken")
    @Unsafe
    public Optional<String> getPageToken() {
        return this.pageToken;
    }

    @JsonProperty(value="mode")
    public Optional<CatalogMode> getMode() {
        return this.mode;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof GetTablesRequest && this.equalTo((GetTablesRequest)other);
    }

    private boolean equalTo(GetTablesRequest other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.catalogName.equals(other.catalogName) && this.schemaName.equals(other.schemaName) && this.tableName.equals(other.tableName) && this.pageToken.equals(other.pageToken) && this.mode.equals(other.mode);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.catalogName.hashCode();
            hash = 31 * hash + this.schemaName.hashCode();
            hash = 31 * hash + this.tableName.hashCode();
            hash = 31 * hash + this.pageToken.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.mode.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "GetTablesRequest{catalogName: " + String.valueOf(this.catalogName) + ", schemaName: " + String.valueOf(this.schemaName) + ", tableName: " + String.valueOf(this.tableName) + ", pageToken: " + String.valueOf(this.pageToken) + ", mode: " + String.valueOf(this.mode) + "}";
    }

    private static void validateFields(Optional<String> catalogName, Optional<String> schemaName, Optional<String> tableName, Optional<String> pageToken, Optional<CatalogMode> mode) {
        List<String> missingFields = null;
        missingFields = GetTablesRequest.addFieldIfMissing(missingFields, catalogName, "catalogName");
        missingFields = GetTablesRequest.addFieldIfMissing(missingFields, schemaName, "schemaName");
        missingFields = GetTablesRequest.addFieldIfMissing(missingFields, tableName, "tableName");
        missingFields = GetTablesRequest.addFieldIfMissing(missingFields, pageToken, "pageToken");
        if ((missingFields = GetTablesRequest.addFieldIfMissing(missingFields, mode, "mode")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(5);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private Optional<@Unsafe String> catalogName = Optional.empty();
        private Optional<@Unsafe String> schemaName = Optional.empty();
        private Optional<@Unsafe String> tableName = Optional.empty();
        private Optional<@Unsafe String> pageToken = Optional.empty();
        private Optional<CatalogMode> mode = Optional.empty();

        private Builder() {
        }

        public Builder from(GetTablesRequest other) {
            this.checkNotBuilt();
            this.catalogName(other.getCatalogName());
            this.schemaName(other.getSchemaName());
            this.tableName(other.getTableName());
            this.pageToken(other.getPageToken());
            this.mode(other.getMode());
            return this;
        }

        @JsonSetter(value="catalogName", nulls=Nulls.SKIP)
        public Builder catalogName(@Nonnull Optional<@Unsafe String> catalogName) {
            this.checkNotBuilt();
            this.catalogName = Preconditions.checkNotNull(catalogName, "catalogName cannot be null");
            return this;
        }

        public Builder catalogName(@Nonnull @Unsafe String catalogName) {
            this.checkNotBuilt();
            this.catalogName = Optional.of(Preconditions.checkNotNull(catalogName, "catalogName cannot be null"));
            return this;
        }

        @JsonSetter(value="schemaName", nulls=Nulls.SKIP)
        public Builder schemaName(@Nonnull Optional<@Unsafe String> schemaName) {
            this.checkNotBuilt();
            this.schemaName = Preconditions.checkNotNull(schemaName, "schemaName cannot be null");
            return this;
        }

        public Builder schemaName(@Nonnull @Unsafe String schemaName) {
            this.checkNotBuilt();
            this.schemaName = Optional.of(Preconditions.checkNotNull(schemaName, "schemaName cannot be null"));
            return this;
        }

        @JsonSetter(value="tableName", nulls=Nulls.SKIP)
        public Builder tableName(@Nonnull Optional<@Unsafe String> tableName) {
            this.checkNotBuilt();
            this.tableName = Preconditions.checkNotNull(tableName, "tableName cannot be null");
            return this;
        }

        public Builder tableName(@Nonnull @Unsafe String tableName) {
            this.checkNotBuilt();
            this.tableName = Optional.of(Preconditions.checkNotNull(tableName, "tableName cannot be null"));
            return this;
        }

        @JsonSetter(value="pageToken", nulls=Nulls.SKIP)
        public Builder pageToken(@Nonnull Optional<@Unsafe String> pageToken) {
            this.checkNotBuilt();
            this.pageToken = Preconditions.checkNotNull(pageToken, "pageToken cannot be null");
            return this;
        }

        public Builder pageToken(@Nonnull @Unsafe String pageToken) {
            this.checkNotBuilt();
            this.pageToken = Optional.of(Preconditions.checkNotNull(pageToken, "pageToken cannot be null"));
            return this;
        }

        @JsonSetter(value="mode", nulls=Nulls.SKIP)
        public Builder mode(@Nonnull Optional<CatalogMode> mode) {
            this.checkNotBuilt();
            this.mode = Preconditions.checkNotNull(mode, "mode cannot be null");
            return this;
        }

        public Builder mode(@Nonnull CatalogMode mode) {
            this.checkNotBuilt();
            this.mode = Optional.of(Preconditions.checkNotNull(mode, "mode cannot be null"));
            return this;
        }

        @CheckReturnValue
        public GetTablesRequest build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new GetTablesRequest(this.catalogName, this.schemaName, this.tableName, this.pageToken, this.mode);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

