/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnyGetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnySetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSubTypes;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.Bytes;
import shadow.palantir.driver.com.palantir.conjure.java.lib.SafeLong;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
public final class ParameterValue {
    private final Base value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private ParameterValue(Base value) {
        this.value = value;
    }

    @JsonValue
    private Base getValue() {
        return this.value;
    }

    public static ParameterValue binary(@Unsafe Bytes value) {
        return new ParameterValue(new BinaryWrapper(value));
    }

    public static ParameterValue boolean_(@Unsafe boolean value) {
        return new ParameterValue(new BooleanWrapper(value));
    }

    public static ParameterValue short_(@Unsafe int value) {
        return new ParameterValue(new ShortWrapper(value));
    }

    public static ParameterValue integer(@Unsafe int value) {
        return new ParameterValue(new IntegerWrapper(value));
    }

    public static ParameterValue long_(@Unsafe SafeLong value) {
        return new ParameterValue(new LongWrapper(value));
    }

    public static ParameterValue float_(@Unsafe double value) {
        return new ParameterValue(new FloatWrapper(value));
    }

    public static ParameterValue double_(@Unsafe double value) {
        return new ParameterValue(new DoubleWrapper(value));
    }

    public static ParameterValue decimal(BigDecimal value) {
        return new ParameterValue(new DecimalWrapper(value));
    }

    public static ParameterValue date(Date value) {
        return new ParameterValue(new DateWrapper(value));
    }

    public static ParameterValue localDate(LocalDate value) {
        return new ParameterValue(new LocalDateWrapper(value));
    }

    public static ParameterValue timestamp(Timestamp value) {
        return new ParameterValue(new TimestampWrapper(value));
    }

    public static ParameterValue instant(Instant value) {
        return new ParameterValue(new InstantWrapper(value));
    }

    public static ParameterValue string(@Unsafe String value) {
        return new ParameterValue(new StringWrapper(value));
    }

    public static ParameterValue unknown(@Safe String type, Object value) {
        switch (Preconditions.checkNotNull(type, "Type is required")) {
            case "binary": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: binary", new Arg[0]);
            }
            case "boolean": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: boolean", new Arg[0]);
            }
            case "short": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: short", new Arg[0]);
            }
            case "integer": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: integer", new Arg[0]);
            }
            case "long": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: long", new Arg[0]);
            }
            case "float": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: float", new Arg[0]);
            }
            case "double": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: double", new Arg[0]);
            }
            case "decimal": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: decimal", new Arg[0]);
            }
            case "date": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: date", new Arg[0]);
            }
            case "localDate": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: localDate", new Arg[0]);
            }
            case "timestamp": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: timestamp", new Arg[0]);
            }
            case "instant": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: instant", new Arg[0]);
            }
            case "string": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: string", new Arg[0]);
            }
        }
        return new ParameterValue(new UnknownWrapper(type, Collections.singletonMap(type, value)));
    }

    public <T> T accept(Visitor<T> visitor) {
        return this.value.accept(visitor);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ParameterValue && this.equalTo((ParameterValue)other);
    }

    private boolean equalTo(ParameterValue other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Unsafe
    public String toString() {
        return "ParameterValue{value: " + String.valueOf(this.value) + "}";
    }

    private static final class UnknownWrapper
    implements Base {
        private final String type;
        private final Map<String, Object> value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private UnknownWrapper(@JsonProperty(value="type") String type) {
            this(type, new HashMap<String, Object>());
        }

        private UnknownWrapper(@Nonnull String type, @Nonnull Map<String, Object> value) {
            Preconditions.checkNotNull(type, "type cannot be null");
            Preconditions.checkNotNull(value, "value cannot be null");
            this.type = type;
            this.value = value;
        }

        @JsonProperty
        private String getType() {
            return this.type;
        }

        @JsonAnyGetter
        private Map<String, Object> getValue() {
            return this.value;
        }

        @JsonAnySetter
        private void put(String key, Object val) {
            this.value.put(key, val);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitUnknown(this.type);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof UnknownWrapper && this.equalTo((UnknownWrapper)other);
        }

        private boolean equalTo(UnknownWrapper other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + this.type.hashCode();
            hash = 31 * hash + this.value.hashCode();
            return hash;
        }

        public String toString() {
            return "UnknownWrapper{type: " + this.type + ", value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeName(value="string")
    private static final class StringWrapper
    implements Base {
        private final String value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private StringWrapper(@JsonSetter(value="string") @Nonnull String value) {
            Preconditions.checkNotNull(value, "string cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "string";
        }

        @JsonProperty(value="string")
        private String getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitString(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof StringWrapper && this.equalTo((StringWrapper)other);
        }

        private boolean equalTo(StringWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "StringWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="instant")
    private static final class InstantWrapper
    implements Base {
        private final Instant value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private InstantWrapper(@JsonSetter(value="instant") @Nonnull Instant value) {
            Preconditions.checkNotNull(value, "instant cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "instant";
        }

        @JsonProperty(value="instant")
        private Instant getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitInstant(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof InstantWrapper && this.equalTo((InstantWrapper)other);
        }

        private boolean equalTo(InstantWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "InstantWrapper{value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeName(value="timestamp")
    private static final class TimestampWrapper
    implements Base {
        private final Timestamp value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TimestampWrapper(@JsonSetter(value="timestamp") @Nonnull Timestamp value) {
            Preconditions.checkNotNull(value, "timestamp cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "timestamp";
        }

        @JsonProperty(value="timestamp")
        private Timestamp getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitTimestamp(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof TimestampWrapper && this.equalTo((TimestampWrapper)other);
        }

        private boolean equalTo(TimestampWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "TimestampWrapper{value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeName(value="localDate")
    private static final class LocalDateWrapper
    implements Base {
        private final LocalDate value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private LocalDateWrapper(@JsonSetter(value="localDate") @Nonnull LocalDate value) {
            Preconditions.checkNotNull(value, "localDate cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "localDate";
        }

        @JsonProperty(value="localDate")
        private LocalDate getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitLocalDate(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof LocalDateWrapper && this.equalTo((LocalDateWrapper)other);
        }

        private boolean equalTo(LocalDateWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "LocalDateWrapper{value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeName(value="date")
    private static final class DateWrapper
    implements Base {
        private final Date value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private DateWrapper(@JsonSetter(value="date") @Nonnull Date value) {
            Preconditions.checkNotNull(value, "date cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "date";
        }

        @JsonProperty(value="date")
        private Date getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitDate(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof DateWrapper && this.equalTo((DateWrapper)other);
        }

        private boolean equalTo(DateWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "DateWrapper{value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeName(value="decimal")
    private static final class DecimalWrapper
    implements Base {
        private final BigDecimal value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private DecimalWrapper(@JsonSetter(value="decimal") @Nonnull BigDecimal value) {
            Preconditions.checkNotNull(value, "decimal cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "decimal";
        }

        @JsonProperty(value="decimal")
        private BigDecimal getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitDecimal(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof DecimalWrapper && this.equalTo((DecimalWrapper)other);
        }

        private boolean equalTo(DecimalWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "DecimalWrapper{value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeName(value="double")
    private static final class DoubleWrapper
    implements Base {
        private final double value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private DoubleWrapper(@JsonSetter(value="double") @Nonnull double value) {
            Preconditions.checkNotNull(value, "double cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "double";
        }

        @JsonProperty(value="double")
        private double getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitDouble(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof DoubleWrapper && this.equalTo((DoubleWrapper)other);
        }

        private boolean equalTo(DoubleWrapper other) {
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
        }

        public int hashCode() {
            return Double.hashCode(this.value);
        }

        public String toString() {
            return "DoubleWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="float")
    private static final class FloatWrapper
    implements Base {
        private final double value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private FloatWrapper(@JsonSetter(value="float") @Nonnull double value) {
            Preconditions.checkNotNull(value, "float cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "float";
        }

        @JsonProperty(value="float")
        private double getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitFloat(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof FloatWrapper && this.equalTo((FloatWrapper)other);
        }

        private boolean equalTo(FloatWrapper other) {
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
        }

        public int hashCode() {
            return Double.hashCode(this.value);
        }

        public String toString() {
            return "FloatWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="long")
    private static final class LongWrapper
    implements Base {
        private final SafeLong value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private LongWrapper(@JsonSetter(value="long") @Nonnull SafeLong value) {
            Preconditions.checkNotNull(value, "long cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "long";
        }

        @JsonProperty(value="long")
        private SafeLong getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitLong(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof LongWrapper && this.equalTo((LongWrapper)other);
        }

        private boolean equalTo(LongWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "LongWrapper{value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeName(value="integer")
    private static final class IntegerWrapper
    implements Base {
        private final int value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private IntegerWrapper(@JsonSetter(value="integer") @Nonnull int value) {
            Preconditions.checkNotNull(value, "integer cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "integer";
        }

        @JsonProperty(value="integer")
        private int getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitInteger(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof IntegerWrapper && this.equalTo((IntegerWrapper)other);
        }

        private boolean equalTo(IntegerWrapper other) {
            return this.value == other.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return "IntegerWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="short")
    private static final class ShortWrapper
    implements Base {
        private final int value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ShortWrapper(@JsonSetter(value="short") @Nonnull int value) {
            Preconditions.checkNotNull(value, "short cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "short";
        }

        @JsonProperty(value="short")
        private int getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitShort(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof ShortWrapper && this.equalTo((ShortWrapper)other);
        }

        private boolean equalTo(ShortWrapper other) {
            return this.value == other.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return "ShortWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="boolean")
    private static final class BooleanWrapper
    implements Base {
        private final boolean value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private BooleanWrapper(@JsonSetter(value="boolean") @Nonnull boolean value) {
            Preconditions.checkNotNull(value, "boolean cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "boolean";
        }

        @JsonProperty(value="boolean")
        private boolean getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitBoolean(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof BooleanWrapper && this.equalTo((BooleanWrapper)other);
        }

        private boolean equalTo(BooleanWrapper other) {
            return this.value == other.value;
        }

        public int hashCode() {
            return Boolean.hashCode(this.value);
        }

        public String toString() {
            return "BooleanWrapper{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="binary")
    private static final class BinaryWrapper
    implements Base {
        private final Bytes value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private BinaryWrapper(@JsonSetter(value="binary") @Nonnull Bytes value) {
            Preconditions.checkNotNull(value, "binary cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "binary";
        }

        @JsonProperty(value="binary")
        private Bytes getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitBinary(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof BinaryWrapper && this.equalTo((BinaryWrapper)other);
        }

        private boolean equalTo(BinaryWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "BinaryWrapper{value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=UnknownWrapper.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=BinaryWrapper.class), @JsonSubTypes.Type(value=BooleanWrapper.class), @JsonSubTypes.Type(value=ShortWrapper.class), @JsonSubTypes.Type(value=IntegerWrapper.class), @JsonSubTypes.Type(value=LongWrapper.class), @JsonSubTypes.Type(value=FloatWrapper.class), @JsonSubTypes.Type(value=DoubleWrapper.class), @JsonSubTypes.Type(value=DecimalWrapper.class), @JsonSubTypes.Type(value=DateWrapper.class), @JsonSubTypes.Type(value=LocalDateWrapper.class), @JsonSubTypes.Type(value=TimestampWrapper.class), @JsonSubTypes.Type(value=InstantWrapper.class), @JsonSubTypes.Type(value=StringWrapper.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Base {
        public <T> T accept(Visitor<T> var1);
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface TimestampStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> timestamp(@Nonnull Function<Timestamp, T> var1);
    }

    public static interface StringStageVisitorBuilder<T> {
        public TimestampStageVisitorBuilder<T> string(@Nonnull Function<@Unsafe String, T> var1);
    }

    public static interface ShortStageVisitorBuilder<T> {
        public StringStageVisitorBuilder<T> short_(@Nonnull IntFunction<T> var1);
    }

    public static interface LongStageVisitorBuilder<T> {
        public ShortStageVisitorBuilder<T> long_(@Nonnull Function<@Unsafe SafeLong, T> var1);
    }

    public static interface LocalDateStageVisitorBuilder<T> {
        public LongStageVisitorBuilder<T> localDate(@Nonnull Function<LocalDate, T> var1);
    }

    public static interface IntegerStageVisitorBuilder<T> {
        public LocalDateStageVisitorBuilder<T> integer(@Nonnull IntFunction<T> var1);
    }

    public static interface InstantStageVisitorBuilder<T> {
        public IntegerStageVisitorBuilder<T> instant(@Nonnull Function<Instant, T> var1);
    }

    public static interface FloatStageVisitorBuilder<T> {
        public InstantStageVisitorBuilder<T> float_(@Nonnull DoubleFunction<T> var1);
    }

    public static interface DoubleStageVisitorBuilder<T> {
        public FloatStageVisitorBuilder<T> double_(@Nonnull DoubleFunction<T> var1);
    }

    public static interface DecimalStageVisitorBuilder<T> {
        public DoubleStageVisitorBuilder<T> decimal(@Nonnull Function<BigDecimal, T> var1);
    }

    public static interface DateStageVisitorBuilder<T> {
        public DecimalStageVisitorBuilder<T> date(@Nonnull Function<Date, T> var1);
    }

    public static interface BooleanStageVisitorBuilder<T> {
        public DateStageVisitorBuilder<T> boolean_(@Nonnull Function<@Unsafe Boolean, T> var1);
    }

    public static interface BinaryStageVisitorBuilder<T> {
        public BooleanStageVisitorBuilder<T> binary(@Nonnull Function<@Unsafe Bytes, T> var1);
    }

    private static final class VisitorBuilder<T>
    implements BinaryStageVisitorBuilder<T>,
    BooleanStageVisitorBuilder<T>,
    DateStageVisitorBuilder<T>,
    DecimalStageVisitorBuilder<T>,
    DoubleStageVisitorBuilder<T>,
    FloatStageVisitorBuilder<T>,
    InstantStageVisitorBuilder<T>,
    IntegerStageVisitorBuilder<T>,
    LocalDateStageVisitorBuilder<T>,
    LongStageVisitorBuilder<T>,
    ShortStageVisitorBuilder<T>,
    StringStageVisitorBuilder<T>,
    TimestampStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Function<@Unsafe Bytes, T> binaryVisitor;
        private Function<@Unsafe Boolean, T> booleanVisitor;
        private Function<Date, T> dateVisitor;
        private Function<BigDecimal, T> decimalVisitor;
        private DoubleFunction<T> doubleVisitor;
        private DoubleFunction<T> floatVisitor;
        private Function<Instant, T> instantVisitor;
        private IntFunction<T> integerVisitor;
        private Function<LocalDate, T> localDateVisitor;
        private Function<@Unsafe SafeLong, T> longVisitor;
        private IntFunction<T> shortVisitor;
        private Function<@Unsafe String, T> stringVisitor;
        private Function<Timestamp, T> timestampVisitor;
        private Function<String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public BooleanStageVisitorBuilder<T> binary(@Nonnull Function<@Unsafe Bytes, T> binaryVisitor) {
            Preconditions.checkNotNull(binaryVisitor, "binaryVisitor cannot be null");
            this.binaryVisitor = binaryVisitor;
            return this;
        }

        @Override
        public DateStageVisitorBuilder<T> boolean_(@Nonnull Function<@Unsafe Boolean, T> booleanVisitor) {
            Preconditions.checkNotNull(booleanVisitor, "booleanVisitor cannot be null");
            this.booleanVisitor = booleanVisitor;
            return this;
        }

        @Override
        public DecimalStageVisitorBuilder<T> date(@Nonnull Function<Date, T> dateVisitor) {
            Preconditions.checkNotNull(dateVisitor, "dateVisitor cannot be null");
            this.dateVisitor = dateVisitor;
            return this;
        }

        @Override
        public DoubleStageVisitorBuilder<T> decimal(@Nonnull Function<BigDecimal, T> decimalVisitor) {
            Preconditions.checkNotNull(decimalVisitor, "decimalVisitor cannot be null");
            this.decimalVisitor = decimalVisitor;
            return this;
        }

        @Override
        public FloatStageVisitorBuilder<T> double_(@Nonnull DoubleFunction<T> doubleVisitor) {
            Preconditions.checkNotNull(doubleVisitor, "doubleVisitor cannot be null");
            this.doubleVisitor = doubleVisitor;
            return this;
        }

        @Override
        public InstantStageVisitorBuilder<T> float_(@Nonnull DoubleFunction<T> floatVisitor) {
            Preconditions.checkNotNull(floatVisitor, "floatVisitor cannot be null");
            this.floatVisitor = floatVisitor;
            return this;
        }

        @Override
        public IntegerStageVisitorBuilder<T> instant(@Nonnull Function<Instant, T> instantVisitor) {
            Preconditions.checkNotNull(instantVisitor, "instantVisitor cannot be null");
            this.instantVisitor = instantVisitor;
            return this;
        }

        @Override
        public LocalDateStageVisitorBuilder<T> integer(@Nonnull IntFunction<T> integerVisitor) {
            Preconditions.checkNotNull(integerVisitor, "integerVisitor cannot be null");
            this.integerVisitor = integerVisitor;
            return this;
        }

        @Override
        public LongStageVisitorBuilder<T> localDate(@Nonnull Function<LocalDate, T> localDateVisitor) {
            Preconditions.checkNotNull(localDateVisitor, "localDateVisitor cannot be null");
            this.localDateVisitor = localDateVisitor;
            return this;
        }

        @Override
        public ShortStageVisitorBuilder<T> long_(@Nonnull Function<@Unsafe SafeLong, T> longVisitor) {
            Preconditions.checkNotNull(longVisitor, "longVisitor cannot be null");
            this.longVisitor = longVisitor;
            return this;
        }

        @Override
        public StringStageVisitorBuilder<T> short_(@Nonnull IntFunction<T> shortVisitor) {
            Preconditions.checkNotNull(shortVisitor, "shortVisitor cannot be null");
            this.shortVisitor = shortVisitor;
            return this;
        }

        @Override
        public TimestampStageVisitorBuilder<T> string(@Nonnull Function<@Unsafe String, T> stringVisitor) {
            Preconditions.checkNotNull(stringVisitor, "stringVisitor cannot be null");
            this.stringVisitor = stringVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> timestamp(@Nonnull Function<Timestamp, T> timestampVisitor) {
            Preconditions.checkNotNull(timestampVisitor, "timestampVisitor cannot be null");
            this.timestampVisitor = timestampVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'ParameterValue' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Function<@Unsafe Bytes, T> binaryVisitor = this.binaryVisitor;
            final Function<@Unsafe Boolean, T> booleanVisitor = this.booleanVisitor;
            final Function<Date, T> dateVisitor = this.dateVisitor;
            final Function<BigDecimal, T> decimalVisitor = this.decimalVisitor;
            final DoubleFunction<T> doubleVisitor = this.doubleVisitor;
            final DoubleFunction<T> floatVisitor = this.floatVisitor;
            final Function<Instant, T> instantVisitor = this.instantVisitor;
            final IntFunction<T> integerVisitor = this.integerVisitor;
            final Function<LocalDate, T> localDateVisitor = this.localDateVisitor;
            final Function<@Unsafe SafeLong, T> longVisitor = this.longVisitor;
            final IntFunction<T> shortVisitor = this.shortVisitor;
            final Function<@Unsafe String, T> stringVisitor = this.stringVisitor;
            final Function<Timestamp, T> timestampVisitor = this.timestampVisitor;
            final Function<String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitBinary(@Unsafe Bytes value) {
                    return binaryVisitor.apply(value);
                }

                @Override
                public T visitBoolean(@Unsafe boolean value) {
                    return booleanVisitor.apply(value);
                }

                @Override
                public T visitDate(Date value) {
                    return dateVisitor.apply(value);
                }

                @Override
                public T visitDecimal(BigDecimal value) {
                    return decimalVisitor.apply(value);
                }

                @Override
                public T visitDouble(@Unsafe double value) {
                    return doubleVisitor.apply(value);
                }

                @Override
                public T visitFloat(@Unsafe double value) {
                    return floatVisitor.apply(value);
                }

                @Override
                public T visitInstant(Instant value) {
                    return instantVisitor.apply(value);
                }

                @Override
                public T visitInteger(@Unsafe int value) {
                    return integerVisitor.apply(value);
                }

                @Override
                public T visitLocalDate(LocalDate value) {
                    return localDateVisitor.apply(value);
                }

                @Override
                public T visitLong(@Unsafe SafeLong value) {
                    return longVisitor.apply(value);
                }

                @Override
                public T visitShort(@Unsafe int value) {
                    return shortVisitor.apply(value);
                }

                @Override
                public T visitString(@Unsafe String value) {
                    return stringVisitor.apply(value);
                }

                @Override
                public T visitTimestamp(Timestamp value) {
                    return timestampVisitor.apply(value);
                }

                @Override
                public T visitUnknown(String value) {
                    return unknownVisitor.apply(value);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitBinary(@Unsafe Bytes var1);

        public T visitBoolean(@Unsafe boolean var1);

        public T visitShort(@Unsafe int var1);

        public T visitInteger(@Unsafe int var1);

        public T visitLong(@Unsafe SafeLong var1);

        public T visitFloat(@Unsafe double var1);

        public T visitDouble(@Unsafe double var1);

        public T visitDecimal(BigDecimal var1);

        public T visitDate(Date var1);

        public T visitLocalDate(LocalDate var1);

        public T visitTimestamp(Timestamp var1);

        public T visitInstant(Instant var1);

        public T visitString(@Unsafe String var1);

        public T visitUnknown(@Safe String var1);

        public static <T> BinaryStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }
}

