/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnyGetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnySetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSubTypes;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ParameterMapping;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ParameterValue;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
public final class Parameters {
    private final Base value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private Parameters(Base value) {
        this.value = value;
    }

    @JsonValue
    private Base getValue() {
        return this.value;
    }

    public static Parameters unnamedParameterValues(List<ParameterValue> value) {
        return new Parameters(new UnnamedParameterValuesWrapper(value));
    }

    public static Parameters namedParameterMapping(ParameterMapping value) {
        return new Parameters(new NamedParameterMappingWrapper(value));
    }

    public static Parameters unknown(@Safe String type, Object value) {
        switch (Preconditions.checkNotNull(type, "Type is required")) {
            case "unnamedParameterValues": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: unnamedParameterValues", new Arg[0]);
            }
            case "namedParameterMapping": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: namedParameterMapping", new Arg[0]);
            }
        }
        return new Parameters(new UnknownWrapper(type, Collections.singletonMap(type, value)));
    }

    public <T> T accept(Visitor<T> visitor) {
        return this.value.accept(visitor);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Parameters && this.equalTo((Parameters)other);
    }

    private boolean equalTo(Parameters other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Unsafe
    public String toString() {
        return "Parameters{value: " + String.valueOf(this.value) + "}";
    }

    private static final class UnknownWrapper
    implements Base {
        private final String type;
        private final Map<String, Object> value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private UnknownWrapper(@JsonProperty(value="type") String type) {
            this(type, new HashMap<String, Object>());
        }

        private UnknownWrapper(@Nonnull String type, @Nonnull Map<String, Object> value) {
            Preconditions.checkNotNull(type, "type cannot be null");
            Preconditions.checkNotNull(value, "value cannot be null");
            this.type = type;
            this.value = value;
        }

        @JsonProperty
        private String getType() {
            return this.type;
        }

        @JsonAnyGetter
        private Map<String, Object> getValue() {
            return this.value;
        }

        @JsonAnySetter
        private void put(String key, Object val) {
            this.value.put(key, val);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitUnknown(this.type);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof UnknownWrapper && this.equalTo((UnknownWrapper)other);
        }

        private boolean equalTo(UnknownWrapper other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + this.type.hashCode();
            hash = 31 * hash + this.value.hashCode();
            return hash;
        }

        public String toString() {
            return "UnknownWrapper{type: " + this.type + ", value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeName(value="namedParameterMapping")
    private static final class NamedParameterMappingWrapper
    implements Base {
        private final ParameterMapping value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private NamedParameterMappingWrapper(@JsonSetter(value="namedParameterMapping", nulls=Nulls.AS_EMPTY) @Nonnull ParameterMapping value) {
            Preconditions.checkNotNull(value, "namedParameterMapping cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "namedParameterMapping";
        }

        @JsonProperty(value="namedParameterMapping")
        private ParameterMapping getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitNamedParameterMapping(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof NamedParameterMappingWrapper && this.equalTo((NamedParameterMappingWrapper)other);
        }

        private boolean equalTo(NamedParameterMappingWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "NamedParameterMappingWrapper{value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeName(value="unnamedParameterValues")
    private static final class UnnamedParameterValuesWrapper
    implements Base {
        private final List<ParameterValue> value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private UnnamedParameterValuesWrapper(@JsonSetter(value="unnamedParameterValues", nulls=Nulls.AS_EMPTY) @Nonnull List<ParameterValue> value) {
            Preconditions.checkNotNull(value, "unnamedParameterValues cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "unnamedParameterValues";
        }

        @JsonProperty(value="unnamedParameterValues")
        private List<ParameterValue> getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitUnnamedParameterValues(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof UnnamedParameterValuesWrapper && this.equalTo((UnnamedParameterValuesWrapper)other);
        }

        private boolean equalTo(UnnamedParameterValuesWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "UnnamedParameterValuesWrapper{value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=UnknownWrapper.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=UnnamedParameterValuesWrapper.class), @JsonSubTypes.Type(value=NamedParameterMappingWrapper.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Base {
        public <T> T accept(Visitor<T> var1);
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface UnnamedParameterValuesStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> unnamedParameterValues(@Nonnull Function<List<ParameterValue>, T> var1);
    }

    public static interface NamedParameterMappingStageVisitorBuilder<T> {
        public UnnamedParameterValuesStageVisitorBuilder<T> namedParameterMapping(@Nonnull Function<ParameterMapping, T> var1);
    }

    private static final class VisitorBuilder<T>
    implements NamedParameterMappingStageVisitorBuilder<T>,
    UnnamedParameterValuesStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Function<ParameterMapping, T> namedParameterMappingVisitor;
        private Function<List<ParameterValue>, T> unnamedParameterValuesVisitor;
        private Function<String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public UnnamedParameterValuesStageVisitorBuilder<T> namedParameterMapping(@Nonnull Function<ParameterMapping, T> namedParameterMappingVisitor) {
            Preconditions.checkNotNull(namedParameterMappingVisitor, "namedParameterMappingVisitor cannot be null");
            this.namedParameterMappingVisitor = namedParameterMappingVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> unnamedParameterValues(@Nonnull Function<List<ParameterValue>, T> unnamedParameterValuesVisitor) {
            Preconditions.checkNotNull(unnamedParameterValuesVisitor, "unnamedParameterValuesVisitor cannot be null");
            this.unnamedParameterValuesVisitor = unnamedParameterValuesVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'Parameters' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Function<ParameterMapping, T> namedParameterMappingVisitor = this.namedParameterMappingVisitor;
            final Function<List<ParameterValue>, T> unnamedParameterValuesVisitor = this.unnamedParameterValuesVisitor;
            final Function<String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitNamedParameterMapping(ParameterMapping value) {
                    return namedParameterMappingVisitor.apply(value);
                }

                @Override
                public T visitUnnamedParameterValues(List<ParameterValue> value) {
                    return unnamedParameterValuesVisitor.apply(value);
                }

                @Override
                public T visitUnknown(String value) {
                    return unknownVisitor.apply(value);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitUnnamedParameterValues(List<ParameterValue> var1);

        public T visitNamedParameterMapping(ParameterMapping var1);

        public T visitUnknown(@Safe String var1);

        public static <T> NamedParameterMappingStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }
}

