/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ApplicationId;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class QueryAttribution {
    private final ApplicationId applicationId;

    private QueryAttribution(ApplicationId applicationId) {
        QueryAttribution.validateFields(applicationId);
        this.applicationId = applicationId;
    }

    @JsonProperty(value="applicationId")
    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof QueryAttribution && this.equalTo((QueryAttribution)other);
    }

    private boolean equalTo(QueryAttribution other) {
        return this.applicationId.equals(other.applicationId);
    }

    public int hashCode() {
        return this.applicationId.hashCode();
    }

    @Safe
    public String toString() {
        return "QueryAttribution{applicationId: " + String.valueOf(this.applicationId) + "}";
    }

    public static QueryAttribution of(ApplicationId applicationId) {
        return QueryAttribution.builder().applicationId(applicationId).build();
    }

    private static void validateFields(ApplicationId applicationId) {
        List<String> missingFields = null;
        if ((missingFields = QueryAttribution.addFieldIfMissing(missingFields, applicationId, "applicationId")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static ApplicationIdStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private ApplicationId applicationId;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(QueryAttribution other) {
            this.checkNotBuilt();
            this.applicationId(other.getApplicationId());
            return this;
        }

        @Override
        @JsonSetter(value="applicationId")
        public Builder applicationId(@Nonnull ApplicationId applicationId) {
            this.checkNotBuilt();
            this.applicationId = Preconditions.checkNotNull(applicationId, "applicationId cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public QueryAttribution build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new QueryAttribution(this.applicationId);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends ApplicationIdStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder applicationId(@Nonnull ApplicationId var1);

        @Override
        public Builder from(QueryAttribution var1);

        @Override
        @CheckReturnValue
        public QueryAttribution build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public QueryAttribution build();
    }

    public static interface ApplicationIdStageBuilder {
        public Completed_StageBuilder applicationId(@Nonnull ApplicationId var1);

        public Builder from(QueryAttribution var1);
    }
}

