/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.google.errorprone.annotations.Immutable;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
@Immutable
public final class QueryCapability {
    public static final QueryCapability UNLIMITED_ROWS = new QueryCapability(Value.UNLIMITED_ROWS, "UNLIMITED_ROWS");
    public static final QueryCapability STREAM_ROW_OFFSET = new QueryCapability(Value.STREAM_ROW_OFFSET, "STREAM_ROW_OFFSET");
    public static final QueryCapability STREAM_ROW_LIMIT = new QueryCapability(Value.STREAM_ROW_LIMIT, "STREAM_ROW_LIMIT");
    private static final List<QueryCapability> values = Collections.unmodifiableList(Arrays.asList(UNLIMITED_ROWS, STREAM_ROW_OFFSET, STREAM_ROW_LIMIT));
    private final Value value;
    private final String string;

    private QueryCapability(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value get() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || this.value == Value.UNKNOWN && other instanceof QueryCapability && this.string.equals(((QueryCapability)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static QueryCapability valueOf(@Nonnull @Safe String value) {
        String upperCasedValue;
        Preconditions.checkNotNull(value, "value cannot be null");
        switch (upperCasedValue = value.toUpperCase(Locale.ROOT)) {
            case "UNLIMITED_ROWS": {
                return UNLIMITED_ROWS;
            }
            case "STREAM_ROW_OFFSET": {
                return STREAM_ROW_OFFSET;
            }
            case "STREAM_ROW_LIMIT": {
                return STREAM_ROW_LIMIT;
            }
        }
        return new QueryCapability(Value.UNKNOWN, upperCasedValue);
    }

    public <T> T accept(Visitor<T> visitor) {
        switch (this.value) {
            case UNLIMITED_ROWS: {
                return visitor.visitUnlimitedRows();
            }
            case STREAM_ROW_OFFSET: {
                return visitor.visitStreamRowOffset();
            }
            case STREAM_ROW_LIMIT: {
                return visitor.visitStreamRowLimit();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    public static List<QueryCapability> values() {
        return values;
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface StreamRowLimitStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> visitStreamRowLimit(@Nonnull Supplier<T> var1);
    }

    public static interface StreamRowOffsetStageVisitorBuilder<T> {
        public StreamRowLimitStageVisitorBuilder<T> visitStreamRowOffset(@Nonnull Supplier<T> var1);
    }

    public static interface UnlimitedRowsStageVisitorBuilder<T> {
        public StreamRowOffsetStageVisitorBuilder<T> visitUnlimitedRows(@Nonnull Supplier<T> var1);
    }

    private static final class VisitorBuilder<T>
    implements UnlimitedRowsStageVisitorBuilder<T>,
    StreamRowOffsetStageVisitorBuilder<T>,
    StreamRowLimitStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Supplier<T> unlimitedRowsVisitor;
        private Supplier<T> streamRowOffsetVisitor;
        private Supplier<T> streamRowLimitVisitor;
        private Function<@Safe String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public StreamRowOffsetStageVisitorBuilder<T> visitUnlimitedRows(@Nonnull Supplier<T> unlimitedRowsVisitor) {
            Preconditions.checkNotNull(unlimitedRowsVisitor, "unlimitedRowsVisitor cannot be null");
            this.unlimitedRowsVisitor = unlimitedRowsVisitor;
            return this;
        }

        @Override
        public StreamRowLimitStageVisitorBuilder<T> visitStreamRowOffset(@Nonnull Supplier<T> streamRowOffsetVisitor) {
            Preconditions.checkNotNull(streamRowOffsetVisitor, "streamRowOffsetVisitor cannot be null");
            this.streamRowOffsetVisitor = streamRowOffsetVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> visitStreamRowLimit(@Nonnull Supplier<T> streamRowLimitVisitor) {
            Preconditions.checkNotNull(streamRowLimitVisitor, "streamRowLimitVisitor cannot be null");
            this.streamRowLimitVisitor = streamRowLimitVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownType -> unknownVisitor.apply((String)unknownType);
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'QueryCapability' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Supplier<T> unlimitedRowsVisitor = this.unlimitedRowsVisitor;
            final Supplier<T> streamRowOffsetVisitor = this.streamRowOffsetVisitor;
            final Supplier<T> streamRowLimitVisitor = this.streamRowLimitVisitor;
            final Function<@Safe String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitUnlimitedRows() {
                    return unlimitedRowsVisitor.get();
                }

                @Override
                public T visitStreamRowOffset() {
                    return streamRowOffsetVisitor.get();
                }

                @Override
                public T visitStreamRowLimit() {
                    return streamRowLimitVisitor.get();
                }

                @Override
                public T visitUnknown(String unknownType) {
                    return unknownVisitor.apply(unknownType);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitUnlimitedRows();

        public T visitStreamRowOffset();

        public T visitStreamRowLimit();

        public T visitUnknown(String var1);

        public static <T> UnlimitedRowsStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }

    public static enum Value {
        UNLIMITED_ROWS,
        STREAM_ROW_OFFSET,
        STREAM_ROW_LIMIT,
        UNKNOWN;

    }
}

