/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.Parameters;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlQuery;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class QueryHistoryItem {
    private final SqlQuery sqlQuery;
    private final Optional<Parameters> parameters;
    private final Instant timestamp;
    private int memoizedHashCode;

    private QueryHistoryItem(SqlQuery sqlQuery, Optional<Parameters> parameters, Instant timestamp) {
        QueryHistoryItem.validateFields(sqlQuery, parameters, timestamp);
        this.sqlQuery = sqlQuery;
        this.parameters = parameters;
        this.timestamp = timestamp;
    }

    @JsonProperty(value="sqlQuery")
    public SqlQuery getSqlQuery() {
        return this.sqlQuery;
    }

    @JsonProperty(value="parameters")
    public Optional<Parameters> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="timestamp")
    public Instant getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof QueryHistoryItem && this.equalTo((QueryHistoryItem)other);
    }

    private boolean equalTo(QueryHistoryItem other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.sqlQuery.equals(other.sqlQuery) && this.parameters.equals(other.parameters) && this.timestamp.equals(other.timestamp);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.sqlQuery.hashCode();
            hash = 31 * hash + this.parameters.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.timestamp.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "QueryHistoryItem{sqlQuery: " + String.valueOf(this.sqlQuery) + ", parameters: " + String.valueOf(this.parameters) + ", timestamp: " + String.valueOf(this.timestamp) + "}";
    }

    public static QueryHistoryItem of(SqlQuery sqlQuery, Parameters parameters, Instant timestamp) {
        return QueryHistoryItem.builder().sqlQuery(sqlQuery).timestamp(timestamp).parameters(Optional.of(parameters)).build();
    }

    private static void validateFields(SqlQuery sqlQuery, Optional<Parameters> parameters, Instant timestamp) {
        List<String> missingFields = null;
        missingFields = QueryHistoryItem.addFieldIfMissing(missingFields, sqlQuery, "sqlQuery");
        missingFields = QueryHistoryItem.addFieldIfMissing(missingFields, parameters, "parameters");
        if ((missingFields = QueryHistoryItem.addFieldIfMissing(missingFields, timestamp, "timestamp")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static SqlQueryStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private SqlQuery sqlQuery;
        private Optional<Parameters> parameters = Optional.empty();
        private Instant timestamp;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(QueryHistoryItem other) {
            this.checkNotBuilt();
            this.sqlQuery(other.getSqlQuery());
            this.parameters((Optional)other.getParameters());
            this.timestamp(other.getTimestamp());
            return this;
        }

        @Override
        @JsonSetter(value="sqlQuery")
        public Builder sqlQuery(@Nonnull SqlQuery sqlQuery) {
            this.checkNotBuilt();
            this.sqlQuery = Preconditions.checkNotNull(sqlQuery, "sqlQuery cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="parameters", nulls=Nulls.SKIP)
        public Builder parameters(@Nonnull Optional<Parameters> parameters) {
            this.checkNotBuilt();
            this.parameters = Preconditions.checkNotNull(parameters, "parameters cannot be null");
            return this;
        }

        @Override
        public Builder parameters(@Nonnull Parameters parameters) {
            this.checkNotBuilt();
            this.parameters = Optional.of(Preconditions.checkNotNull(parameters, "parameters cannot be null"));
            return this;
        }

        @Override
        @JsonSetter(value="timestamp")
        public Builder timestamp(@Nonnull Instant timestamp) {
            this.checkNotBuilt();
            this.timestamp = Preconditions.checkNotNull(timestamp, "timestamp cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public QueryHistoryItem build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new QueryHistoryItem(this.sqlQuery, this.parameters, this.timestamp);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends SqlQueryStageBuilder,
    TimestampStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder sqlQuery(@Nonnull SqlQuery var1);

        @Override
        public Builder from(QueryHistoryItem var1);

        @Override
        public Builder timestamp(@Nonnull Instant var1);

        @Override
        @CheckReturnValue
        public QueryHistoryItem build();

        @Override
        public Builder parameters(@Nonnull Optional<Parameters> var1);

        @Override
        public Builder parameters(@Nonnull Parameters var1);
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public QueryHistoryItem build();

        public Completed_StageBuilder parameters(@Nonnull Optional<Parameters> var1);

        public Completed_StageBuilder parameters(@Nonnull Parameters var1);
    }

    public static interface TimestampStageBuilder {
        public Completed_StageBuilder timestamp(@Nonnull Instant var1);
    }

    public static interface SqlQueryStageBuilder {
        public TimestampStageBuilder sqlQuery(@Nonnull SqlQuery var1);

        public Builder from(QueryHistoryItem var1);
    }
}

