/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.types.Branch;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class QueryInput {
    private final ResourceIdentifier rid;
    private final Branch branch;
    private int memoizedHashCode;

    private QueryInput(ResourceIdentifier rid, Branch branch) {
        QueryInput.validateFields(rid, branch);
        this.rid = rid;
        this.branch = branch;
    }

    @JsonProperty(value="rid")
    @Safe
    public ResourceIdentifier getRid() {
        return this.rid;
    }

    @JsonProperty(value="branch")
    public Branch getBranch() {
        return this.branch;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof QueryInput && this.equalTo((QueryInput)other);
    }

    private boolean equalTo(QueryInput other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.rid.equals(other.rid) && this.branch.equals(other.branch);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.rid.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.branch.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "QueryInput{rid: " + String.valueOf(this.rid) + ", branch: " + String.valueOf(this.branch) + "}";
    }

    public static QueryInput of(@Safe ResourceIdentifier rid, Branch branch) {
        return QueryInput.builder().rid(rid).branch(branch).build();
    }

    private static void validateFields(ResourceIdentifier rid, Branch branch) {
        List<String> missingFields = null;
        missingFields = QueryInput.addFieldIfMissing(missingFields, rid, "rid");
        if ((missingFields = QueryInput.addFieldIfMissing(missingFields, branch, "branch")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static RidStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        @Safe
        private ResourceIdentifier rid;
        private Branch branch;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(QueryInput other) {
            this.checkNotBuilt();
            this.rid(other.getRid());
            this.branch(other.getBranch());
            return this;
        }

        @Override
        @JsonSetter(value="rid")
        public Builder rid(@Nonnull @Safe ResourceIdentifier rid) {
            this.checkNotBuilt();
            this.rid = Preconditions.checkNotNull(rid, "rid cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="branch")
        public Builder branch(@Nonnull Branch branch) {
            this.checkNotBuilt();
            this.branch = Preconditions.checkNotNull(branch, "branch cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public QueryInput build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new QueryInput(this.rid, this.branch);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends RidStageBuilder,
    BranchStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder rid(@Nonnull @Safe ResourceIdentifier var1);

        @Override
        public Builder from(QueryInput var1);

        @Override
        public Builder branch(@Nonnull Branch var1);

        @Override
        @CheckReturnValue
        public QueryInput build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public QueryInput build();
    }

    public static interface BranchStageBuilder {
        public Completed_StageBuilder branch(@Nonnull Branch var1);
    }

    public static interface RidStageBuilder {
        public BranchStageBuilder rid(@Nonnull @Safe ResourceIdentifier var1);

        public Builder from(QueryInput var1);
    }
}

