/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnyGetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAnySetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSubTypes;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.CanceledQueryStatus;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.FailedQueryStatus;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.ReadyQueryStatusV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.RunningQueryStatusV2;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@DoNotLog
public final class QueryStatusV2 {
    private final Base value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private QueryStatusV2(Base value) {
        this.value = value;
    }

    @JsonValue
    private Base getValue() {
        return this.value;
    }

    public static QueryStatusV2 canceled(CanceledQueryStatus value) {
        return new QueryStatusV2(new CanceledWrapper(value));
    }

    public static QueryStatusV2 failed(FailedQueryStatus value) {
        return new QueryStatusV2(new FailedWrapper(value));
    }

    public static QueryStatusV2 ready(ReadyQueryStatusV2 value) {
        return new QueryStatusV2(new ReadyWrapper(value));
    }

    public static QueryStatusV2 running(RunningQueryStatusV2 value) {
        return new QueryStatusV2(new RunningWrapper(value));
    }

    public static QueryStatusV2 unknown(@Safe String type, Object value) {
        switch (Preconditions.checkNotNull(type, "Type is required")) {
            case "canceled": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: canceled", new Arg[0]);
            }
            case "failed": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: failed", new Arg[0]);
            }
            case "ready": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: ready", new Arg[0]);
            }
            case "running": {
                throw new SafeIllegalArgumentException("Unknown type cannot be created as the provided type is known: running", new Arg[0]);
            }
        }
        return new QueryStatusV2(new UnknownWrapper(type, Collections.singletonMap(type, value)));
    }

    public <T> T accept(Visitor<T> visitor) {
        return this.value.accept(visitor);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof QueryStatusV2 && this.equalTo((QueryStatusV2)other);
    }

    private boolean equalTo(QueryStatusV2 other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @DoNotLog
    public String toString() {
        return "QueryStatusV2{value: " + String.valueOf(this.value) + "}";
    }

    private static final class UnknownWrapper
    implements Base {
        private final String type;
        private final Map<String, Object> value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private UnknownWrapper(@JsonProperty(value="type") String type) {
            this(type, new HashMap<String, Object>());
        }

        private UnknownWrapper(@Nonnull String type, @Nonnull Map<String, Object> value) {
            Preconditions.checkNotNull(type, "type cannot be null");
            Preconditions.checkNotNull(value, "value cannot be null");
            this.type = type;
            this.value = value;
        }

        @JsonProperty
        private String getType() {
            return this.type;
        }

        @JsonAnyGetter
        private Map<String, Object> getValue() {
            return this.value;
        }

        @JsonAnySetter
        private void put(String key, Object val) {
            this.value.put(key, val);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitUnknown(this.type);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof UnknownWrapper && this.equalTo((UnknownWrapper)other);
        }

        private boolean equalTo(UnknownWrapper other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + this.type.hashCode();
            hash = 31 * hash + this.value.hashCode();
            return hash;
        }

        public String toString() {
            return "UnknownWrapper{type: " + this.type + ", value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeName(value="running")
    private static final class RunningWrapper
    implements Base {
        private final RunningQueryStatusV2 value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private RunningWrapper(@JsonSetter(value="running") @Nonnull RunningQueryStatusV2 value) {
            Preconditions.checkNotNull(value, "running cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "running";
        }

        @JsonProperty(value="running")
        private RunningQueryStatusV2 getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitRunning(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof RunningWrapper && this.equalTo((RunningWrapper)other);
        }

        private boolean equalTo(RunningWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "RunningWrapper{value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeName(value="ready")
    private static final class ReadyWrapper
    implements Base {
        private final ReadyQueryStatusV2 value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ReadyWrapper(@JsonSetter(value="ready") @Nonnull ReadyQueryStatusV2 value) {
            Preconditions.checkNotNull(value, "ready cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "ready";
        }

        @JsonProperty(value="ready")
        private ReadyQueryStatusV2 getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitReady(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof ReadyWrapper && this.equalTo((ReadyWrapper)other);
        }

        private boolean equalTo(ReadyWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "ReadyWrapper{value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeName(value="failed")
    private static final class FailedWrapper
    implements Base {
        private final FailedQueryStatus value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private FailedWrapper(@JsonSetter(value="failed") @Nonnull FailedQueryStatus value) {
            Preconditions.checkNotNull(value, "failed cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "failed";
        }

        @JsonProperty(value="failed")
        private FailedQueryStatus getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitFailed(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof FailedWrapper && this.equalTo((FailedWrapper)other);
        }

        private boolean equalTo(FailedWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "FailedWrapper{value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeName(value="canceled")
    private static final class CanceledWrapper
    implements Base {
        private final CanceledQueryStatus value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private CanceledWrapper(@JsonSetter(value="canceled") @Nonnull CanceledQueryStatus value) {
            Preconditions.checkNotNull(value, "canceled cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "canceled";
        }

        @JsonProperty(value="canceled")
        private CanceledQueryStatus getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitCanceled(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof CanceledWrapper && this.equalTo((CanceledWrapper)other);
        }

        private boolean equalTo(CanceledWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "CanceledWrapper{value: " + String.valueOf(this.value) + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=UnknownWrapper.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CanceledWrapper.class), @JsonSubTypes.Type(value=FailedWrapper.class), @JsonSubTypes.Type(value=ReadyWrapper.class), @JsonSubTypes.Type(value=RunningWrapper.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Base {
        public <T> T accept(Visitor<T> var1);
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface RunningStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> running(@Nonnull Function<RunningQueryStatusV2, T> var1);
    }

    public static interface ReadyStageVisitorBuilder<T> {
        public RunningStageVisitorBuilder<T> ready(@Nonnull Function<ReadyQueryStatusV2, T> var1);
    }

    public static interface FailedStageVisitorBuilder<T> {
        public ReadyStageVisitorBuilder<T> failed(@Nonnull Function<FailedQueryStatus, T> var1);
    }

    public static interface CanceledStageVisitorBuilder<T> {
        public FailedStageVisitorBuilder<T> canceled(@Nonnull Function<CanceledQueryStatus, T> var1);
    }

    private static final class VisitorBuilder<T>
    implements CanceledStageVisitorBuilder<T>,
    FailedStageVisitorBuilder<T>,
    ReadyStageVisitorBuilder<T>,
    RunningStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Function<CanceledQueryStatus, T> canceledVisitor;
        private Function<FailedQueryStatus, T> failedVisitor;
        private Function<ReadyQueryStatusV2, T> readyVisitor;
        private Function<RunningQueryStatusV2, T> runningVisitor;
        private Function<String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public FailedStageVisitorBuilder<T> canceled(@Nonnull Function<CanceledQueryStatus, T> canceledVisitor) {
            Preconditions.checkNotNull(canceledVisitor, "canceledVisitor cannot be null");
            this.canceledVisitor = canceledVisitor;
            return this;
        }

        @Override
        public ReadyStageVisitorBuilder<T> failed(@Nonnull Function<FailedQueryStatus, T> failedVisitor) {
            Preconditions.checkNotNull(failedVisitor, "failedVisitor cannot be null");
            this.failedVisitor = failedVisitor;
            return this;
        }

        @Override
        public RunningStageVisitorBuilder<T> ready(@Nonnull Function<ReadyQueryStatusV2, T> readyVisitor) {
            Preconditions.checkNotNull(readyVisitor, "readyVisitor cannot be null");
            this.readyVisitor = readyVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> running(@Nonnull Function<RunningQueryStatusV2, T> runningVisitor) {
            Preconditions.checkNotNull(runningVisitor, "runningVisitor cannot be null");
            this.runningVisitor = runningVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'QueryStatusV2' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Function<CanceledQueryStatus, T> canceledVisitor = this.canceledVisitor;
            final Function<FailedQueryStatus, T> failedVisitor = this.failedVisitor;
            final Function<ReadyQueryStatusV2, T> readyVisitor = this.readyVisitor;
            final Function<RunningQueryStatusV2, T> runningVisitor = this.runningVisitor;
            final Function<String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitCanceled(CanceledQueryStatus value) {
                    return canceledVisitor.apply(value);
                }

                @Override
                public T visitFailed(FailedQueryStatus value) {
                    return failedVisitor.apply(value);
                }

                @Override
                public T visitReady(ReadyQueryStatusV2 value) {
                    return readyVisitor.apply(value);
                }

                @Override
                public T visitRunning(RunningQueryStatusV2 value) {
                    return runningVisitor.apply(value);
                }

                @Override
                public T visitUnknown(String value) {
                    return unknownVisitor.apply(value);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitCanceled(CanceledQueryStatus var1);

        public T visitFailed(FailedQueryStatus var1);

        public T visitReady(ReadyQueryStatusV2 var1);

        public T visitRunning(RunningQueryStatusV2 var1);

        public T visitUnknown(@Safe String var1);

        public static <T> CanceledStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }
}

