/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryIdV2;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.TicketInfo;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@DoNotLog
@JsonDeserialize(builder=DefaultBuilder.class)
public final class ReadyQueryStatusV2 {
    private final boolean deterministic;
    private final boolean ordered;
    private final QueryIdV2 queryId;
    private final List<TicketInfo> tickets;
    private int memoizedHashCode;

    private ReadyQueryStatusV2(boolean deterministic, boolean ordered, QueryIdV2 queryId, List<TicketInfo> tickets) {
        ReadyQueryStatusV2.validateFields(queryId, tickets);
        this.deterministic = deterministic;
        this.ordered = ordered;
        this.queryId = queryId;
        this.tickets = Collections.unmodifiableList(tickets);
    }

    @JsonProperty(value="deterministic")
    @Safe
    public boolean getDeterministic() {
        return this.deterministic;
    }

    @JsonProperty(value="ordered")
    @Safe
    public boolean getOrdered() {
        return this.ordered;
    }

    @JsonProperty(value="queryId")
    public QueryIdV2 getQueryId() {
        return this.queryId;
    }

    @JsonProperty(value="tickets")
    public List<TicketInfo> getTickets() {
        return this.tickets;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ReadyQueryStatusV2 && this.equalTo((ReadyQueryStatusV2)other);
    }

    private boolean equalTo(ReadyQueryStatusV2 other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.deterministic == other.deterministic && this.ordered == other.ordered && this.queryId.equals(other.queryId) && this.tickets.equals(other.tickets);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + Boolean.hashCode(this.deterministic);
            hash = 31 * hash + Boolean.hashCode(this.ordered);
            hash = 31 * hash + this.queryId.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.tickets.hashCode());
        }
        return result;
    }

    @DoNotLog
    public String toString() {
        return "ReadyQueryStatusV2{deterministic: " + this.deterministic + ", ordered: " + this.ordered + ", queryId: " + String.valueOf(this.queryId) + ", tickets: " + String.valueOf(this.tickets) + "}";
    }

    private static void validateFields(QueryIdV2 queryId, List<TicketInfo> tickets) {
        List<String> missingFields = null;
        missingFields = ReadyQueryStatusV2.addFieldIfMissing(missingFields, queryId, "queryId");
        if ((missingFields = ReadyQueryStatusV2.addFieldIfMissing(missingFields, tickets, "tickets")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static DeterministicStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        @Safe
        private boolean deterministic;
        @Safe
        private boolean ordered;
        private QueryIdV2 queryId;
        private List<TicketInfo> tickets = ConjureCollections.newList();
        private boolean _deterministicInitialized = false;
        private boolean _orderedInitialized = false;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(ReadyQueryStatusV2 other) {
            this.checkNotBuilt();
            this.deterministic(other.getDeterministic());
            this.ordered(other.getOrdered());
            this.queryId(other.getQueryId());
            this.tickets(other.getTickets());
            return this;
        }

        @Override
        @JsonSetter(value="deterministic")
        public Builder deterministic(@Safe boolean deterministic) {
            this.checkNotBuilt();
            this.deterministic = deterministic;
            this._deterministicInitialized = true;
            return this;
        }

        @Override
        @JsonSetter(value="ordered")
        public Builder ordered(@Safe boolean ordered) {
            this.checkNotBuilt();
            this.ordered = ordered;
            this._orderedInitialized = true;
            return this;
        }

        @Override
        @JsonSetter(value="queryId")
        public Builder queryId(@Nonnull QueryIdV2 queryId) {
            this.checkNotBuilt();
            this.queryId = Preconditions.checkNotNull(queryId, "queryId cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="tickets", nulls=Nulls.SKIP)
        public Builder tickets(@Nonnull Iterable<TicketInfo> tickets) {
            this.checkNotBuilt();
            this.tickets = ConjureCollections.newList(Preconditions.checkNotNull(tickets, "tickets cannot be null"));
            return this;
        }

        @Override
        public Builder addAllTickets(@Nonnull Iterable<TicketInfo> tickets) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.tickets, Preconditions.checkNotNull(tickets, "tickets cannot be null"));
            return this;
        }

        @Override
        public Builder tickets(TicketInfo tickets) {
            this.checkNotBuilt();
            this.tickets.add(tickets);
            return this;
        }

        private void validatePrimitiveFieldsHaveBeenInitialized() {
            List<String> missingFields = null;
            missingFields = DefaultBuilder.addFieldIfMissing(missingFields, this._deterministicInitialized, "deterministic");
            if ((missingFields = DefaultBuilder.addFieldIfMissing(missingFields, this._orderedInitialized, "ordered")) != null) {
                throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
            }
        }

        private static List<String> addFieldIfMissing(List<String> prev, boolean initialized, String fieldName) {
            List<String> missingFields = prev;
            if (!initialized) {
                if (missingFields == null) {
                    missingFields = new ArrayList<String>(2);
                }
                missingFields.add(fieldName);
            }
            return missingFields;
        }

        @Override
        @CheckReturnValue
        public ReadyQueryStatusV2 build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            this.validatePrimitiveFieldsHaveBeenInitialized();
            return new ReadyQueryStatusV2(this.deterministic, this.ordered, this.queryId, this.tickets);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends DeterministicStageBuilder,
    OrderedStageBuilder,
    QueryIdStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder deterministic(@Nonnull @Safe boolean var1);

        @Override
        public Builder from(ReadyQueryStatusV2 var1);

        @Override
        public Builder ordered(@Nonnull @Safe boolean var1);

        @Override
        public Builder queryId(@Nonnull QueryIdV2 var1);

        @Override
        @CheckReturnValue
        public ReadyQueryStatusV2 build();

        @Override
        public Builder tickets(@Nonnull Iterable<TicketInfo> var1);

        @Override
        public Builder addAllTickets(@Nonnull Iterable<TicketInfo> var1);

        @Override
        public Builder tickets(TicketInfo var1);
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public ReadyQueryStatusV2 build();

        public Completed_StageBuilder tickets(@Nonnull Iterable<TicketInfo> var1);

        public Completed_StageBuilder addAllTickets(@Nonnull Iterable<TicketInfo> var1);

        public Completed_StageBuilder tickets(TicketInfo var1);
    }

    public static interface QueryIdStageBuilder {
        public Completed_StageBuilder queryId(@Nonnull QueryIdV2 var1);
    }

    public static interface OrderedStageBuilder {
        public QueryIdStageBuilder ordered(@Nonnull @Safe boolean var1);
    }

    public static interface DeterministicStageBuilder {
        public OrderedStageBuilder deterministic(@Nonnull @Safe boolean var1);

        public Builder from(ReadyQueryStatusV2 var1);
    }
}

