/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.QueryIdV2;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@DoNotLog
@JsonDeserialize(builder=DefaultBuilder.class)
public final class RunningQueryStatusV2 {
    private final QueryIdV2 queryId;

    private RunningQueryStatusV2(QueryIdV2 queryId) {
        RunningQueryStatusV2.validateFields(queryId);
        this.queryId = queryId;
    }

    @JsonProperty(value="queryId")
    public QueryIdV2 getQueryId() {
        return this.queryId;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof RunningQueryStatusV2 && this.equalTo((RunningQueryStatusV2)other);
    }

    private boolean equalTo(RunningQueryStatusV2 other) {
        return this.queryId.equals(other.queryId);
    }

    public int hashCode() {
        return this.queryId.hashCode();
    }

    @DoNotLog
    public String toString() {
        return "RunningQueryStatusV2{queryId: " + String.valueOf(this.queryId) + "}";
    }

    public static RunningQueryStatusV2 of(QueryIdV2 queryId) {
        return RunningQueryStatusV2.builder().queryId(queryId).build();
    }

    private static void validateFields(QueryIdV2 queryId) {
        List<String> missingFields = null;
        if ((missingFields = RunningQueryStatusV2.addFieldIfMissing(missingFields, queryId, "queryId")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static QueryIdStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private QueryIdV2 queryId;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(RunningQueryStatusV2 other) {
            this.checkNotBuilt();
            this.queryId(other.getQueryId());
            return this;
        }

        @Override
        @JsonSetter(value="queryId")
        public Builder queryId(@Nonnull QueryIdV2 queryId) {
            this.checkNotBuilt();
            this.queryId = Preconditions.checkNotNull(queryId, "queryId cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public RunningQueryStatusV2 build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new RunningQueryStatusV2(this.queryId);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends QueryIdStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder queryId(@Nonnull QueryIdV2 var1);

        @Override
        public Builder from(RunningQueryStatusV2 var1);

        @Override
        @CheckReturnValue
        public RunningQueryStatusV2 build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public RunningQueryStatusV2 build();
    }

    public static interface QueryIdStageBuilder {
        public Completed_StageBuilder queryId(@Nonnull QueryIdV2 var1);

        public Builder from(RunningQueryStatusV2 var1);
    }
}

