/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class SchemaInfo {
    private final String catalogName;
    private final String schemaName;
    private int memoizedHashCode;

    private SchemaInfo(String catalogName, String schemaName) {
        SchemaInfo.validateFields(catalogName, schemaName);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    @JsonProperty(value="catalogName")
    @Unsafe
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="schemaName")
    @Unsafe
    public String getSchemaName() {
        return this.schemaName;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SchemaInfo && this.equalTo((SchemaInfo)other);
    }

    private boolean equalTo(SchemaInfo other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.catalogName.equals(other.catalogName) && this.schemaName.equals(other.schemaName);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            int hash = 1;
            hash = 31 * hash + this.catalogName.hashCode();
            this.memoizedHashCode = result = (hash = 31 * hash + this.schemaName.hashCode());
        }
        return result;
    }

    @Unsafe
    public String toString() {
        return "SchemaInfo{catalogName: " + this.catalogName + ", schemaName: " + this.schemaName + "}";
    }

    public static SchemaInfo of(@Unsafe String catalogName, @Unsafe String schemaName) {
        return SchemaInfo.builder().catalogName(catalogName).schemaName(schemaName).build();
    }

    private static void validateFields(String catalogName, String schemaName) {
        List<String> missingFields = null;
        missingFields = SchemaInfo.addFieldIfMissing(missingFields, catalogName, "catalogName");
        if ((missingFields = SchemaInfo.addFieldIfMissing(missingFields, schemaName, "schemaName")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(2);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static CatalogNameStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        @Unsafe
        private String catalogName;
        @Unsafe
        private String schemaName;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(SchemaInfo other) {
            this.checkNotBuilt();
            this.catalogName(other.getCatalogName());
            this.schemaName(other.getSchemaName());
            return this;
        }

        @Override
        @JsonSetter(value="catalogName")
        public Builder catalogName(@Nonnull @Unsafe String catalogName) {
            this.checkNotBuilt();
            this.catalogName = Preconditions.checkNotNull(catalogName, "catalogName cannot be null");
            return this;
        }

        @Override
        @JsonSetter(value="schemaName")
        public Builder schemaName(@Nonnull @Unsafe String schemaName) {
            this.checkNotBuilt();
            this.schemaName = Preconditions.checkNotNull(schemaName, "schemaName cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public SchemaInfo build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new SchemaInfo(this.catalogName, this.schemaName);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends CatalogNameStageBuilder,
    SchemaNameStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder catalogName(@Nonnull @Unsafe String var1);

        @Override
        public Builder from(SchemaInfo var1);

        @Override
        public Builder schemaName(@Nonnull @Unsafe String var1);

        @Override
        @CheckReturnValue
        public SchemaInfo build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public SchemaInfo build();
    }

    public static interface SchemaNameStageBuilder {
        public Completed_StageBuilder schemaName(@Nonnull @Unsafe String var1);
    }

    public static interface CatalogNameStageBuilder {
        public SchemaNameStageBuilder catalogName(@Nonnull @Unsafe String var1);

        public Builder from(SchemaInfo var1);
    }
}

