/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.google.errorprone.annotations.Immutable;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
@Immutable
public final class SerializationProtocol {
    public static final SerializationProtocol ROW_ITERATING_JSON = new SerializationProtocol(Value.ROW_ITERATING_JSON, "ROW_ITERATING_JSON");
    public static final SerializationProtocol ARROW = new SerializationProtocol(Value.ARROW, "ARROW");
    public static final SerializationProtocol ARROW_V1 = new SerializationProtocol(Value.ARROW_V1, "ARROW_V1");
    public static final SerializationProtocol CSV = new SerializationProtocol(Value.CSV, "CSV");
    public static final SerializationProtocol CSV_POWERBI_REST = new SerializationProtocol(Value.CSV_POWERBI_REST, "CSV_POWERBI_REST");
    private static final List<SerializationProtocol> values = Collections.unmodifiableList(Arrays.asList(ROW_ITERATING_JSON, ARROW, ARROW_V1, CSV, CSV_POWERBI_REST));
    private final Value value;
    private final String string;

    private SerializationProtocol(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value get() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || this.value == Value.UNKNOWN && other instanceof SerializationProtocol && this.string.equals(((SerializationProtocol)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static SerializationProtocol valueOf(@Nonnull @Safe String value) {
        String upperCasedValue;
        Preconditions.checkNotNull(value, "value cannot be null");
        switch (upperCasedValue = value.toUpperCase(Locale.ROOT)) {
            case "ROW_ITERATING_JSON": {
                return ROW_ITERATING_JSON;
            }
            case "ARROW": {
                return ARROW;
            }
            case "ARROW_V1": {
                return ARROW_V1;
            }
            case "CSV": {
                return CSV;
            }
            case "CSV_POWERBI_REST": {
                return CSV_POWERBI_REST;
            }
        }
        return new SerializationProtocol(Value.UNKNOWN, upperCasedValue);
    }

    public <T> T accept(Visitor<T> visitor) {
        switch (this.value) {
            case ROW_ITERATING_JSON: {
                return visitor.visitRowIteratingJson();
            }
            case ARROW: {
                return visitor.visitArrow();
            }
            case ARROW_V1: {
                return visitor.visitArrowV1();
            }
            case CSV: {
                return visitor.visitCsv();
            }
            case CSV_POWERBI_REST: {
                return visitor.visitCsvPowerbiRest();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    public static List<SerializationProtocol> values() {
        return values;
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface CsvPowerbiRestStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> visitCsvPowerbiRest(@Nonnull Supplier<T> var1);
    }

    public static interface CsvStageVisitorBuilder<T> {
        public CsvPowerbiRestStageVisitorBuilder<T> visitCsv(@Nonnull Supplier<T> var1);
    }

    public static interface ArrowV1StageVisitorBuilder<T> {
        public CsvStageVisitorBuilder<T> visitArrowV1(@Nonnull Supplier<T> var1);
    }

    public static interface ArrowStageVisitorBuilder<T> {
        public ArrowV1StageVisitorBuilder<T> visitArrow(@Nonnull Supplier<T> var1);
    }

    public static interface RowIteratingJsonStageVisitorBuilder<T> {
        public ArrowStageVisitorBuilder<T> visitRowIteratingJson(@Nonnull Supplier<T> var1);
    }

    private static final class VisitorBuilder<T>
    implements RowIteratingJsonStageVisitorBuilder<T>,
    ArrowStageVisitorBuilder<T>,
    ArrowV1StageVisitorBuilder<T>,
    CsvStageVisitorBuilder<T>,
    CsvPowerbiRestStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Supplier<T> rowIteratingJsonVisitor;
        private Supplier<T> arrowVisitor;
        private Supplier<T> arrowV1Visitor;
        private Supplier<T> csvVisitor;
        private Supplier<T> csvPowerbiRestVisitor;
        private Function<@Safe String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public ArrowStageVisitorBuilder<T> visitRowIteratingJson(@Nonnull Supplier<T> rowIteratingJsonVisitor) {
            Preconditions.checkNotNull(rowIteratingJsonVisitor, "rowIteratingJsonVisitor cannot be null");
            this.rowIteratingJsonVisitor = rowIteratingJsonVisitor;
            return this;
        }

        @Override
        public ArrowV1StageVisitorBuilder<T> visitArrow(@Nonnull Supplier<T> arrowVisitor) {
            Preconditions.checkNotNull(arrowVisitor, "arrowVisitor cannot be null");
            this.arrowVisitor = arrowVisitor;
            return this;
        }

        @Override
        public CsvStageVisitorBuilder<T> visitArrowV1(@Nonnull Supplier<T> arrowV1Visitor) {
            Preconditions.checkNotNull(arrowV1Visitor, "arrowV1Visitor cannot be null");
            this.arrowV1Visitor = arrowV1Visitor;
            return this;
        }

        @Override
        public CsvPowerbiRestStageVisitorBuilder<T> visitCsv(@Nonnull Supplier<T> csvVisitor) {
            Preconditions.checkNotNull(csvVisitor, "csvVisitor cannot be null");
            this.csvVisitor = csvVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> visitCsvPowerbiRest(@Nonnull Supplier<T> csvPowerbiRestVisitor) {
            Preconditions.checkNotNull(csvPowerbiRestVisitor, "csvPowerbiRestVisitor cannot be null");
            this.csvPowerbiRestVisitor = csvPowerbiRestVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownType -> unknownVisitor.apply((String)unknownType);
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'SerializationProtocol' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Supplier<T> rowIteratingJsonVisitor = this.rowIteratingJsonVisitor;
            final Supplier<T> arrowVisitor = this.arrowVisitor;
            final Supplier<T> arrowV1Visitor = this.arrowV1Visitor;
            final Supplier<T> csvVisitor = this.csvVisitor;
            final Supplier<T> csvPowerbiRestVisitor = this.csvPowerbiRestVisitor;
            final Function<@Safe String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitRowIteratingJson() {
                    return rowIteratingJsonVisitor.get();
                }

                @Override
                public T visitArrow() {
                    return arrowVisitor.get();
                }

                @Override
                public T visitArrowV1() {
                    return arrowV1Visitor.get();
                }

                @Override
                public T visitCsv() {
                    return csvVisitor.get();
                }

                @Override
                public T visitCsvPowerbiRest() {
                    return csvPowerbiRestVisitor.get();
                }

                @Override
                public T visitUnknown(String unknownType) {
                    return unknownVisitor.apply(unknownType);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitRowIteratingJson();

        public T visitArrow();

        public T visitArrowV1();

        public T visitCsv();

        public T visitCsvPowerbiRest();

        public T visitUnknown(String var1);

        public static <T> RowIteratingJsonStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }

    public static enum Value {
        ROW_ITERATING_JSON,
        ARROW,
        ARROW_V1,
        CSV,
        CSV_POWERBI_REST,
        UNKNOWN;

    }
}

