/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class ServiceInfo {
    private final String apiEndpoint;

    private ServiceInfo(String apiEndpoint) {
        ServiceInfo.validateFields(apiEndpoint);
        this.apiEndpoint = apiEndpoint;
    }

    @JsonProperty(value="apiEndpoint")
    @Unsafe
    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ServiceInfo && this.equalTo((ServiceInfo)other);
    }

    private boolean equalTo(ServiceInfo other) {
        return this.apiEndpoint.equals(other.apiEndpoint);
    }

    public int hashCode() {
        return this.apiEndpoint.hashCode();
    }

    @Unsafe
    public String toString() {
        return "ServiceInfo{apiEndpoint: " + this.apiEndpoint + "}";
    }

    public static ServiceInfo of(@Unsafe String apiEndpoint) {
        return ServiceInfo.builder().apiEndpoint(apiEndpoint).build();
    }

    private static void validateFields(String apiEndpoint) {
        List<String> missingFields = null;
        if ((missingFields = ServiceInfo.addFieldIfMissing(missingFields, apiEndpoint, "apiEndpoint")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static ApiEndpointStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        @Unsafe
        private String apiEndpoint;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(ServiceInfo other) {
            this.checkNotBuilt();
            this.apiEndpoint(other.getApiEndpoint());
            return this;
        }

        @Override
        @JsonSetter(value="apiEndpoint")
        public Builder apiEndpoint(@Nonnull @Unsafe String apiEndpoint) {
            this.checkNotBuilt();
            this.apiEndpoint = Preconditions.checkNotNull(apiEndpoint, "apiEndpoint cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public ServiceInfo build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new ServiceInfo(this.apiEndpoint);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends ApiEndpointStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder apiEndpoint(@Nonnull @Unsafe String var1);

        @Override
        public Builder from(ServiceInfo var1);

        @Override
        @CheckReturnValue
        public ServiceInfo build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public ServiceInfo build();
    }

    public static interface ApiEndpointStageBuilder {
        public Completed_StageBuilder apiEndpoint(@Nonnull @Unsafe String var1);

        public Builder from(ServiceInfo var1);
    }
}

