/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import java.util.UUID;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
public final class SessionId {
    @Safe
    private final UUID value;

    private SessionId(@Nonnull @Safe UUID value) {
        this.value = Preconditions.checkNotNull(value, "value cannot be null");
    }

    @JsonValue
    @Safe
    public UUID get() {
        return this.value;
    }

    @Safe
    public String toString() {
        return this.value.toString();
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SessionId && this.equalTo((SessionId)other);
    }

    private boolean equalTo(SessionId other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static SessionId valueOf(@Safe String value) {
        return SessionId.of(UUID.fromString(value));
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static SessionId of(@Nonnull @Safe UUID value) {
        return new SessionId(value);
    }
}

