/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api.SqlSharedQuery;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Unsafe
@JsonDeserialize(builder=DefaultBuilder.class)
public final class SqlCreateSharedQueryRequest {
    private final SqlSharedQuery sharedQuery;

    private SqlCreateSharedQueryRequest(SqlSharedQuery sharedQuery) {
        SqlCreateSharedQueryRequest.validateFields(sharedQuery);
        this.sharedQuery = sharedQuery;
    }

    @JsonProperty(value="sharedQuery")
    public SqlSharedQuery getSharedQuery() {
        return this.sharedQuery;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SqlCreateSharedQueryRequest && this.equalTo((SqlCreateSharedQueryRequest)other);
    }

    private boolean equalTo(SqlCreateSharedQueryRequest other) {
        return this.sharedQuery.equals(other.sharedQuery);
    }

    public int hashCode() {
        return this.sharedQuery.hashCode();
    }

    @Unsafe
    public String toString() {
        return "SqlCreateSharedQueryRequest{sharedQuery: " + String.valueOf(this.sharedQuery) + "}";
    }

    public static SqlCreateSharedQueryRequest of(SqlSharedQuery sharedQuery) {
        return SqlCreateSharedQueryRequest.builder().sharedQuery(sharedQuery).build();
    }

    private static void validateFields(SqlSharedQuery sharedQuery) {
        List<String> missingFields = null;
        if ((missingFields = SqlCreateSharedQueryRequest.addFieldIfMissing(missingFields, sharedQuery, "sharedQuery")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static SharedQueryStageBuilder builder() {
        return new DefaultBuilder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static final class DefaultBuilder
    implements Builder {
        boolean _buildInvoked;
        private SqlSharedQuery sharedQuery;

        private DefaultBuilder() {
        }

        @Override
        public Builder from(SqlCreateSharedQueryRequest other) {
            this.checkNotBuilt();
            this.sharedQuery(other.getSharedQuery());
            return this;
        }

        @Override
        @JsonSetter(value="sharedQuery")
        public Builder sharedQuery(@Nonnull SqlSharedQuery sharedQuery) {
            this.checkNotBuilt();
            this.sharedQuery = Preconditions.checkNotNull(sharedQuery, "sharedQuery cannot be null");
            return this;
        }

        @Override
        @CheckReturnValue
        public SqlCreateSharedQueryRequest build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new SqlCreateSharedQueryRequest(this.sharedQuery);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }

    public static interface Builder
    extends SharedQueryStageBuilder,
    Completed_StageBuilder {
        @Override
        public Builder sharedQuery(@Nonnull SqlSharedQuery var1);

        @Override
        public Builder from(SqlCreateSharedQueryRequest var1);

        @Override
        @CheckReturnValue
        public SqlCreateSharedQueryRequest build();
    }

    public static interface Completed_StageBuilder {
        @CheckReturnValue
        public SqlCreateSharedQueryRequest build();
    }

    public static interface SharedQueryStageBuilder {
        public Completed_StageBuilder sharedQuery(@Nonnull SqlSharedQuery var1);

        public Builder from(SqlCreateSharedQueryRequest var1);
    }
}

