/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class SqlDescribeResponse {
    private final List<FoundryFieldSchema> schema;
    private int memoizedHashCode;

    private SqlDescribeResponse(List<FoundryFieldSchema> schema) {
        SqlDescribeResponse.validateFields(schema);
        this.schema = Collections.unmodifiableList(schema);
    }

    @JsonProperty(value="schema")
    public List<FoundryFieldSchema> getSchema() {
        return this.schema;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SqlDescribeResponse && this.equalTo((SqlDescribeResponse)other);
    }

    private boolean equalTo(SqlDescribeResponse other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.schema.equals(other.schema);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            this.memoizedHashCode = result = this.schema.hashCode();
        }
        return result;
    }

    public String toString() {
        return "SqlDescribeResponse{schema: " + String.valueOf(this.schema) + "}";
    }

    public static SqlDescribeResponse of(List<FoundryFieldSchema> schema) {
        return SqlDescribeResponse.builder().schema(schema).build();
    }

    private static void validateFields(List<FoundryFieldSchema> schema) {
        List<String> missingFields = null;
        if ((missingFields = SqlDescribeResponse.addFieldIfMissing(missingFields, schema, "schema")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private List<FoundryFieldSchema> schema = ConjureCollections.newList();

        private Builder() {
        }

        public Builder from(SqlDescribeResponse other) {
            this.checkNotBuilt();
            this.schema(other.getSchema());
            return this;
        }

        @JsonSetter(value="schema", nulls=Nulls.SKIP)
        public Builder schema(@Nonnull Iterable<? extends FoundryFieldSchema> schema) {
            this.checkNotBuilt();
            this.schema = ConjureCollections.newList(Preconditions.checkNotNull(schema, "schema cannot be null"));
            return this;
        }

        public Builder addAllSchema(@Nonnull Iterable<? extends FoundryFieldSchema> schema) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.schema, Preconditions.checkNotNull(schema, "schema cannot be null"));
            return this;
        }

        public Builder schema(FoundryFieldSchema schema) {
            this.checkNotBuilt();
            this.schema.add(schema);
            return this;
        }

        @CheckReturnValue
        public SqlDescribeResponse build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new SqlDescribeResponse(this.schema);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

