/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.foundrysqlserver.com.palantir.foundry.sql.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.google.errorprone.annotations.Immutable;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
@Immutable
public final class SqlDialect {
    public static final SqlDialect ANSI = new SqlDialect(Value.ANSI, "ANSI");
    public static final SqlDialect ODBC = new SqlDialect(Value.ODBC, "ODBC");
    public static final SqlDialect SPARK = new SqlDialect(Value.SPARK, "SPARK");
    private static final List<SqlDialect> values = Collections.unmodifiableList(Arrays.asList(ANSI, ODBC, SPARK));
    private final Value value;
    private final String string;

    private SqlDialect(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value get() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || this.value == Value.UNKNOWN && other instanceof SqlDialect && this.string.equals(((SqlDialect)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static SqlDialect valueOf(@Nonnull @Safe String value) {
        String upperCasedValue;
        Preconditions.checkNotNull(value, "value cannot be null");
        switch (upperCasedValue = value.toUpperCase(Locale.ROOT)) {
            case "ANSI": {
                return ANSI;
            }
            case "ODBC": {
                return ODBC;
            }
            case "SPARK": {
                return SPARK;
            }
        }
        return new SqlDialect(Value.UNKNOWN, upperCasedValue);
    }

    public <T> T accept(Visitor<T> visitor) {
        switch (this.value) {
            case ANSI: {
                return visitor.visitAnsi();
            }
            case ODBC: {
                return visitor.visitOdbc();
            }
            case SPARK: {
                return visitor.visitSpark();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    public static List<SqlDialect> values() {
        return values;
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface SparkStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> visitSpark(@Nonnull Supplier<T> var1);
    }

    public static interface OdbcStageVisitorBuilder<T> {
        public SparkStageVisitorBuilder<T> visitOdbc(@Nonnull Supplier<T> var1);
    }

    public static interface AnsiStageVisitorBuilder<T> {
        public OdbcStageVisitorBuilder<T> visitAnsi(@Nonnull Supplier<T> var1);
    }

    private static final class VisitorBuilder<T>
    implements AnsiStageVisitorBuilder<T>,
    OdbcStageVisitorBuilder<T>,
    SparkStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Supplier<T> ansiVisitor;
        private Supplier<T> odbcVisitor;
        private Supplier<T> sparkVisitor;
        private Function<@Safe String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public OdbcStageVisitorBuilder<T> visitAnsi(@Nonnull Supplier<T> ansiVisitor) {
            Preconditions.checkNotNull(ansiVisitor, "ansiVisitor cannot be null");
            this.ansiVisitor = ansiVisitor;
            return this;
        }

        @Override
        public SparkStageVisitorBuilder<T> visitOdbc(@Nonnull Supplier<T> odbcVisitor) {
            Preconditions.checkNotNull(odbcVisitor, "odbcVisitor cannot be null");
            this.odbcVisitor = odbcVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> visitSpark(@Nonnull Supplier<T> sparkVisitor) {
            Preconditions.checkNotNull(sparkVisitor, "sparkVisitor cannot be null");
            this.sparkVisitor = sparkVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> visitUnknown(@Nonnull Function<@Safe String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownType -> unknownVisitor.apply((String)unknownType);
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'SqlDialect' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Supplier<T> ansiVisitor = this.ansiVisitor;
            final Supplier<T> odbcVisitor = this.odbcVisitor;
            final Supplier<T> sparkVisitor = this.sparkVisitor;
            final Function<@Safe String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitAnsi() {
                    return ansiVisitor.get();
                }

                @Override
                public T visitOdbc() {
                    return odbcVisitor.get();
                }

                @Override
                public T visitSpark() {
                    return sparkVisitor.get();
                }

                @Override
                public T visitUnknown(String unknownType) {
                    return unknownVisitor.apply(unknownType);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitAnsi();

        public T visitOdbc();

        public T visitSpark();

        public T visitUnknown(String var1);

        public static <T> AnsiStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }

    public static enum Value {
        ANSI,
        ODBC,
        SPARK,
        UNKNOWN;

    }
}

